/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.SubDom;
import JSim.plan2.AbortXcept;
import JSim.plan2.TModel;
import JSim.util.DiagInfo;
import JSim.util.Xcept;

public class TSubDom
implements DiagInfo {
    private TModel model;
    private int type;
    private Domain x;
    private int hashCode;
    public static final int ENTIRE = 1;
    public static final int LHBC = 2;
    public static final int RHBC = 3;

    public TSubDom(TModel model, int type, Domain x) throws Xcept {
        this.model = model;
        this.type = type;
        this.x = x;
        this.hashCode = type;
        if (x != null) {
            this.hashCode += 10 * x.domInx();
        }
    }

    public TSubDom(TModel model, SubDom sd) throws Xcept {
        this.model = model;
        if (sd.isEntire()) {
            this.type = 1;
            return;
        }
        int n = this.type = sd.isLHBC() ? 2 : 3;
        if (sd.bcDomain() == null) {
            throw new AbortXcept("Unsupported when clause: " + sd);
        }
        this.x = model.domain(sd.bcDomain());
        this.hashCode = this.type;
        if (this.x != null) {
            this.hashCode += 10 * this.x.domInx();
        }
    }

    public TModel model() {
        return this.model;
    }

    public boolean isEntire() {
        return this.type == 1;
    }

    public boolean isLH() {
        return this.type == 2;
    }

    public boolean isRH() {
        return this.type == 3;
    }

    public Domain domain() {
        return this.x;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(TSubDom sd) {
        return this.type == sd.type && this.x == sd.x;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "entire";
            }
            case 2: {
                return "" + (Object)((Object)this.x) + "=" + (Object)((Object)this.x) + ".min";
            }
            case 3: {
                return "" + (Object)((Object)this.x) + "=" + (Object)((Object)this.x) + ".max";
            }
        }
        return "unknown_subdom";
    }

    public String diagInfo() {
        return this.toString();
    }
}

