/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.IntNVar;
import JSim.mml.NVar;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.plan2.DomainSet;
import JSim.plan2.ExprTool;
import JSim.plan2.Logger;
import JSim.plan2.SeqItem;
import JSim.plan2.TEqn;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public abstract class Tool
implements SeqItem {
    public TModel model;
    public VarUsages vsols;
    public VarUsages vreqs;
    public DomainSet seqLoops;
    public ArrayList<TEqn> eqns;
    public LinkedHashSet<Tool> icTools;
    public static final int QUERY = 0;
    public static final int CURR = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int XEXPR = 5;
    public static final int DELAY = 4;
    public static final int EXPR = 6;

    public Tool(TModel model) throws Xcept {
        this.model = model;
        this.vsols = new VarUsages(model);
        this.vreqs = new VarUsages(model);
        this.eqns = new ArrayList();
    }

    protected void setSeqLoops() throws Xcept {
        VarUsage vu0 = null;
        for (int i = 0; i < this.vsols.size(); ++i) {
            VarUsage vu = this.vsols.get(i);
            DomainSet vloops = vu.seqLoops();
            if (this.seqLoops == null) {
                vu0 = vu;
                this.seqLoops = vloops;
            }
            if (this.seqLoops.equals(vloops)) continue;
            this.logger().error("Can't sequence " + this + ": solved vars " + vu0 + this.seqLoops + " and " + vu + vloops + " have incompatible domains.");
            return;
        }
        DomainSet rloops = new DomainSet();
        for (int i = 0; i < this.vreqs.size(); ++i) {
            VarUsage vu = this.vreqs.get(i);
            vu.addSeqLoops(rloops);
            rloops.removeAll(this.seqLoops);
            if (rloops.size() == 0) continue;
            this.logger().error("Can't sequence " + this + ": source var " + vu + " has free domain(s) " + rloops + " missing in solved var(s): " + this.vsols);
            return;
        }
    }

    protected void createICParms() throws Xcept {
        ArrayList<Tool> tools = new ArrayList<Tool>(this.icTools);
        this.icTools = new LinkedHashSet();
        for (int i = 0; i < tools.size(); ++i) {
            this.icTools.add(this.createICParm(tools.get(i)));
        }
    }

    private Tool createICParm(Tool tool) throws Xcept {
        if (!(tool instanceof ExprTool)) {
            return tool;
        }
        ExprTool xtool = (ExprTool)tool;
        VarUsage vu = xtool.vu;
        Var v = vu.v();
        if (v.isPrivate()) {
            return tool;
        }
        TExpr expr = xtool.expr;
        if (expr.usages().size() > 0) {
            return tool;
        }
        String vinitName = v.toString() + "__init";
        if (this.model.var(vinitName = vinitName.replace(':', '_')) != null) {
            return tool;
        }
        Expr.List doms = new Expr.List();
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            if (x == vu.domain()) continue;
            doms.add((Object)x);
        }
        NVar vinit = v.isInt() ? new IntNVar(this.model.math, vinitName, doms) : new RealNVar(this.model.math, vinitName, doms);
        Unit unit = v.unit();
        if (unit != null) {
            vinit.setUnit(unit);
        }
        this.model.updateVarMaps();
        VarUsage vinitu = new VarUsage(this.model, (Var)vinit);
        expr = new TExpr(this.model, expr.expr());
        ExprTool vinitTool = new ExprTool(vinitu, expr);
        this.model.plan.box().addTool(vinitTool);
        TExpr tvinit = new TExpr(this.model, (Expr)vinit);
        return new ExprTool(vu, tvinit);
    }

    protected boolean needsICs() {
        return false;
    }

    protected boolean isComplete() {
        return true;
    }

    protected Tool derivTool(Domain x) throws Xcept {
        return null;
    }

    public Logger logger() {
        return this.model.logger();
    }

    public void log(String msg) {
        this.logger().log(msg);
    }

    public Domain t() {
        return null;
    }

    public DomainSet seqLoops() {
        return this.seqLoops;
    }

    public VarUsages vreqs() {
        return this.vreqs;
    }

    public String nodeString() {
        return this.vsols.nodeString();
    }

    public abstract String toolType();
}

