/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.DECon;
import JSim.plan2.DETool;
import JSim.plan2.DerivBuilder;
import JSim.plan2.DomainTool;
import JSim.plan2.ExprTool;
import JSim.plan2.ExternTool;
import JSim.plan2.ImplicitPool;
import JSim.plan2.ImplicitTool;
import JSim.plan2.Logger;
import JSim.plan2.Plan;
import JSim.plan2.ProcTool;
import JSim.plan2.StateTool;
import JSim.plan2.TEqn;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBox {
    public Plan plan;
    public TModel model;
    public ArrayList<Tool> tools;
    private LinkedHashSet<Var> knownEntire;
    private VarUsages knownPartial;
    private Hashtable<TSubDom, LinkedHashSet<TEqn>> usedEqns;
    protected Hashtable<Var, Tool> mainTools;
    protected Hashtable<Object, DECon> deconMap;
    protected DerivBuilder derivBuilder;
    private boolean isWorking;

    public ToolBox(Plan plan) throws Xcept {
        this.plan = plan;
        this.model = plan.model();
        this.tools = new ArrayList();
        this.knownEntire = new LinkedHashSet();
        this.knownPartial = new VarUsages(this.model);
        this.mainTools = new Hashtable();
        this.deconMap = new Hashtable();
        this.usedEqns = new Hashtable();
        this.usedEqns.put(this.model.entire, new LinkedHashSet());
        this.derivBuilder = new DerivBuilder(this);
    }

    protected void build() throws Xcept {
        int i;
        int i2;
        this.log("\nToolbox phase starting ...");
        for (i2 = 0; i2 < this.model.vars.size(); ++i2) {
            Var v = this.model.vars.get(i2);
            if (v.isExtern()) {
                this.addTool(new ExternTool(this.model, v));
                continue;
            }
            if (v.isState()) {
                this.addTool(new StateTool(this.model, v));
                continue;
            }
            if (!v.isDomain()) continue;
            this.addTool(new DomainTool(this.model, v));
        }
        for (i2 = 0; i2 < this.model.procs.size(); ++i2) {
            this.addTool(new ProcTool(this.model, this.model.procs.get(i2)));
        }
        this.isWorking = true;
        while (this.isWorking && !this.allVarsSolved()) {
            this.isWorking = false;
            this.buildCycle1();
            if (this.isWorking) continue;
            if (this.allVarsSolved() || this.allEqnsUsed()) break;
            this.buildCycle2();
            if (this.isWorking) continue;
            this.buildCycle3();
            if (this.isWorking) continue;
            this.buildCycle4();
        }
        this.log("Toolbox phase - all cycles completed");
        if (this.plan.allowMissingDomainControls()) {
            for (i2 = 0; i2 < this.model.ndomains(); ++i2) {
                Domain x = this.model.doms.get(i2);
                this.setExtern(x.vmin);
                this.setExtern(x.vmax);
                this.setExtern(x.vdelta);
            }
        }
        if (this.plan.allowMissingICs()) {
            // empty if block
        }
        if (this.plan.allowOrphanICs()) {
            // empty if block
        }
        for (i2 = 0; i2 < this.tools.size(); ++i2) {
            Tool tool = this.tools.get(i2);
            if (tool.isComplete()) continue;
            String msg = tool instanceof DETool ? ((DETool)tool).incompleteMessage() : "state variable IC missing";
            this.logger().error(msg);
        }
        ArrayList<Var> unsolvedVars = new ArrayList<Var>();
        for (int i3 = 0; i3 < this.model.vars.size(); ++i3) {
            Var v = this.model.vars.get(i3);
            if (v.isDeriv() || this.isKnown(v)) continue;
            unsolvedVars.add(v);
        }
        if (unsolvedVars.size() > 0) {
            this.logger().error("Could not entirely solve variable(s) " + unsolvedVars);
        }
        int code = this.plan.ignoreUnusedEquations() ? 1 : 2;
        for (i = 0; i < this.model.eqns.size(); ++i) {
            TEqn eqn = this.model.eqns.get(i);
            if (this.isUsed(eqn, this.model.entire)) continue;
            String msg = unsolvedVars.size() == 0 ? "Equation unneeded, overspecifies model" : "Equation could not be processed";
            this.logger().log(code, msg + ": " + eqn);
        }
        for (i = 0; i < this.tools.size(); ++i) {
            Tool tool = this.tools.get(i);
            if (tool instanceof DETool && this.plan.makeDEICParms()) {
                tool.createICParms();
            }
            if (tool instanceof StateTool && this.plan.makeStateICParms()) {
                tool.createICParms();
            }
            if (!(tool instanceof DETool)) continue;
            ((DETool)tool).positFirstSpatialDerivs(this);
        }
        if (this.logger().errors.size() == 0) {
            for (i = 0; i < this.tools.size(); ++i) {
                if (!(this.tools.get(i) instanceof DETool)) continue;
                DETool detool = (DETool)this.tools.get(i);
                detool.createFactors();
                this.derivBuilder.makePDEFactorTools(detool);
            }
        }
    }

    private void setExtern(Var v) throws Xcept {
        if (this.isKnown(v)) {
            return;
        }
        this.addTool(new ExternTool(this.model, v));
        this.logger().warn("Unconstraint variable " + (Object)((Object)v) + " set to extern");
    }

    private boolean allEqnsUsed() {
        for (int i = 0; i < this.model.eqns.size(); ++i) {
            if (this.isUsed(this.model.eqns.get(i), this.model.entire)) continue;
            return false;
        }
        return true;
    }

    private boolean allVarsSolved() {
        for (int i = 0; i < this.model.vars.size(); ++i) {
            if (this.isKnown(this.model.vars.get(i))) continue;
            return false;
        }
        return true;
    }

    private void buildCycle1() throws Xcept {
        int i;
        this.log("Toolbox phase - cycle 1:");
        for (i = 0; i < this.model.eqns.size(); ++i) {
            this.buildOneVarEqn(this.model.eqns.get(i), this.model.entire);
        }
        for (i = 0; i < this.tools.size(); ++i) {
            this.buildToolDECon(this.tools.get(i));
        }
        for (i = 0; i < this.model.vars.size(); ++i) {
            this.buildDerivTool(this.model.vars.get(i));
        }
    }

    private void buildCycle2() throws Xcept {
        this.log("Toolbox phase - cycle 2:");
        ImplicitPool pool = new ImplicitPool(this);
        ImplicitTool tool = pool.makeTool(this.model.entire);
        if (tool == null) {
            return;
        }
        this.addTool(tool);
        for (int i = 0; i < tool.eqns.size(); ++i) {
            this.setUsed((TEqn)tool.eqns.get(i), this.model.entire);
        }
    }

    private void buildCycle3() throws Xcept {
        this.log("Toolbox phase - cycle 3:");
        for (int i = 0; i < this.model.eqns.size(); ++i) {
            TEqn eqn = this.model.eqns.get(i);
            this.buildEqnDECon(eqn, this.model.entire);
        }
    }

    private void buildCycle4() throws Xcept {
        this.log("Toolbox phase - cycle 4:");
        for (int i = 0; i < this.model.eqns.size(); ++i) {
            TEqn eqn = this.model.eqns.get(i);
            this.buildEqnBC(eqn, this.model.entire);
            if (this.isWorking) break;
        }
    }

    private void buildOneVarEqn(TEqn eqn, TSubDom sd) throws Xcept {
        if (this.isUsed(eqn, sd)) {
            return;
        }
        VarUsages vus = eqn.usages();
        if (!sd.isEntire()) {
            vus = vus.restrict(sd);
        }
        vus = this.unknown(vus, 2);
        this.log("  check eqn: " + eqn + "; " + vus);
        if (vus.nvars() > 1) {
            return;
        }
        if (vus.size() < 1) {
            throw new AbortXcept("Equation overspecifies model: " + eqn);
        }
        VarUsage vu = vus.get(0);
        if (vus.size() > 1 || !vu.isSolvable()) {
            return;
        }
        TExpr vexpr = eqn.expr().solveFor(vu.v());
        Tool tool = vexpr != null ? new ExprTool(vu, vexpr) : new ImplicitTool(vu, eqn.expr());
        tool.eqns.add(eqn);
        this.addTool(tool);
        this.setUsed(eqn, sd);
    }

    private void buildToolDECon(Tool tool) throws Xcept {
        if (tool.needsICs()) {
            return;
        }
        if (this.deconMap.get(tool) != null) {
            return;
        }
        VarUsages vus = this.deconVarUsages(tool.vsols);
        if (vus.size() < 1) {
            return;
        }
        DECon con = new DECon(vus, tool);
        this.addDECon(con);
        this.deconMap.put(tool, con);
    }

    private void buildEqnDECon(TEqn eqn, TSubDom sd) throws Xcept {
        if (this.isUsed(eqn, sd)) {
            return;
        }
        VarUsages vus = eqn.usages();
        if (!sd.isEntire()) {
            vus = vus.restrict(sd);
        }
        vus = this.unknown(vus, vus.size());
        if ((vus = this.deconVarUsages(vus)).size() < 2) {
            return;
        }
        DECon con = new DECon(vus, eqn);
        if (con.isBC() && con.v0s().size() > 2) {
            return;
        }
        this.addDECon(con);
        this.deconMap.put(eqn, con);
        this.setUsed(eqn, sd);
        Tool tool = con.tool();
        if (tool != null) {
            this.addTool(tool);
            this.deconMap.put(tool, con);
        }
    }

    private void buildEqnBC(TEqn eqn, TSubDom sd) throws Xcept {
        if (this.isUsed(eqn, sd)) {
            return;
        }
        VarUsages vus = eqn.usages();
        if (!sd.isEntire()) {
            vus = vus.restrict(sd);
        }
        vus = this.unknown(vus, vus.size());
        vus = this.deconVarUsages(vus);
        VarUsage bcvu = null;
        for (int i = 0; i < vus.size(); ++i) {
            Var vx;
            VarUsage vu = vus.get(i);
            if (!vu.isBoundary() || (vx = vu.v()).derivOrder() != 1 || vu.domain() != vx.derivDomain() || this.model.pureChildDerivDoms.get((Object)vx.zeroDeriv()).size() < 2) continue;
            if (bcvu != null) {
                return;
            }
            bcvu = vu;
        }
        if (bcvu == null) {
            return;
        }
        vus = new VarUsages(this.model);
        vus.add(bcvu);
        DECon con = new DECon(vus, eqn);
        this.addDECon(con);
        this.deconMap.put(eqn, con);
        this.setUsed(eqn, sd);
    }

    private VarUsages deconVarUsages(VarUsages rawvus) throws Xcept {
        VarUsages vus = new VarUsages(this.model);
        for (int i = 0; i < rawvus.size(); ++i) {
            boolean vuok;
            boolean vok;
            VarUsage vu = rawvus.get(i);
            if (!vu.isSolvable()) continue;
            Var v = vu.v();
            Var v0 = v.zeroDeriv();
            Tool v0tool = this.mainTools.get((Object)v0);
            boolean bl = vok = v0tool instanceof DETool || v0tool == null && this.model.hasDeriv(v0);
            if (!vok) continue;
            boolean bl2 = vuok = vu.isBoundary() || v.isDeriv();
            if (!vuok) continue;
            vus.add(vu);
        }
        return vus;
    }

    private void addDECon(DECon con) throws Xcept {
        for (int i = 0; i < con.v0s().size(); ++i) {
            Var v = con.v0s().get(i);
            DETool detool = (DETool)this.mainTools.get((Object)v);
            if (detool == null) {
                detool = new DETool(this.model, v);
                this.addTool(detool);
            }
            this.log("  updated " + detool.deString() + "(" + (Object)((Object)v) + ") with " + con);
            detool.addCon(con);
            this.toolUpdated(detool);
        }
    }

    private void buildDerivTool(Var vx) throws Xcept {
        if (!vx.isDeriv()) {
            return;
        }
        if (this.isKnown(vx)) {
            return;
        }
        Var v = vx.unDeriv();
        Tool tool = this.mainTools.get((Object)v);
        if (tool == null) {
            return;
        }
        if (tool instanceof DETool) {
            return;
        }
        if (!tool.isComplete()) {
            return;
        }
        Domain x = vx.derivDomain();
        Tool xtool = tool.derivTool(x);
        if (xtool == null) {
            throw new AbortXcept("Can't solve " + (Object)((Object)vx) + " because can't differentiate " + tool + " with respect to " + (Object)((Object)x));
        }
        if (!this.plan.makeDerivTools()) {
            throw new AbortXcept("Symbolic derivatives not enabled: " + xtool);
        }
        this.addTool(xtool);
    }

    protected void addTool(Tool tool) throws Xcept {
        this.log("  add tool: " + tool);
        this.tools.add(tool);
        this.toolUpdated(tool);
        this.buildStateIC(tool);
    }

    protected void toolUpdated(Tool tool) throws Xcept {
        this.setKnown(tool);
        for (int i = 0; i < tool.vsols.size(); ++i) {
            VarUsage vu = tool.vsols.get(i);
            Var v = vu.v();
            if (vu.isBoundary()) continue;
            this.mainTools.put(v, tool);
        }
        this.updateDomainAux(tool);
        this.isWorking = true;
    }

    private void setKnown(Tool tool) throws Xcept {
        VarUsages vus = tool.vsols;
        boolean isComp = tool.isComplete();
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (vu.isCurr() && isComp) {
                this.knownEntire.add(vu.v());
                if (!tool.needsICs()) continue;
                this.log("    " + (Object)((Object)vu.v()) + " is now entirely solved");
                continue;
            }
            this.knownPartial.add(vu);
        }
    }

    protected boolean isKnown(Var v) {
        return this.knownEntire.contains((Object)v);
    }

    protected boolean isKnown(VarUsage vu) {
        Var v = vu.v();
        if (this.knownEntire.contains((Object)v)) {
            return true;
        }
        if (this.knownPartial.contains(vu)) {
            return true;
        }
        switch (vu.stat()) {
            case 2: 
            case 3: {
                return false;
            }
        }
        return this.knownPartial.hasCurr(v);
    }

    protected boolean isKnown(VarUsages vus) {
        for (int i = 0; i < vus.size(); ++i) {
            if (this.isKnown(vus.get(i))) continue;
            return false;
        }
        return true;
    }

    public VarUsages unknown(VarUsages src, int maxNVar) throws Xcept {
        VarUsages vus = new VarUsages(this.model);
        for (int i = 0; i < src.size(); ++i) {
            VarUsage vu = src.get(i);
            if (this.isKnown(vu)) continue;
            vus.add(vu);
            if (vus.nvars() >= maxNVar) break;
        }
        return vus;
    }

    private void buildStateIC(Tool tool) throws Xcept {
        if (tool.needsICs()) {
            return;
        }
        for (int i = 0; i < tool.vsols.size(); ++i) {
            Var v;
            VarUsage vu = tool.vsols.get(i);
            if (!vu.isSolvable() || !vu.isBoundary() || (v = vu.v()).isDeriv() || !(this.mainTools.get((Object)v) instanceof StateTool)) continue;
            StateTool stool = (StateTool)this.mainTools.get((Object)v);
            stool.setIC(tool);
            this.toolUpdated(stool);
        }
    }

    private void updateDomainAux(Tool tool) throws Xcept {
        for (int i = 0; i < tool.vsols.size(); ++i) {
            Var xaux = tool.vsols.get(i).v();
            Domain x = xaux.auxForDomain();
            if (x == null) continue;
            Tool mtool = this.mainTools.get((Object)x);
            if (!(mtool instanceof DomainTool)) {
                throw new Xcept("No DomainTool for " + (Object)((Object)x));
            }
            DomainTool domtool = (DomainTool)mtool;
            ExprTool auxtool = domtool.addAux(xaux);
            if (auxtool == null) continue;
            if (this.isKnown(auxtool.vsols)) {
                throw new AbortXcept("Domain " + (Object)((Object)x) + " overspecified by " + tool);
            }
            this.addTool(auxtool);
        }
    }

    protected boolean isUsed(TEqn eqn, TSubDom sd) {
        LinkedHashSet<TEqn> eset = this.usedEqns.get(this.model.entire);
        if (eset.contains(eqn)) {
            return true;
        }
        if (sd.isEntire()) {
            return false;
        }
        eset = this.usedEqns.get(sd);
        if (eset == null) {
            return false;
        }
        return eset.contains(eqn);
    }

    protected void setUsed(TEqn eqn, TSubDom sd) {
        LinkedHashSet<TEqn> eset = this.usedEqns.get(sd);
        if (eset == null) {
            eset = new LinkedHashSet();
            this.usedEqns.put(sd, eset);
        }
        eset.add(eqn);
    }

    public LinkedHashSet<Tool> seqTools() {
        ArrayList<Tool> mtools = new ArrayList<Tool>(this.mainTools.values());
        LinkedHashSet<Tool> tset = new LinkedHashSet<Tool>(mtools);
        for (int i = 0; i < mtools.size(); ++i) {
            Tool mtool = mtools.get(i);
            if (mtool.icTools == null) continue;
            tset.addAll(mtool.icTools);
        }
        return tset;
    }

    protected boolean isPDEFirstSpatialDeriv(VarUsage vu) throws Xcept {
        if (!vu.isCurr()) {
            return false;
        }
        Var v = vu.v();
        if (v.derivOrder() != 1) {
            return false;
        }
        Var v0 = v.zeroDeriv();
        if (!(this.mainTools.get((Object)v0) instanceof DETool)) {
            return false;
        }
        DETool detool = (DETool)this.mainTools.get((Object)v0);
        Domain x = v.derivDomain();
        return detool.xs.contains((Object)x);
    }

    public boolean isInput(Tool tool) {
        if (!this.plan.makeInputTools()) {
            return false;
        }
        if (tool instanceof ExternTool) {
            return true;
        }
        if (!(tool instanceof ExprTool)) {
            return false;
        }
        ExprTool xtool = (ExprTool)tool;
        if (xtool.vreqs.size() > 0) {
            return false;
        }
        if (!xtool.vu.isCurr()) {
            return false;
        }
        Var v = xtool.vu.v();
        if (v.isDeriv()) {
            return false;
        }
        return !v.isPrivate();
    }

    public Logger logger() {
        return this.plan.logger;
    }

    public void log(String msg) {
        this.logger().log(msg);
    }
}

