/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.DETool;
import JSim.plan2.DomainSet;
import JSim.plan2.Plan;
import JSim.plan2.PlanGraphML;
import JSim.plan2.TEvent;
import JSim.plan2.TModel;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.UnitTypes;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.Xcept;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarGraphML {
    private PlanGraphML gml;
    private Plan plan;
    private VarUsages vus;
    private Hashtable<VarUsage, Tool> vuTools;
    private HashSet<Edge> edges;
    private UnitTypes unitTypes;
    private StringList mprops;
    private Document doc;

    public VarGraphML(PlanGraphML gml) throws Xcept {
        this.gml = gml;
        this.plan = gml.plan;
        if (this.box() == null) {
            return;
        }
        this.vus = new VarUsages(this.model());
        this.vuTools = new Hashtable();
        ArrayList<Var> vs = this.model().vars;
        for (int i = 0; i < vs.size(); ++i) {
            Var v = vs.get(i);
            if (v.isDeriv()) continue;
            this.vus.add(v);
        }
        Iterator<Tool> tools = this.tools();
        while (tools.hasNext()) {
            Tool tool = tools.next();
            VarUsages vsols = tool.vsols;
            if (tool instanceof DETool) {
                DETool detool = (DETool)tool;
                vsols = new VarUsages(this.model());
                vsols.add(detool.v());
            }
            for (int i = 0; i < vsols.size(); ++i) {
                VarUsage vsol = vsols.get(i);
                this.vus.add(vsol);
                this.vuTools.put(vsol, tool);
            }
        }
        this.unitTypes = new UnitTypes(this.units());
        URL url = this.getClass().getResource("unittypes.txt");
        String txt = UtilIO.readText((URL)url);
        if (this.hasUnits()) {
            this.unitTypes.loadTypes(txt);
        }
        CompProp.List dprops = this.model().mmlModel().defProps;
        this.mprops = new StringList();
        for (int i = 0; i < dprops.size(); ++i) {
            CompProp dprop = (CompProp)((Object)dprops.get(i));
            this.mprops.add((Object)dprop.name());
        }
        this.edges = new LinkedHashSet<Edge>();
        tools = this.tools();
        while (tools.hasNext()) {
            Tool tool = tools.next();
            this.addEdges(tool.vreqs, tool.vsols);
        }
        for (int i = 0; i < this.events().size(); ++i) {
            TEvent event = this.events().get(i);
            this.addEdges(event.vreqs, event.vacts);
        }
    }

    private void addEdges(VarUsages vfroms, VarUsages vtos) {
        for (int i = 0; i < vtos.size(); ++i) {
            this.addEdges(vfroms, vtos.get(i));
        }
    }

    private void addEdges(VarUsages vfroms, VarUsage vto) {
        if (!this.vus.contains(vto)) {
            return;
        }
        for (int i = 0; i < vfroms.size(); ++i) {
            VarUsage vfrom = vfroms.get(i);
            if (!this.vus.contains(vfrom)) {
                vfrom = new VarUsage(this.model(), vfrom.v());
            }
            if (vfrom.equals(vto)) continue;
            Edge edge = new Edge(this.id(vfrom), this.id(vto));
            this.edges.add(edge);
        }
    }

    protected void loadGraph(Document doc) throws Xcept {
        if (this.box() == null) {
            return;
        }
        this.doc = doc;
        Element g = this.gml.addGraph(doc.getDocumentElement(), "variables");
        g.setAttribute("style", "variables");
        this.addNodeKeys(g);
        for (int i = 0; i < this.vus.size(); ++i) {
            VarUsage vu = this.vus.get(i);
            Tool tool = this.vuTools.get(vu);
            this.addNode(g, vu, tool);
        }
        for (Edge e : this.edges) {
            this.gml.addEdge(g, e.n1, e.n2);
        }
    }

    private void addNodeKeys(Element g) {
        int i;
        this.gml.addNodeKey(g, "name");
        this.gml.addNodeKey(g, "variable");
        this.gml.addNodeKey(g, "dataType");
        this.gml.addNodeKey(g, "domains");
        this.gml.addNodeKey(g, "isPrivate", "boolean");
        this.gml.addNodeKey(g, "isInput", "boolean");
        this.gml.addNodeKey(g, "toolType");
        this.gml.addNodeKey(g, "toolText");
        this.gml.addNodeKey(g, "eventText");
        if (this.hasUnits()) {
            this.gml.addNodeKey(g, "unit");
            this.gml.addNodeKey(g, "unitType");
        }
        for (i = 0; i < this.domains().size(); ++i) {
            this.gml.addNodeKey(g, "hasDomain." + (Object)((Object)this.domains().get(i)), "boolean");
        }
        for (i = 0; i < this.mprops.size(); ++i) {
            this.gml.addNodeKey(g, "property." + (String)this.mprops.get(i));
        }
    }

    private void addNode(Element g, VarUsage vu, Tool tool) throws Xcept {
        LinkedHashSet<TEvent> eventSet;
        CompProp.List props;
        DomainSet xs;
        String dt;
        Element e = this.gml.addNode(g, this.id(vu), vu.toString());
        Var v = vu.v();
        Var v0 = v.zeroDeriv();
        Domain t = v0.auxForDomain();
        if (t != null) {
            v0 = t;
        }
        if (v != v0) {
            this.gml.addData(e, "variable", v0.toString());
        }
        String string = dt = v.isInt() ? "int" : "real";
        if (v.isDomain()) {
            dt = dt + "Domain";
        }
        if (v.isState()) {
            dt = dt + "State";
        }
        this.gml.addData(e, "dataType", dt);
        if (v.isPrivate()) {
            this.gml.addData(e, "isPrivate", "true");
        }
        if (this.box().isInput(tool)) {
            this.gml.addData(e, "isInput", "true");
        }
        if (tool == null) {
            this.gml.addData(e, "toolType", "unsolved");
            return;
        }
        this.gml.addData(e, "toolType", tool.toolType());
        this.gml.addData(e, "toolText", tool.toString());
        Unit u = v.unit();
        if (u != null) {
            this.gml.addData(e, "unit", u.pubName());
            if (this.unitTypes != null) {
                String utype = this.unitTypes.getType(u);
                this.gml.addData(e, "unitType", utype);
            }
        }
        if (v.ndim() > 0) {
            this.gml.addData(e, "domains", v.domainList().toString());
        }
        if ((xs = this.model().domSets.get((Object)v)) != null) {
            for (int i = 0; i < this.domains().size(); ++i) {
                Domain x = this.domains().get(i);
                if (!v.hasDomain(x)) continue;
                this.gml.addData(e, "hasDomain." + (Object)((Object)x), "true");
            }
        }
        if ((props = v.props) != null) {
            for (int i = 0; i < props.size(); ++i) {
                CompProp prop = (CompProp)((Object)props.get(i));
                String pval = prop.stringVal(null);
                if (Util.isBlank((String)pval)) continue;
                this.gml.addData(e, "property." + prop.name(), pval);
            }
        }
        if ((eventSet = this.vuEvents(vu)) != null) {
            String text = "";
            for (TEvent event : eventSet) {
                text = text + event + ";";
            }
            this.gml.addData(e, "eventText", text);
        }
    }

    private String id(VarUsage vu) {
        return "VID#" + vu;
    }

    private TModel model() {
        return this.plan.model();
    }

    private UnitNList units() {
        return this.model().units();
    }

    private boolean hasUnits() {
        return this.units().size() > 7;
    }

    private ToolBox box() {
        return this.plan.box();
    }

    private ArrayList<TEvent> events() {
        return this.model().events;
    }

    private LinkedHashSet<TEvent> vuEvents(VarUsage vu) {
        return this.model().vuEvents.get(vu);
    }

    private ArrayList<Domain> domains() {
        return this.model().doms;
    }

    private Iterator<Tool> tools() {
        return this.box().seqTools().iterator();
    }

    public static class Edge {
        String n1;
        String n2;

        public Edge(String n1, String n2) {
            this.n1 = n1;
            this.n2 = n2;
        }

        public int compare(Edge e) {
            return 0;
        }

        public boolean equals(Object o) {
            Edge e = (Edge)o;
            return this.n1.equals(e.n1) && this.n2.equals(e.n2);
        }

        public String toString() {
            return this.n1 + "->" + this.n2;
        }

        public int hashCode() {
            return this.n1.hashCode() + this.n2.hashCode();
        }
    }
}

