/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.plan2.DomainSet;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.util.Expr;
import JSim.util.NamedQueryExpr;
import JSim.util.Xcept;

public class VarUsage {
    private TModel model;
    private Var v;
    private int stat;
    private Domain domain;
    private int[] qstat;
    private boolean solvable;
    private int hashCode;
    private NamedQueryExpr qexpr;
    public static final int QUERY = 0;
    public static final int CURR = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int DELAY = 4;
    public static final int XEXPR = 5;
    public static final int EXPR = 6;
    public static final int ABSENT = -1;

    public VarUsage(TModel model, Var v) {
        this.model = model;
        this.v = v;
        this.stat = 1;
        this.solvable = true;
        this.calcHash();
        model.vus.add(this);
    }

    public VarUsage(TSubDom sd, Var v) {
        this.model = sd.model();
        this.v = v;
        this.domain = sd.domain();
        this.stat = 1;
        if (this.domain != null && v.hasDomain(this.domain)) {
            this.stat = sd.isLH() ? 2 : 3;
        }
        this.solvable = true;
        this.calcHash();
        this.model.vus.add(this);
    }

    public VarUsage(TModel model, Var v, int stat, Domain x) {
        this.model = model;
        this.v = v;
        this.stat = stat;
        this.domain = x;
        this.solvable = true;
        this.calcHash();
        model.vus.add(this);
    }

    public VarUsage(TModel model, Var v, int[] qstat) throws Xcept {
        this.model = model;
        this.v = v;
        this.stat = 1;
        this.solvable = true;
        if (qstat.length != v.ndim()) {
            throw new Xcept("VarUsage qstat dimensional mismatch");
        }
        block4: for (int i = 0; i < qstat.length; ++i) {
            switch (qstat[i]) {
                case -1: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 3: {
                    this.stat = this.stat == 1 ? qstat[i] : 0;
                    this.domain = v.domain(i);
                    continue block4;
                }
                default: {
                    this.stat = 0;
                }
            }
        }
        if (this.stat == 0) {
            this.qstat = qstat;
            this.domain = null;
            this.solvable = false;
        }
        this.calcHash();
        model.vus.add(this);
    }

    private void calcHash() {
        this.hashCode = this.v.hashCode();
        int mult = 10000;
        for (int i = 0; i < this.v.ndim(); ++i) {
            Domain x = this.v.domain(i);
            this.hashCode += mult * this.qstat(x);
            mult *= 10;
        }
    }

    protected void setUnsolvable() {
        this.solvable = false;
    }

    public VarUsage restrict(TSubDom sd) throws Xcept {
        if (sd.isEntire()) {
            return this;
        }
        Domain x = sd.domain();
        int xinx = this.indexOf(x);
        if (xinx < 0) {
            return this;
        }
        if (this.qstat(x) != 1) {
            return this;
        }
        int xstat = sd.isLH() ? 2 : 3;
        int[] nqstat = new int[this.v.ndim()];
        for (int i = 0; i < nqstat.length; ++i) {
            nqstat[i] = i == xinx ? xstat : this.qstat(this.v.domain(i));
        }
        VarUsage vu = new VarUsage(this.model, this.v, nqstat);
        if (!this.solvable) {
            vu.setUnsolvable();
        }
        return vu;
    }

    protected VarUsage deriv(Domain x) throws Xcept {
        if (!this.v.hasDomain(x)) {
            return null;
        }
        if (this.stat == 0) {
            return null;
        }
        if (this.domain == x) {
            return null;
        }
        Var vx = this.v.deriv(x);
        this.model.updateVarMaps();
        return new VarUsage(this.model, vx, this.stat, this.domain);
    }

    protected DomainSet seqLoops() throws Xcept {
        DomainSet seqLoops = new DomainSet();
        this.addSeqLoops(seqLoops);
        return seqLoops;
    }

    protected void addSeqLoops(DomainSet seqLoops) throws Xcept {
        for (int i = 0; i < this.v.ndim(); ++i) {
            Domain x = this.v.domain(i);
            int q = this.qstat(x);
            if (q == 2 || q == 3 || q == 6) continue;
            seqLoops.add(x);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof VarUsage)) {
            return false;
        }
        VarUsage vu = (VarUsage)o;
        if (this.v != vu.v) {
            return false;
        }
        if (this.stat != vu.stat) {
            return false;
        }
        if (this.domain != vu.domain) {
            return false;
        }
        if (this.stat == 0) {
            for (int i = 0; i < this.qstat.length; ++i) {
                if (this.qstat[i] == vu.qstat[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String nodeString() {
        String s = this.v.toString();
        switch (this.stat) {
            case 1: {
                break;
            }
            case 2: {
                if (this.v.isDomain()) {
                    s = s + "(min)";
                    break;
                }
                s = s + "(" + (Object)((Object)this.domain) + ".min)";
                break;
            }
            case 3: {
                if (this.v.isDomain()) {
                    s = s + "(max)";
                    break;
                }
                s = s + "(" + (Object)((Object)this.domain) + ".max)";
                break;
            }
            default: {
                int ct = 0;
                for (int i = 0; i < this.qstat.length; ++i) {
                    Domain x = this.v.domain(i);
                    String tok = "" + (Object)((Object)x);
                    switch (this.qstat[i]) {
                        case 1: {
                            tok = null;
                            break;
                        }
                        case 2: {
                            tok = tok + ".min";
                            break;
                        }
                        case 3: {
                            tok = tok + ".max";
                            break;
                        }
                        case 4: {
                            tok = tok + ".delay";
                            break;
                        }
                        case 5: {
                            tok = tok + ".xexpr";
                            break;
                        }
                        case 6: {
                            tok = tok + ".expr";
                            break;
                        }
                        default: {
                            tok = tok + ".???";
                        }
                    }
                    if (tok == null) continue;
                    s = s + (ct == 0 ? "(" : ",");
                    s = s + tok;
                    ++ct;
                }
                if (ct <= 0) break;
                s = s + ")";
            }
        }
        return s;
    }

    public NamedQueryExpr qexpr() throws Xcept {
        if (this.qexpr != null) {
            return this.qexpr;
        }
        if (this.stat == 1) {
            this.qexpr = this.v;
        } else if (this.stat == 2 || this.stat == 3) {
            Expr.List args = new Expr.List();
            for (int i = 0; i < this.v.ndim(); ++i) {
                Domain x;
                Var arg = x = this.v.domain(i);
                if (x == this.domain) {
                    arg = this.stat == 2 ? x.vmin : x.vmax;
                }
                args.add((Object)arg);
            }
            this.qexpr = new VarFuncCall(this.v, args);
        } else {
            throw new Xcept("VarUsage: No qexpr available for " + this);
        }
        return this.qexpr;
    }

    public String toString() {
        String s = this.nodeString();
        if (!this.solvable) {
            s = s + "*";
        }
        return s;
    }

    public TModel model() {
        return this.model;
    }

    public Var v() {
        return this.v;
    }

    public int stat() {
        return this.stat;
    }

    public Domain domain() {
        return this.domain;
    }

    private int indexOf(Domain x) {
        return this.v.domainList().indexOf((Object)x);
    }

    public int qstat(Domain x) {
        switch (this.stat) {
            case 1: {
                return 1;
            }
            case 2: {
                return this.domain == x ? 2 : 1;
            }
            case 3: {
                return this.domain == x ? 3 : 1;
            }
        }
        int inx = this.indexOf(x);
        return inx < 0 ? -1 : this.qstat[inx];
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isCurr() {
        return this.stat == 1;
    }

    public boolean isCurr(Var v) {
        return v == this.v && this.stat == 1;
    }

    public boolean isBoundary() {
        return this.stat == 2 || this.stat == 3;
    }

    public boolean isMin() {
        return this.stat == 2;
    }

    public boolean isMin(Domain x) {
        return this.stat == 2 && this.domain == x;
    }

    public boolean isSolvable() {
        return this.solvable;
    }
}

