/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.DomainSet;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.plan2.VarUsage;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarUsages {
    private TModel model;
    private LinkedHashSet<VarUsage> vuset;
    private ArrayList<VarUsage> vuarr;
    private LinkedHashSet<Var> vset;

    public VarUsages(TModel model) throws Xcept {
        this.model = model;
        this.vuset = new LinkedHashSet();
        this.vuarr = new ArrayList();
        this.vset = new LinkedHashSet();
    }

    public VarUsages(VarUsage vu) throws Xcept {
        this(vu.model());
        this.add(vu);
    }

    public VarUsages(VarUsages vus) throws Xcept {
        this(vus.model());
        for (int i = 0; i < vus.size(); ++i) {
            this.add(vus.get(i));
        }
    }

    public VarUsages(TModel model, Expr[] exprs) throws Xcept {
        this(model);
        for (int i = 0; i < exprs.length; ++i) {
            TExpr texpr = new TExpr(model, exprs[i]);
            this.add(texpr.usages());
        }
    }

    public void add(Var v) throws Xcept {
        this.add(v, 1, null);
    }

    public void add(Var v, int stat) throws Xcept {
        this.add(v, stat, null);
    }

    public void add(Var v, int stat, Domain x) throws Xcept {
        this.add(new VarUsage(this.model, v, stat, x));
    }

    public void add(VarUsage vu) throws Xcept {
        if (this.vuset.contains(vu)) {
            return;
        }
        this.vuset.add(vu);
        this.vuarr.add(vu);
        this.vset.add(vu.v());
    }

    public void add(VarUsages vus) throws Xcept {
        for (int i = 0; i < vus.size(); ++i) {
            this.add(vus.get(i));
        }
    }

    public void add(DomainSet xset) throws Xcept {
        Iterator xs = xset.iterator();
        while (xs.hasNext()) {
            this.add((Var)((Object)xs.next()));
        }
    }

    public void add(Collection<Var> vs) throws Xcept {
        Iterator<Var> vit = vs.iterator();
        while (vit.hasNext()) {
            this.add(vit.next());
        }
    }

    public Var vtmax(Var v, Domain t) throws Xcept {
        Var vtmax = null;
        for (int i = 0; i < this.size(); ++i) {
            Var vx;
            VarUsage vu = this.get(i);
            if (!vu.isCurr() || !(vx = vu.v()).isDeriv() || vx.zeroDeriv() != v || this.model.pureDerivDom(vx) != t || vtmax != null && vx.derivOrder() <= vtmax.derivOrder()) continue;
            vtmax = vx;
        }
        return vtmax;
    }

    public VarUsage firstForVar(Var v) {
        for (int i = 0; i < this.size(); ++i) {
            VarUsage vu = this.get(i);
            if (vu.v() != v) continue;
            return vu;
        }
        return null;
    }

    public TModel model() {
        return this.model;
    }

    public int size() {
        return this.vuset.size();
    }

    public int nvars() {
        return this.vset.size();
    }

    public LinkedHashSet<Var> vset() {
        return this.vset;
    }

    public VarUsage get(int i) {
        return this.vuarr.get(i);
    }

    public String toString() {
        return this.vuarr.toString();
    }

    public boolean hasVar(Var v) {
        return this.vset.contains((Object)v);
    }

    public boolean contains(VarUsage vu) {
        return this.vuset.contains(vu);
    }

    public boolean hasCurr(Var v) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isCurr(v)) continue;
            return true;
        }
        return false;
    }

    public boolean areSolvable() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isSolvable()) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Var> varList() throws Xcept {
        return new ArrayList<Var>(this.vset);
    }

    public String nodeString() {
        if (this.size() == 1) {
            return this.get(0).nodeString();
        }
        if (this.size() == 0) {
            return "[]";
        }
        String s = this.get(0).toString();
        for (int i = 1; i < this.size(); ++i) {
            s = s + "," + this.get(i).nodeString();
        }
        return s;
    }

    public VarUsages minus(VarUsages bs) throws Xcept {
        VarUsages as = new VarUsages(this.model);
        for (int i = 0; i < this.size(); ++i) {
            VarUsage vu = this.get(i);
            if (bs.vuset.contains(vu)) continue;
            as.add(vu);
        }
        return as;
    }

    public VarUsages xsect(VarUsages bs) throws Xcept {
        VarUsages as = new VarUsages(this.model);
        for (int i = 0; i < this.size(); ++i) {
            VarUsage vu = this.get(i);
            if (!bs.vuset.contains(vu)) continue;
            as.add(vu);
        }
        return as;
    }

    public VarUsages restrict(TSubDom sd) throws Xcept {
        VarUsages vus = new VarUsages(this.model);
        for (int i = 0; i < this.size(); ++i) {
            VarUsage vu = this.get(i);
            vu = vu.restrict(sd);
            vus.add(vu);
        }
        return vus;
    }

    protected DomainSet seqLoops() throws Xcept {
        DomainSet seqLoops = new DomainSet();
        this.addSeqLoops(seqLoops);
        return seqLoops;
    }

    protected void addSeqLoops(DomainSet seqLoops) throws Xcept {
        for (int i = 0; i < this.vuarr.size(); ++i) {
            this.vuarr.get(i).addSeqLoops(seqLoops);
        }
    }
}

