/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.data.XMLWriter;
import JSim.mathml.MLWriter;
import JSim.mml.ChoiceNVar;
import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.MathSys;
import JSim.mml.Var;
import JSim.plan2.DECon;
import JSim.plan2.DETool;
import JSim.plan2.DomainSet;
import JSim.plan2.ExprTool;
import JSim.plan2.ImplicitTool;
import JSim.plan2.Plan;
import JSim.plan2.ReuseTool;
import JSim.plan2.TEqn;
import JSim.plan2.TEvent;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.TRelation;
import JSim.plan2.TSubDom;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Expr;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.UtilXML;
import JSim.util.XFuncArg;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMMLWriter {
    private Plan plan;
    private boolean debug;
    private Document doc;
    public static final String[] statNames = new String[]{"QUERY", "CURR", "MIN", "MAX", "DELAY", "XEXPR", "EXPR"};

    public XMMLWriter(Plan plan) throws Xcept {
        this.plan = plan;
        this.debug = true;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public Document getDocument() throws Xcept {
        if (this.doc == null) {
            this.build();
        }
        return this.doc;
    }

    public void write(PrintStream out) throws Exception {
        XMLWriter wrt = new XMLWriter();
        wrt.write(this.getDocument(), (OutputStream)out);
    }

    public String writeString() throws Exception {
        XMLWriter wrt = new XMLWriter();
        return wrt.writeString(this.getDocument());
    }

    private void build() throws Xcept {
        this.doc = UtilXML.createDoc((String)"xmml");
        Element root = this.doc.getDocumentElement();
        root.setAttribute("version", "preliminary_" + Util.version());
        this.addModel(root);
        this.addTools(root);
        this.addSequence(root);
    }

    private void addModel(Element base) throws Xcept {
        base = this.add(base, "model");
        if (this.model() == null) {
            return;
        }
        this.addUnits(base);
        this.addVars(base);
        this.addEqns(base);
        this.addRelations(base);
        this.addEvents(base);
        this.addProcCalls(base);
    }

    private void addUnits(Element base) throws Xcept {
        base = this.add(base, "unitList");
        StringList funds = this.units().fund;
        for (int i = 0; i < funds.size(); ++i) {
            Element ue = this.add(base, "fundamentalUnit");
            this.setID(ue, funds.str(i));
        }
        Hashtable<String, Unit> dunits = new Hashtable<String, Unit>();
        for (int i = 0; i < this.math().nVar(); ++i) {
            String name;
            Unit u = this.math().var(i).unit();
            if (u == null || funds.containSame(name = u.name())) continue;
            dunits.put(name, u);
        }
        ArrayList darr = new ArrayList(dunits.values());
        for (int i = 0; i < darr.size(); ++i) {
            Unit u = (Unit)darr.get(i);
            Element ue = this.add(base, "derivedUnit");
            this.setID(ue, u);
            if (u.f != 1.0) {
                Element e = this.add(ue, "realFactor");
                e.setAttribute("multiplier", Util.pretty((double)u.f));
            }
            for (int j = 0; j < u.dim.length; ++j) {
                if (u.dim[j] == 0.0) continue;
                Element e = this.add(ue, "unitFactor");
                this.setID(e, "unitID", funds.str(j));
                e.setAttribute("exponent", Util.pretty((double)u.dim[j]));
            }
        }
    }

    private void addVars(Element base) throws Xcept {
        Element list = this.add(base, "variableList");
        for (int i = 0; i < this.math().nVar(); ++i) {
            Var v = this.math().var(i);
            Element ve = this.add(list, "variable");
            this.setID(ve, (Object)v);
            String dataType = "real";
            if (v.isInt()) {
                dataType = "int";
            }
            if (v instanceof ChoiceNVar) {
                dataType = "choice";
            }
            this.set(ve, "dataType", dataType);
            this.set(ve, "isDomain", v.isDomain());
            this.set(ve, "isExtern", v.isExtern());
            this.set(ve, "isPrivate", v.isPrivate());
            this.set(ve, "isState", v.isState());
            Unit u = v.unit();
            if (u != null) {
                this.setID(ve, "unitID", u);
            }
            if (v.ndim() > 0) {
                Element xse = this.add(ve, "domainList");
                for (int j = 0; j < v.ndim(); ++j) {
                    Element xe = this.add(xse, "domain");
                    this.setID(xe, "domainID", (Object)v.domain(j));
                }
            }
            this.addVarProps(ve, v);
        }
    }

    private void addVarProps(Element base, Var v) throws Xcept {
        Element pse = null;
        for (int j = 0; j < v.props.size(); ++j) {
            CompProp prop = v.props.prop(j);
            String value = prop.stringVal(null);
            if (Util.isBlank((String)value)) continue;
            if (pse == null) {
                pse = this.add(base, "propertyValueList");
            }
            Element pe = this.add(pse, "propertyValue");
            pe.setAttribute("name", prop.name());
            String dataType = null;
            switch (prop.dataType()) {
                case 2: {
                    dataType = "boolean";
                    break;
                }
                case 4: {
                    dataType = "real";
                    break;
                }
                case 8: {
                    dataType = "string";
                }
            }
            if (dataType != null) {
                pe.setAttribute("dataType", dataType);
            }
            this.addText(pe, value);
        }
    }

    private void addEqns(Element base) throws Xcept {
        base = this.add(base, "equationList");
        for (int i = 0; i < this.model().eqns.size(); ++i) {
            TEqn eqn = this.model().eqns.get(i);
            Element e = this.add(base, "equation");
            this.setID(e, eqn);
            this.add(e, "expression", eqn.expr());
        }
    }

    private void addRelations(Element base) throws Xcept {
        base = this.add(base, "relationList");
        for (int i = 0; i < this.model().relations.size(); ++i) {
            TRelation r = this.model().relations.get(i);
            Element e = this.add(base, "relation");
            this.setID(e, r);
            this.add(e, "expression", r.expr());
        }
    }

    private void addEvents(Element base) throws Xcept {
        base = this.add(base, "eventList");
        for (int i = 0; i < this.model().events.size(); ++i) {
            TEvent event = this.model().events.get(i);
            Element e = this.add(base, "event");
            this.setID(e, event);
            this.setID(e, "timeDomainID", (Object)event.t);
            Element trig = this.add(e, "trigger", event.trigger);
            this.set(trig, "type", "absolute");
            Element eacts = this.add(e, "actionList");
            for (int j = 0; j < event.actions.size(); ++j) {
                TEvent.TAction act = event.actions.get(j);
                Element eact = this.add(eacts, "action");
                this.setID(eact, "variableID", (Object)act.v);
                this.add(eact, "expression", act.vexpr);
            }
        }
    }

    private void addProcCalls(Element base) throws Xcept {
        base = this.add(base, "procedureCallList");
        for (int i = 0; i < this.model().procs.size(); ++i) {
            XFuncCall xfc = this.model().procs.get(i);
            Element efc = this.add(base, "procedureCall");
            this.set(efc, "procedureID", xfc.func().name());
            for (int j = 0; j < xfc.args().size(); ++j) {
                XFuncArg arg = xfc.args().arg(j);
                Element earg = this.add(efc, "procedureCallArgument");
                this.add(earg, "loopDomains");
                this.add(earg, "expression", arg.base());
            }
        }
    }

    private void addTools(Element base) throws Xcept {
        base = this.add(base, "toolList");
        if (this.box() == null) {
            return;
        }
        for (Tool tool : this.box().seqTools()) {
            Element e = this.add(base, tool.toolType() + "Tool");
            this.setID(e, tool);
            this.add(e, "solvedVariables", tool.vsols);
            this.add(e, "requiredVariables", tool.vreqs);
            this.add(e, "sequenceLoops", tool.seqLoops());
            if (tool.t() != null) {
                this.setID(e, "timeDomainID", (Object)tool.t());
            }
            if (tool.icTools != null) {
                Element eics = this.add(e, "initialConditionList");
                Iterator ictools = tool.icTools.iterator();
                while (ictools.hasNext()) {
                    Element eic = this.add(eics, "initialCondition");
                    this.setID(eic, "toolID", ictools.next());
                }
            }
            if (tool instanceof DETool) {
                this.update(e, (DETool)tool);
                continue;
            }
            if (tool instanceof ExprTool) {
                this.update(e, (ExprTool)tool);
                continue;
            }
            if (tool instanceof ImplicitTool) {
                this.update(e, (ImplicitTool)tool);
                continue;
            }
            if (!(tool instanceof ReuseTool)) continue;
            this.update(e, (ReuseTool)tool);
        }
    }

    private void update(Element base, DETool tool) throws Xcept {
        this.set(base, "timeOrder", "" + tool.torder);
        this.addCon(base, tool.state(), this.model().entire);
        if (!tool.isPDE()) {
            return;
        }
        for (Domain x : tool.xs) {
            TSubDom sd = this.model().lhbcs.get((Object)x);
            this.addCon(base, tool.bc(sd), sd);
            sd = this.model().rhbcs.get((Object)x);
            this.addCon(base, tool.bc(sd), sd);
        }
    }

    private void addCon(Element base, DECon con, TSubDom subdom) throws Xcept {
        Element e = null;
        if (subdom.isEntire()) {
            e = this.add(base, "stateEquation");
        } else {
            e = this.add(base, "boundaryCondition");
            this.set(e, "domainID", subdom.domain());
            this.set(e, "side", subdom.isLH() ? "left" : "right");
        }
        if (con == null) {
            return;
        }
        if (con.isTool()) {
            this.setID(e, "toolID", con.tool());
        } else {
            this.setID(e, "equationID", con.eqn());
        }
    }

    private void update(Element base, ExprTool tool) throws Xcept {
        this.add(base, "expression", tool.expr);
    }

    private void update(Element base, ImplicitTool tool) throws Xcept {
        Element ze = this.add(base, "zeroExpressionList");
        for (int i = 0; i < tool.exprs.size(); ++i) {
            this.add(ze, "expression", tool.exprs.get(i).zeroExpr());
        }
        Element be = this.add(base, "bounds");
        if (tool.isLinear()) {
            Element le = this.add(base, "linearMatrix");
        }
    }

    private void update(Element base, ReuseTool tool) throws Xcept {
    }

    private void addSequence(Element base) throws Xcept {
        base = this.add(base, "sequence");
    }

    private Element add(Element base, String name) {
        Element e = this.doc.createElement(name);
        base.appendChild(e);
        return e;
    }

    private void addText(Element base, String name, String txt) {
        Element e = this.add(base, name);
        this.addText(e, txt);
    }

    private void addText(Element base, String txt) {
        Text ptxt = this.doc.createTextNode(txt);
        base.appendChild(ptxt);
    }

    private void add(Element base, String name, Var v) throws Xcept {
        Element e = this.add(base, name);
        this.setID(e, (Object)v);
    }

    private void add(Element base, String name, VarUsages vus) throws Xcept {
        Element e = this.add(base, name);
        for (int i = 0; i < vus.size(); ++i) {
            this.add(e, vus.get(i));
        }
    }

    private Element add(Element base, VarUsage vu) throws Xcept {
        Element e = this.add(base, "variableUsage");
        this.setID(e, vu);
        Var v = vu.v();
        this.setID(e, "variableID", (Object)v);
        int stat = vu.stat();
        this.set(e, "status", statNames[stat]);
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            int qstat = vu.qstat(x);
            if (qstat == 1) continue;
            Element xe = this.add(e, "domainUsage");
            this.setID(xe, "domainID", (Object)x);
            this.set(xe, "qstatus", statNames[qstat]);
        }
        return e;
    }

    private void add(Element base, String name, DomainSet doms) throws Xcept {
        if (doms == null) {
            return;
        }
        Element e = this.add(base, name);
        Iterator iter = doms.iterator();
        while (iter.hasNext()) {
            Element xe = this.add(e, "sequenceLoop");
            this.setID(xe, "domainID", iter.next());
        }
    }

    private Element add(Element base, String name, TExpr expr) throws Xcept {
        TSubDom subdom;
        Element e = this.add(base, name);
        if (this.debug) {
            this.addText(e, "debug", expr.toString());
        }
        if (!(subdom = expr.subdom()).isEntire()) {
            Element esd = this.add(e, "subdomain");
            this.setID(esd, "domainID", (Object)subdom.domain());
            this.set(esd, "side", subdom.isLH() ? "left" : "right");
        }
        MLWriter math = new MLWriter(e);
        math.add(expr.expr());
        return e;
    }

    private Element add(Element base, String name, Expr expr) throws Xcept {
        Element e = this.add(base, name);
        if (this.debug) {
            this.addText(e, "debug", expr.toString());
        }
        MLWriter math = new MLWriter(e);
        math.add(expr);
        return e;
    }

    private void set(Element e, String name, boolean b) {
        e.setAttribute(name, "" + b);
    }

    private void set(Element e, String name, String s) {
        e.setAttribute(name, "" + s);
    }

    private void set(Element e, String name, Var v) {
        this.set(e, name, v.toString());
    }

    private String id(Object o) throws Xcept {
        if (o == null) {
            return "null";
        }
        if (o instanceof Unit) {
            return ((Unit)o).pubName();
        }
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof Var) {
            return o.toString();
        }
        if (o instanceof VarUsage) {
            return o.toString();
        }
        if (o instanceof TRelation) {
            return "eqn_" + o.hashCode();
        }
        if (o instanceof TEqn) {
            return "eqn_" + o.hashCode();
        }
        if (o instanceof TEvent) {
            return "event_" + o.hashCode();
        }
        if (o instanceof XFuncCall) {
            return "proc_" + o.hashCode();
        }
        if (o instanceof Tool) {
            return "tool_" + o.hashCode();
        }
        throw new Xcept("No id defined for class " + (o == null ? "null" : o.getClass().getName()));
    }

    private void setID(Element e, Object o) throws Xcept {
        this.setID(e, "id", this.id(o));
    }

    private void setID(Element e, String name, Object o) throws Xcept {
        e.setAttribute(name, this.id(o));
    }

    private TModel model() {
        return this.plan.model();
    }

    private UnitNList units() {
        return this.model().units();
    }

    private MathSys math() {
        return this.model().math;
    }

    private ToolBox box() {
        return this.plan.box();
    }
}

