/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.sbml2.SBModel;
import JSim.sbml2.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.Compartment;

public class SBCompartment
implements Named {
    protected SBModel sbmodel;
    protected Compartment comp;
    protected SBVar v;

    public SBCompartment(SBModel sm, Compartment c) throws Xcept {
        this.sbmodel = sm;
        this.comp = c;
        this.v = new SBVar(this.sbmodel, this.name(), "compartment");
        double sz = 1.0;
        if (this.comp.isSetSize()) {
            sz = this.comp.getSize();
        } else if (this.comp.isSetVolume()) {
            sz = this.comp.getVolume();
        }
        this.v.setInitValue(sz);
        String cunit = this.unit();
        this.v.setUnit(cunit);
        this.v.setSBMLName(this.comp);
    }

    public String name() {
        return this.comp.getId();
    }

    public String diagInfo() {
        return "Compartment " + this.name();
    }

    public String unit() {
        long sd;
        String cunit = this.comp.isSetUnits() ? this.comp.getUnits() : ((sd = this.comp.getSpatialDimensions()) == 3L ? "volume" : (sd == 2L ? "area" : (sd == 1L ? "length" : (sd == 0L ? "dimensionless" : "volume"))));
        return cunit;
    }

    public long spatialDimensions() {
        return this.comp.getSpatialDimensions();
    }

    public void writeMML(PrintWriter wrt) {
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            long ncmp = sbm.model.getNumCompartments();
            int i = 0;
            while ((long)i < ncmp) {
                this.add(new SBCompartment(sbm, sbm.model.getCompartment(i)));
                ++i;
            }
        }

        public NList() {
        }

        public SBCompartment sbcomp(int i) {
            return (SBCompartment)this.get(i);
        }

        public SBCompartment sbcomp(String n) {
            return (SBCompartment)this.getByName(n);
        }
    }
}

