/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.sbml2.SBModel;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.Event;

public class SBEvent
implements Named {
    protected SBModel sbmodel;
    protected Event event;

    public SBEvent(SBModel sm, Event c) throws Xcept {
        this.sbmodel = sm;
        this.event = c;
        if (this.sbmodel.abortEvents) {
            throw new Xcept("SBML <event> tag not yet supported");
        }
    }

    public String name() {
        return this.event.getId();
    }

    public String diagInfo() {
        return "Event " + this.name();
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("// WARNING: SBML events are not currently supported: " + this.name());
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            long nev = sbm.model.getNumEvents();
            int i = 0;
            while ((long)i < nev) {
                this.add(new SBEvent(sbm, sbm.model.getEvent(i)));
                ++i;
            }
        }

        public NList() {
        }

        public SBEvent sbevent(int i) {
            return (SBEvent)this.get(i);
        }

        public SBEvent sbevent(String n) {
            return (SBEvent)this.getByName(n);
        }
    }
}

