/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.mathml.MLLambda;
import JSim.mathml.MLMath;
import JSim.sbml2.SBModel;
import JSim.sbml2.SBVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.NamedRealConst;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.libsbml;

public class SBFunction
implements Named {
    protected SBModel sbmodel;
    protected FunctionDefinition func;
    protected String name;
    protected MLLambda lambda;
    protected int ncalls;

    public SBFunction(SBModel sm, FunctionDefinition c) throws Xcept {
        this.sbmodel = sm;
        this.func = c;
        this.name = this.func.getId();
        String text = libsbml.writeMathMLToString(this.func.getMath());
        MLMath math = new MLMath(text);
        this.lambda = math.makeLambda(this.sbmodel, this.sbmodel.csymbols);
        this.ncalls = 0;
    }

    protected Expr makeCall(Expr.List args) throws Xcept {
        if (this.lambda.nargs() != args.size()) {
            throw new Xcept((DiagInfo)this, "Function requires " + this.lambda.nargs() + " arguments, " + args.size() + " were found.");
        }
        String vname = this.name + "_call" + this.ncalls++;
        SBVar v = new SBVar(this.sbmodel, vname, "functionCall");
        v.setPrivate(true);
        Expr expr = this.lambda.eval();
        expr = expr.replace(this.lambda.args(), args);
        String vassn = expr.toString((Context)this.sbmodel.ctxt);
        v.setAssign(vassn);
        return new NamedRealConst(vname, 0.0);
    }

    public String name() {
        return this.name;
    }

    public String diagInfo() {
        return "Function definition " + this.name + this.lambda.args() + "=" + this.lambda.eval();
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("  // " + this.diagInfo() + ";");
    }

    public static class NList
    extends NamedList {
        public NList() {
        }

        public NList(SBModel sbm) throws Xcept {
            long nfuncs = sbm.model.getNumFunctionDefinitions();
            int i = 0;
            while ((long)i < nfuncs) {
                this.add(new SBFunction(sbm, sbm.model.getFunctionDefinition(i)));
                ++i;
            }
        }

        public SBFunction sbfunc(int i) {
            return (SBFunction)this.get(i);
        }

        public SBFunction sbfunc(String n) {
            return (SBFunction)this.getByName(n);
        }
    }
}

