/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.util.StringList;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.libsbml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBMLWriter {
    private Document xdoc;
    protected SBMLDocument sdoc;
    protected Model model;
    protected StringList warnings;
    private Element xroot;
    private Element xmodel;
    private Element xtoolList;
    private Element xunitList;
    private Element xvarList;
    private Element xeventList;
    private static boolean sbmlPresent;
    private Hashtable<String, String> unitMap;
    private Hashtable<String, Element> xunitIDs;
    private Hashtable<String, Element> xvarIDs;
    private Hashtable<String, Element> xtoolIDs;
    private Hashtable<String, Element> xeqnIDS;
    private Hashtable<String, Element> xeventIDs;
    private String xtime;
    private static final String[] xfunds;
    private static final String[] sfunds;

    public SBMLWriter(Document xdoc, StringList warnings) throws Exception {
        if (!sbmlPresent) {
            throw new Xcept("libSBML native library not found.");
        }
        this.xdoc = xdoc;
        this.sdoc = new SBMLDocument(2L, 4L);
        this.model = this.sdoc.createModel();
        this.warnings = warnings;
        this.xroot = xdoc.getDocumentElement();
        this.xmodel = this.getFirstElement(this.xroot, "model");
        this.xtoolList = this.getFirstElement(this.xroot, "toolList");
        this.xunitList = this.getFirstElement(this.xmodel, "unitList");
        this.xvarList = this.getFirstElement(this.xmodel, "variableList");
        this.xeventList = this.getFirstElement(this.xmodel, "eventList");
        this.xunitIDs = this.loadIDMap(this.xunitList);
        this.xvarIDs = this.loadIDMap(this.xvarList);
        this.xtoolIDs = this.loadIDMap(this.xtoolList);
    }

    public String getSBML() throws Exception {
        this.loadVars();
        this.loadTools();
        org.sbml.libsbml.SBMLWriter writer = new org.sbml.libsbml.SBMLWriter();
        return writer.writeToString(this.sdoc);
    }

    public StringList getWarnings() {
        return this.warnings;
    }

    public void loadVars() throws Xcept {
        ArrayList<Element> xvars = new ArrayList<Element>(this.xvarIDs.values());
        for (int i = 0; i < xvars.size(); ++i) {
            Element xvar = xvars.get(i);
            String name = xvar.getAttribute("id");
            if (!this.isVarUsable(name)) continue;
            String isDomain = xvar.getAttribute("isDomain");
            if (isDomain.equals("true")) {
                if (this.xtime != null) {
                    this.warnings.add((Object)("Warning: Multiple domains not supported.  Domain '" + name + "' ignored; domain '" + this.xtime + "' used instead for SBML implicit time."));
                    return;
                }
                this.xtime = name;
                continue;
            }
            Parameter param = this.model.getParameter(name);
            if (param != null || (param = this.model.createParameter()).setId(name) != -4) continue;
            this.warnings.add((Object)("Warning:  Unable to create the variable '" + name + "', as it is an illegal SBML name."));
            return;
        }
    }

    public void loadTools() throws Xcept {
        ArrayList<Element> xtools = new ArrayList<Element>(this.xtoolIDs.values());
        for (int i = 0; i < xtools.size(); ++i) {
            Element xtool = xtools.get(i);
            String type = xtool.getNodeName();
            if (type.equals("exprTool")) {
                this.makeAssignmentRule(xtool);
                continue;
            }
            if (type.equals("implicitTool")) {
                this.makeAlgebraicRule(xtool);
                continue;
            }
            if (type.equals("ODETool")) {
                this.makeRateRule(xtool);
                continue;
            }
            if (type.equals("domainTool") || type.equals("externTool")) continue;
            this.warnings.add((Object)("Warning: " + type + "s are not translatable to SBML: ignoring this part of the model."));
        }
    }

    public void makeAssignmentRule(Element xtool) throws Xcept {
        Element vsols = this.getFirstElement(xtool, "solvedVariables");
        Element vsol = this.getFirstElement(vsols, "variableUsage");
        String vid = vsol.getAttribute("variableID");
        if (!this.isVarUsable(vid)) {
            return;
        }
        Element expr = this.getFirstElement(xtool, "expression");
        Element math = this.getFirstElement(expr, "math");
        this.fixTminAndDelays(math);
        String mathml = this.elementToString(math);
        ASTNode astn = libsbml.readMathMLFromString(mathml);
        if (astn == null) {
            Element debug = this.getFirstElement(expr, "debug");
            String origtxt = "";
            if (debug != null) {
                String debstr = this.elementToString(debug);
                Node sub = debug.getFirstChild();
                origtxt = sub.getNodeValue();
                origtxt = " ('" + origtxt + "')";
            }
            this.warnings.add((Object)("Warning: Unable to translate definition of '" + vid + "'" + origtxt + " to SBML."));
            return;
        }
        this.fixTime(astn);
        this.translateDelay(astn);
        String formula = libsbml.formulaToString(astn);
        String init = libsbml.formulaToString(astn);
        Parameter p = this.model.getParameter(vid);
        if (p == null && (p = this.model.createParameter()).setId(vid) == -4) {
            this.warnings.add((Object)("Warning:  Unable to create the variable '" + vid + "', as it is an illegal SBML name."));
            return;
        }
        try {
            Double d = Double.parseDouble(init);
            p.setValue(d);
        }
        catch (Exception e) {
            String status = vsol.getAttribute("status");
            if (status.equals("CURR")) {
                p.setConstant(false);
                AssignmentRule ar = this.model.createAssignmentRule();
                ar.setVariable(vid);
                ar.setMath(astn);
            }
            if (status.equals("MIN")) {
                InitialAssignment ia = this.model.createInitialAssignment();
                ia.setSymbol(vid);
                ia.setMath(astn);
            }
            throw new Xcept("Unknown status for variable '" + vid + "':  " + status);
        }
    }

    public String elementToString(Element elin) throws Xcept {
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(elin);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new Xcept("Unable to create XML transformer for MML to SBML translator.");
        }
        String ret = sw.toString();
        return ret;
    }

    public void makeAlgebraicRule(Element xtool) throws Xcept {
    }

    public void makeRateRule(Element xtool) throws Xcept {
        Element vsols = this.getFirstElement(xtool, "solvedVariables");
        Object vstate = null;
        Element vu = this.getFirstElement(vsols, "variableUsage");
        String vid = vu.getAttribute("variableID");
        if (!this.isVarUsable(vid)) {
            return;
        }
        Parameter p = this.model.getParameter(vid);
        if (p == null && (p = this.model.createParameter()).setId(vid) == -4) {
            this.warnings.add((Object)("Warning:  Unable to create the variable '" + vid + "', as it is an illegal SBML name."));
            return;
        }
        p.setConstant(false);
        Element state = this.getFirstElement(xtool, "stateEquation");
        String toolID = state.getAttribute("toolID");
        Element tool = this.xtoolIDs.get(toolID);
        String type = tool.getNodeName();
        if (!type.equals("exprTool")) {
            this.warnings.add((Object)("Warning:  Rate rule type " + type + " not supported."));
            return;
        }
        Element expr = this.getFirstElement(tool, "expression");
        Element math = this.getFirstElement(expr, "math");
        this.fixTminAndDelays(math);
        String mathml = this.elementToString(math);
        ASTNode astn = libsbml.readMathMLFromString(mathml);
        String origtxt = "";
        Element debug = this.getFirstElement(expr, "debug");
        if (debug != null) {
            String debstr = this.elementToString(debug);
            Node sub = debug.getFirstChild();
            origtxt = sub.getNodeValue();
            origtxt = " ('" + origtxt + "')";
        }
        if (astn == null) {
            this.warnings.add((Object)("Warning: Unable to translate definition of '" + vid + "'" + origtxt + " to SBML."));
            return;
        }
        this.fixTime(astn);
        this.translateDelay(astn);
        RateRule rr = this.model.createRateRule();
        int success = rr.setVariable(vid);
        if (success != 0) {
            throw new Xcept("Unable to create rate rule for parameter '" + vid + "'.");
        }
        rr.setMath(astn);
    }

    public void checkExtern(Element xtool) throws Xcept {
        Element vsols = this.getFirstElement(xtool, "solvedVariables");
        Element vu = this.getFirstElement(vsols, "variableUsage");
        String vid = vu.getAttribute("variableID");
        if (vid.indexOf("time") < 0) {
            this.warnings.add((Object)("Warning: incompletely defined variable '" + vid + "' due to extern tool being ignored."));
            return;
        }
    }

    public void fixTminAndDelays(Element mathml) {
        if (mathml.getTagName().equals("math")) {
            NodeList children = mathml.getElementsByTagName("*");
            for (int c = 0; c < children.getLength(); ++c) {
                Element child = (Element)children.item(c);
                this.fixTminAndDelays(child);
            }
        } else if (mathml.getTagName().equals("ci")) {
            String textValue = "";
            Node firstchild = mathml.getFirstChild();
            if (firstchild != null) {
                textValue = firstchild.getNodeValue();
            }
            if (textValue.equals("time.min")) {
                firstchild.setNodeValue("time__min");
            } else if (mathml.hasAttribute("type") && mathml.getAttribute("type").equals("function") && this.model.getParameter(textValue) != null) {
                firstchild.setNodeValue(textValue + "__function");
                mathml.removeAttribute("type");
            }
        }
    }

    public void fixTime(ASTNode astn) {
        if (astn == null) {
            return;
        }
        if (!astn.isOperator() && !astn.isNumber()) {
            if (astn.getName().equals("time")) {
                astn.setType(261);
            }
            if (astn.getName().equals(this.xtime)) {
                astn.setType(261);
            }
        }
        for (long c = 0L; c < astn.getNumChildren(); ++c) {
            this.fixTime(astn.getChild(c));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translateDelay(ASTNode astn) throws Xcept {
        if (astn == null) {
            return;
        }
        String name = astn.getName();
        if (name != null && name.indexOf("__function") >= 0) {
            String vid = astn.getName();
            vid = vid.substring(0, name.indexOf("__function"));
            Parameter param = this.model.getParameter(vid);
            ASTNode paramnode = new ASTNode();
            paramnode.setName(vid);
            ASTNode time = new ASTNode();
            time.setName("time");
            time.setType(261);
            if (this.nodeIsOnlyTmin(astn)) {
                astn.setName("delay");
                astn.setType(288);
                astn.replaceChild(0L, paramnode);
                astn.addChild(time);
                return;
            } else if (this.nodeIsFunctionWithoutTmin(astn)) {
                if (astn.getNumChildren() != 1L) {
                    this.warnings.add((Object)("Warning: This function is untranslateable to SBML, as it involves multiple domains: '" + libsbml.formulaToString(astn) + "'."));
                    return;
                }
                ASTNode child = astn.getChild(0L);
                ASTNode func = this.getFunctionOfTminus(child);
                if (func != null) {
                    astn.setName("delay");
                    astn.setType(288);
                    astn.replaceChild(0L, paramnode);
                    astn.addChild(func);
                    return;
                } else {
                    astn.setName("delay");
                    astn.setType(288);
                    astn.replaceChild(0L, paramnode);
                    ASTNode minus = new ASTNode();
                    minus.setName("minus");
                    minus.setType(45);
                    minus.addChild(time);
                    minus.addChild(child);
                    astn.addChild(minus);
                }
                return;
            } else {
                ASTNode func = this.getDelayFromCanonical(astn);
                if (func == null) throw new Xcept("Unable to parse '" + libsbml.formulaToString(astn) + "' into SBML as a delay function--it used 'time.min' in an unexpected way.  For models intended to be translated to SBML, the format 'X(time-y)' is sufficient.");
                astn.setName("delay");
                astn.setType(288);
                astn.replaceChild(0L, paramnode);
                astn.addChild(func);
            }
            return;
        } else {
            for (long c = 0L; c < astn.getNumChildren(); ++c) {
                this.translateDelay(astn.getChild(c));
            }
        }
    }

    public boolean nodeIsOnlyTmin(ASTNode astn) throws Xcept {
        if (astn == null) {
            return false;
        }
        if (astn.getNumChildren() != 1L) {
            return false;
        }
        ASTNode child = astn.getChild(0L);
        if (child.getNumChildren() != 0L) {
            return false;
        }
        String name = child.getName();
        if (name == null) {
            return false;
        }
        return name.equals("time__min");
    }

    public ASTNode getFunctionOfTminus(ASTNode astn) throws Xcept {
        if (astn.getType() != 45) {
            return null;
        }
        if (astn.getNumChildren() != 2L) {
            return null;
        }
        if (astn.getChild(0L).getName() == null) {
            return null;
        }
        if (!astn.getChild(0L).getName().equals("time")) {
            return null;
        }
        return astn.getChild(1L);
    }

    public boolean nodeIsFunctionWithoutTmin(ASTNode astn) {
        return libsbml.formulaToString(astn).indexOf("time__min") < 0;
    }

    public ASTNode getDelayFromCanonical(ASTNode astn) throws Xcept {
        ASTNode child = astn.getChild(0L);
        if (!child.isPiecewise()) {
            return null;
        }
        if (child.getNumChildren() != 3L) {
            return null;
        }
        ASTNode tmin = child.getChild(0L);
        ASTNode func = child.getChild(1L);
        ASTNode otherwise = child.getChild(2L);
        if (!tmin.getName().equals("time__min")) {
            return null;
        }
        ASTNode retfunc = this.getFunctionOfTminus(otherwise);
        if (retfunc == null) {
            retfunc = new ASTNode();
            retfunc.setName("minus");
            retfunc.setType(45);
            ASTNode time = new ASTNode();
            time.setName("time");
            time.setType(261);
            retfunc.addChild(time);
            retfunc.addChild(otherwise.getChild(0L));
        }
        return retfunc;
    }

    public boolean isVarUsable(String name) throws Xcept {
        if (name.indexOf("__init") >= 0) {
            this.warnings.add((Object)"Warning: XMML file created without 'makeDEICParms=false' defined, resulting in the creation of '__init' variables.");
        }
        if (name.indexOf("__") >= 0) {
            return false;
        }
        if (name.indexOf(":") >= 0) {
            return false;
        }
        if (name.endsWith(".ct")) {
            return false;
        }
        if (name.endsWith(".min")) {
            return false;
        }
        if (name.endsWith(".max")) {
            return false;
        }
        return !name.endsWith(".delta");
    }

    private Element getFirstElement(Element base, String name) {
        NodeList nodes = base.getElementsByTagName(name);
        return (Element)nodes.item(0);
    }

    private Hashtable<String, Element> loadIDMap(Element base) {
        Hashtable<String, Element> map = new Hashtable<String, Element>();
        if (base == null) {
            return map;
        }
        NodeList nodes = base.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            Element e = (Element)nodes.item(i);
            String id = e.getAttribute("id");
            map.put(id, e);
        }
        return map;
    }

    public static final void main(String[] args) throws Exception {
        File f = new File(args[0]);
        Document xdoc = UtilXML.parse((File)f);
        SBMLWriter wrt = new SBMLWriter(xdoc, new StringList());
        String sbml = wrt.getSBML();
        System.out.println(sbml);
        StringList warns = wrt.getWarnings();
        System.err.println(warns);
    }

    static {
        xfunds = new String[]{"kg", "m", "sec", "amp", "degK", "mol", "candela"};
        sfunds = new String[]{"kilogram", "meter", "second", "ampere", "kelvin", "mole", "candela"};
        try {
            System.loadLibrary("sbmlj");
            Class.forName("org.sbml.libsbml.libsbml");
            sbmlPresent = true;
        }
        catch (Throwable e) {
            sbmlPresent = false;
            e.printStackTrace();
        }
    }
}

