/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.data.NamedVal;
import JSim.mathml.MLCSymbol;
import JSim.mathml.MLMath;
import JSim.mathml.MLNameSpace;
import JSim.sbml2.SBCompartment;
import JSim.sbml2.SBContext;
import JSim.sbml2.SBEvent;
import JSim.sbml2.SBFunction;
import JSim.sbml2.SBParameter;
import JSim.sbml2.SBReaction;
import JSim.sbml2.SBRule;
import JSim.sbml2.SBSpecies;
import JSim.sbml2.SBUnit;
import JSim.sbml2.SBVar;
import JSim.util.Context;
import JSim.util.Expr;
import JSim.util.NamedRealConst;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.w3c.dom.Element;

public class SBModel
implements MLNameSpace {
    protected SBMLDocument document;
    protected Model model;
    protected SBCompartment.NList sbcomps;
    protected SBUnit.NList sbunits;
    protected SBEvent.NList sbevents;
    protected SBFunction.NList sbfuncs;
    protected SBParameter.NList sbparms;
    protected SBReaction.NList sbreacs;
    protected SBRule.NList sbrules;
    protected SBSpecies.NList sbspecs;
    protected SBVar.NList sbvars;
    protected MLCSymbol.NList csymbols;
    protected int nDelayExpr;
    protected boolean abortEvents;
    protected NamedRealConst timeExpr;
    protected SBContext ctxt;
    protected ArrayList<String> changedUnits;
    private static boolean sbmlPresent;
    private boolean stringInitialUnderscore = true;
    private static final String[] muNames;
    private static final String[] muDefs;
    public static final String TIME_URL = "http://www.sbml.org/sbml/symbols/time";

    public SBModel(String text, NamedVal[] options) throws Xcept {
        int i;
        if (!sbmlPresent) {
            throw new Xcept("libSBML native library not found.");
        }
        text = text.replaceAll("__", "_");
        text = text.replaceAll("\"_", "\"");
        SBMLReader reader = new SBMLReader();
        this.document = reader.readSBMLFromString(text);
        this.model = this.document.getModel();
        this.fixNames();
        this.sbvars = new SBVar.NList();
        this.ctxt = new SBContext(this);
        if (options == null) {
            options = new NamedVal[]{};
        }
        NamedVal.NList nopts = new NamedVal.NList(options);
        this.abortEvents = nopts.boolVal("abortSBMLEvents", false);
        this.csymbols = new MLCSymbol.NList();
        MLCSymbol delay = new MLCSymbol("delay"){

            public Expr makeExpr(Expr.List args) throws Xcept {
                if (args.size() != 2) {
                    throw new Xcept("csymbol delay requires 2 arguments");
                }
                String v = args.expr(0).toString((Context)SBModel.this.ctxt);
                if (!Util.onlyLettersAndDigits((String)v)) {
                    SBVar d = SBModel.this.makeSBVar("delayExpr" + SBModel.this.nDelayExpr++, "delay");
                    d.setAssign(v);
                    d.setConst(false);
                    v = d.mmlName;
                }
                String delay = args.expr(1).toString((Context)SBModel.this.ctxt);
                String s = "" + v + "(if (time<(time.min+" + delay + ")) time.min else time-(" + delay + "))";
                return new NamedRealConst(s, Double.NaN);
            }
        };
        this.csymbols.add(delay);
        this.timeExpr = new NamedRealConst("time", Double.NaN);
        this.addTime("time");
        this.changedUnits = new ArrayList();
        this.sbunits = new SBUnit.NList(this);
        this.sbfuncs = new SBFunction.NList(this);
        this.sbcomps = new SBCompartment.NList(this);
        this.sbparms = new SBParameter.NList(this);
        this.sbspecs = new SBSpecies.NList(this);
        this.sbevents = new SBEvent.NList(this);
        this.sbreacs = new SBReaction.NList(this);
        this.sbrules = new SBRule.NList(this);
        for (i = 0; i < this.sbspecs.size(); ++i) {
            this.sbspecs.sbspec(i).setCalc();
        }
        for (i = 0; i < this.sbvars.size(); ++i) {
            this.sbvars.sbvar(i).setCalc();
        }
    }

    private void fixNames() {
    }

    private void addTime(String name) {
        MLCSymbol tsym = new MLCSymbol(name){

            public Expr makeExpr(Expr.List args) throws Xcept {
                if (args.size() != 0) {
                    throw new Xcept("csymbol Time requires 0 arguments");
                }
                return SBModel.this.timeExpr;
            }
        };
        this.csymbols.add(tsym);
    }

    protected SBVar makeSBVar(String name, String role) throws Xcept {
        return new SBVar(this, name, role);
    }

    public void writeMML(Writer wrt) throws Xcept {
        int i;
        PrintWriter out = new PrintWriter(wrt, true);
        out.println("// This model generated automatically from SBML");
        for (i = 0; i < this.sbevents.size(); ++i) {
            this.sbevents.sbevent(i).writeMML(out);
        }
        for (i = 0; i < this.sbvars.size(); ++i) {
            this.sbvars.sbvar(i).writeRenameWarning(out);
        }
        out.println("");
        out.println("// unit definitions");
        if (!this.changedUnits.isEmpty()) {
            out.println("// Note:  the following unit(s) have been changed due to conflicts with built-in JSim unit definitions:");
            for (i = 0; i < this.changedUnits.size(); ++i) {
                out.println("//    '" + this.changedUnits.get(i) + "' to '" + this.mmlUnitName(this.changedUnits.get(i)) + "'");
            }
        }
        out.println("import nsrunit;");
        out.println("unit conversion off;");
        out.println("unit item=scalar;");
        for (i = 0; i < this.sbunits.size(); ++i) {
            this.sbunits.sbunit(i).writeMML(out);
        }
        for (i = 0; i < muNames.length; ++i) {
            if (this.sbunits.sbunit(muNames[i]) != null) continue;
            out.println("unit " + muNames[i] + " = " + muDefs[i] + ";");
        }
        out.println("");
        out.println("// SBML property definitions");
        out.println("property sbmlRole=string;");
        out.println("property sbmlName=string;");
        out.println("property sbmlCompartment=string;");
        out.println("");
        out.println("// SBML reactions");
        for (i = 0; i < this.sbreacs.size(); ++i) {
            this.sbreacs.sbreac(i).writeMML(out);
        }
        out.println("");
        out.println("math main {");
        out.println("  realDomain time second;");
        out.println("  time.min=0;");
        out.println("  extern time.max;");
        out.println("  extern time.delta;");
        out.println("");
        out.println("  // variable definitions");
        for (i = 0; i < this.sbvars.size(); ++i) {
            this.sbvars.sbvar(i).writeMMLDecl(out);
        }
        out.println("");
        out.println("  // equations");
        for (i = 0; i < this.sbvars.size(); ++i) {
            this.sbvars.sbvar(i).writeMMLEqn(out);
        }
        for (i = 0; i < this.sbrules.size(); ++i) {
            this.sbrules.sbrule(i).writeMML(out);
        }
        for (i = 0; i < this.sbspecs.size(); ++i) {
            this.sbspecs.sbspec(i).writeMML2(out);
        }
        for (i = 0; i < this.sbparms.size(); ++i) {
            this.sbparms.sbparm(i).writeMML(out);
        }
        for (i = 0; i < this.sbcomps.size(); ++i) {
            this.sbcomps.sbcomp(i).writeMML(out);
        }
        for (i = 0; i < this.sbspecs.size(); ++i) {
            this.sbspecs.sbspec(i).writeMML(out);
        }
        out.println("");
        if (this.sbfuncs.size() > 0) {
            for (i = 0; i < this.sbfuncs.size(); ++i) {
                this.sbfuncs.sbfunc(i).writeMML(out);
            }
            out.println("");
        }
        out.println("  // variable properties");
        for (i = 0; i < this.sbvars.size(); ++i) {
            this.sbvars.sbvar(i).writeMMLProp(out);
        }
        out.println("}");
    }

    private Expr mathExpr(String text) throws Xcept {
        MLMath math = new MLMath(text = text.replaceAll("math:", ""));
        Expr.List list = math.makeExprList(this, this.csymbols);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() != 1) {
            throw new Xcept("Expected single MathML expression, got:\n" + text);
        }
        return list.expr(0);
    }

    public String mathExprMML(String text) throws Xcept {
        Expr expr = this.mathExpr(text);
        if (expr == null) {
            return null;
        }
        return expr.toString((Context)this.ctxt);
    }

    public Expr compByName(String name) throws Xcept {
        if (this.stringInitialUnderscore && name.charAt(0) == '_') {
            SBVar v = (SBVar)this.sbvars.getByName(name = name.substring(1));
            if (v != null) {
                v.strippedLeadingUnderscore = true;
            }
            if ((v = (SBVar)this.sbvars.getByName(name + ".amt")) != null) {
                v.strippedLeadingUnderscore = true;
            }
            if ((v = (SBVar)this.sbvars.getByName(name + ".conc")) != null) {
                v.strippedLeadingUnderscore = true;
            }
        }
        return new NamedRealConst(name, Double.NaN);
    }

    public String compNameByElement(Element elem) throws Xcept {
        String url = elem.getAttribute("definitionURL");
        if (url.equalsIgnoreCase(TIME_URL)) {
            return "time";
        }
        return UtilXML.getText((Element)elem);
    }

    public Expr makeDeriv(Expr e1, Expr e2) throws Xcept {
        throw new Xcept("makeDeriv() not implemented");
    }

    public Unit unitByName(String name) throws Xcept {
        return Unit.scalar();
    }

    public Expr funcCall(String name, Expr.List elist) throws Xcept {
        if (this.sbfuncs == null) {
            throw new Xcept("Nested function " + name + " not currently supported");
        }
        SBFunction f = this.sbfuncs.sbfunc(name);
        if (f == null) {
            throw new Xcept("SBML function " + name + " not defined");
        }
        return f.makeCall(elist);
    }

    public void changeUnit(String unit) {
        this.changedUnits.add(unit);
    }

    public String mmlUnitName(String origunit) {
        for (int i = 0; i < this.changedUnits.size(); ++i) {
            if (!origunit.equals(this.changedUnits.get(i))) continue;
            return origunit + "_";
        }
        return origunit;
    }

    public static final void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.err.println("==== " + args[i]);
            File f = new File(args[i]);
            String text = "";
            SBModel sbdoc = new SBModel(text, null);
            OutputStreamWriter wrt = new OutputStreamWriter(System.out);
            sbdoc.writeMML(wrt);
        }
    }

    static {
        try {
            System.loadLibrary("sbmlj");
            Class.forName("org.sbml.libsbml.libsbml");
            sbmlPresent = true;
        }
        catch (Throwable e) {
            sbmlPresent = false;
            e.printStackTrace();
        }
        muNames = new String[]{"substance", "volume", "area", "length", "time"};
        muDefs = new String[]{"mole", "litre", "metre^2", "metre", "second"};
    }
}

