/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.sbml2.SBModel;
import JSim.sbml2.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.libsbml;

public class SBParameter
implements Named {
    protected SBModel sbmodel;
    protected Parameter parm;
    protected SBVar var;

    public SBParameter(SBModel sm, Parameter p) throws Xcept {
        InitialAssignment ia;
        this.sbmodel = sm;
        this.parm = p;
        this.var = new SBVar(this.sbmodel, this.name(), "parameter");
        this.var.setConst(this.parm.getConstant());
        if (this.parm.isSetValue()) {
            this.var.setInitValue(this.parm.getValue());
        }
        if ((ia = sm.model.getInitialAssignment(p.getId())) != null) {
            this.var.setInitValue(libsbml.formulaToString(ia.getMath()));
        }
        this.var.setUnit(this.parm.getUnits());
        this.var.setSBMLName(this.parm);
    }

    public String name() {
        return this.parm.getId();
    }

    public String diagInfo() {
        return "Parameter " + this.name();
    }

    public void writeMML(PrintWriter wrt) {
    }

    public static class NList
    extends NamedList {
        public NList() {
        }

        public NList(SBModel sbm) throws Xcept {
            this.addList(sbm, sbm.model.getListOfParameters());
        }

        public void addList(SBModel sbm, ListOfParameters paramlist) throws Xcept {
            long nparams = paramlist.size();
            int i = 0;
            while ((long)i < nparams) {
                this.add(new SBParameter(sbm, paramlist.get(i)));
                ++i;
            }
        }

        public SBParameter sbparm(int i) {
            return (SBParameter)this.get(i);
        }

        public SBParameter sbparm(String n) {
            return (SBParameter)this.getByName(n);
        }
    }
}

