/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.sbml2.SBModel;
import JSim.sbml2.SBSpecies;
import JSim.sbml2.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.libsbml;

public class SBReaction
implements Named {
    protected SBModel sbmodel;
    protected Reaction reac;
    protected SBVar vrate;
    protected String eqn;
    public int nstoichs;
    protected ArrayList<Stoich> stoichs;

    public SBReaction(SBModel sm, Reaction c) throws Xcept {
        this.sbmodel = sm;
        this.reac = c;
        this.stoichs = new ArrayList();
        int i = 0;
        while ((long)i < this.reac.getNumReactants()) {
            this.addStoich(this.reac.getReactant(i), false);
            ++i;
        }
        i = 0;
        while ((long)i < this.reac.getNumProducts()) {
            this.addStoich(this.reac.getProduct(i), true);
            ++i;
        }
        this.nstoichs = this.stoichs.size();
        this.eqn = "";
        String eq = this.reac.getReversible() ? "=>" : "<=>";
        for (int i2 = 0; i2 < this.nstoichs; ++i2) {
            if (eq != null && this.isProduct(i2)) {
                this.eqn = this.eqn + eq + " ";
                eq = null;
            }
            if (!this.mult(i2).equals("1")) {
                this.eqn = this.eqn + this.mult(i2);
            }
            this.eqn = this.eqn + this.spec(i2) + " ";
        }
        this.vrate = new SBVar(this.sbmodel, this.name(), "rate");
        this.vrate.setConst(false);
        KineticLaw law = this.reac.getKineticLaw();
        String rate = law == null ? this.makeKRate() : this.makeMathRate(law);
        this.vrate.setAssign(rate);
        this.vrate.setUnit("substance/time");
        for (int i3 = 0; i3 < this.nstoichs; ++i3) {
            String mult = this.mult(i3);
            if (!this.isProduct(i3)) {
                mult = "-" + mult;
            }
            mult = mult.equals("1") ? "" : mult + "*";
            String delta = mult + this.vrate.mmlName;
            this.vamt(i3).addODEDelta(delta);
        }
    }

    private void addStoich(SpeciesReference sref, boolean isProduct) throws Xcept {
        String spec = sref.getSpecies();
        SBSpecies sbspec = this.sbmodel.sbspecs.sbspec(spec);
        if (sbspec == null) {
            throw new Xcept("Reaction " + this.name() + ": invalid species " + spec);
        }
        String mult = "1";
        if (sref instanceof SpeciesReference) {
            SpeciesReference ref = sref;
            double stoich = ref.getStoichiometry();
            if (ref.isSetStoichiometryMath()) {
                String math = libsbml.writeMathMLToString(ref.getStoichiometryMath().getMath());
                mult = "(" + this.sbmodel.mathExprMML(math) + ")";
            } else {
                mult = Util.pretty((double)stoich);
            }
        }
        Stoich stoich = new Stoich();
        stoich.vamt = sbspec.vspec;
        stoich.spec = spec;
        stoich.mult = mult;
        stoich.isProduct = isProduct;
        this.stoichs.add(stoich);
    }

    private String makeMathRate(KineticLaw law) throws Xcept {
        this.sbmodel.sbparms.addList(this.sbmodel, law.getListOfParameters());
        ASTNode astn = law.getMath();
        String ret = this.sbmodel.mathExprMML(libsbml.writeMathMLToString(astn));
        return ret;
    }

    private String makeKRate() throws Xcept {
        SBVar kf = new SBVar(this.sbmodel, this.name() + ".kf", "rate");
        kf.setConst(true);
        kf.setExtern();
        SBVar kb = new SBVar(this.sbmodel, this.name() + ".kb", "rate");
        kb.setConst(true);
        kb.setExtern();
        String krate = "" + kf;
        String kprod = " - " + kb;
        for (int i = 0; i < this.nstoichs; ++i) {
            if (kprod != null && this.isProduct(i)) {
                krate = krate + kprod;
                kprod = null;
            }
            krate = krate + "*" + this.vamt(i);
            if (this.mult(i).equals("1")) continue;
            krate = krate + "^" + this.mult(i);
        }
        return krate;
    }

    public String name() {
        return this.reac.getId();
    }

    public String diagInfo() {
        return "Reaction " + this.name();
    }

    public Stoich stoich(int i) {
        return this.stoichs.get(i);
    }

    public SBVar vamt(int i) {
        return this.stoich((int)i).vamt;
    }

    public String spec(int i) {
        return this.stoich((int)i).spec;
    }

    public String mult(int i) {
        return this.stoich((int)i).mult;
    }

    public boolean isProduct(int i) {
        return this.stoich((int)i).isProduct;
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("// " + this.name() + ": " + this.eqn);
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            long nrxns = sbm.model.getNumReactions();
            int i = 0;
            while ((long)i < nrxns) {
                this.add(new SBReaction(sbm, sbm.model.getReaction(i)));
                ++i;
            }
        }

        public NList() {
        }

        public SBReaction sbreac(int i) {
            return (SBReaction)this.get(i);
        }

        public SBReaction sbreac(String n) {
            return (SBReaction)this.getByName(n);
        }
    }

    public static class Stoich {
        public SBVar vamt;
        public String spec;
        public String mult;
        public boolean isProduct;
    }
}

