/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.sbml2.SBModel;
import JSim.sbml2.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.libsbml;

public class SBRule
implements Named {
    protected SBModel sbmodel;
    protected Rule rule;
    protected String aexpr;

    public SBRule(SBModel sm, Rule r) throws Xcept {
        this.sbmodel = sm;
        this.rule = r;
        String text = libsbml.writeMathMLToString(this.rule.getMath());
        String rhs = this.sbmodel.mathExprMML(text);
        if (this.rule instanceof AssignmentRule) {
            SBVar v = this.sbmodel.sbvars.sbvar(this.rule.getVariable());
            v.setAssign(rhs);
        } else if (this.rule instanceof AlgebraicRule) {
            this.aexpr = rhs;
        } else if (this.rule instanceof RateRule) {
            SBVar v = this.sbmodel.sbvars.sbvar(this.rule.getVariable());
            v.setODE(rhs);
        }
    }

    public String name() {
        return "" + this.hashCode();
    }

    public String diagInfo() {
        return "Rule " + this.name();
    }

    public void writeMML(PrintWriter wrt) {
        if (this.aexpr == null) {
            return;
        }
        wrt.println("  " + this.aexpr + " = 0;");
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            long nrules = sbm.model.getNumRules();
            int i = 0;
            while ((long)i < nrules) {
                this.add(new SBRule(sbm, sbm.model.getRule(i)));
                ++i;
            }
        }

        public NList() {
        }

        public SBRule sbrule(int i) {
            return (SBRule)this.get(i);
        }

        public SBRule sbrule(String n) {
            return (SBRule)this.getByName(n);
        }
    }
}

