/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.sbml2.SBCompartment;
import JSim.sbml2.SBModel;
import JSim.sbml2.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.libsbml;

public class SBSpecies
implements Named {
    protected SBModel sbmodel;
    protected Species spec;
    protected boolean isSubstanceOnly;
    protected SBVar vspec;

    public SBSpecies(SBModel sm, Species s) throws Xcept {
        String compNameMML;
        String volunits;
        this.sbmodel = sm;
        this.spec = s;
        String sunits = this.spec.getSubstanceUnits();
        if (sunits.equals("")) {
            sunits = "substance";
        }
        if ((volunits = this.sbcomp().unit()).equals("")) {
            volunits = "volume";
        }
        String cunits = sunits + "/" + volunits;
        this.isSubstanceOnly = this.spec.getHasOnlySubstanceUnits();
        if (this.sbcomp().spatialDimensions() == 0L) {
            this.isSubstanceOnly = true;
        }
        this.vspec = new SBVar(this.sbmodel, this.name(), "species");
        if (this.isSubstanceOnly) {
            this.vspec.setUnit(sunits);
        } else {
            this.vspec.setUnit(cunits);
        }
        this.vspec.setConst(this.spec.getConstant());
        this.vspec.setBC(this.spec.getBoundaryCondition());
        this.vspec.setIsSubstanceOnly(this.isSubstanceOnly);
        this.vspec.compartment = compNameMML = this.sbcomp().v.mmlName;
        boolean initIsExtern = true;
        if (this.spec.isSetInitialConcentration()) {
            initIsExtern = false;
            this.vspec.setInitValue(this.spec.getInitialConcentration());
        } else if (this.spec.isSetInitialAmount()) {
            initIsExtern = false;
            double ival = this.spec.getInitialAmount();
            if (this.isSubstanceOnly || ival == 0.0) {
                this.vspec.setInitValue(ival);
            } else {
                String ivaleq = Util.pretty((double)ival) + "*" + compNameMML;
                this.vspec.setInitValue(ivaleq);
            }
        }
        InitialAssignment ia = sm.model.getInitialAssignment(this.name());
        if (ia != null) {
            initIsExtern = false;
            String form = libsbml.formulaToString(ia.getMath());
            if (this.isSubstanceOnly) {
                form = "(" + form + ")/" + compNameMML;
            }
            this.vspec.setInitValue(form);
        }
    }

    public String toString() {
        return this.diagInfo();
    }

    public String name() {
        return this.spec.getId();
    }

    public String diagInfo() {
        return "Species " + this.name();
    }

    public SBCompartment sbcomp() throws Xcept {
        String cname = this.spec.getCompartment();
        SBCompartment sbcomp = this.sbmodel.sbcomps.sbcomp(cname);
        if (sbcomp == null) {
            throw new Xcept("Species " + this.name() + " compartment " + cname + " not found");
        }
        return sbcomp;
    }

    public void setCalc() throws Xcept {
    }

    public void writeMML(PrintWriter wrt) {
    }

    public void writeMML2(PrintWriter wrt) {
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            long nspecs = sbm.model.getNumSpecies();
            for (long i = 0L; i < nspecs; ++i) {
                this.add(new SBSpecies(sbm, sbm.model.getSpecies(i)));
            }
        }

        public NList() {
        }

        public SBSpecies sbspec(int i) {
            return (SBSpecies)this.get(i);
        }

        public SBSpecies sbspec(String n) {
            return (SBSpecies)this.getByName(n);
        }
    }
}

