/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.aserver.ASServer;
import JSim.data.NamedVal;
import JSim.sbml2.SBModel;
import JSim.sbml2.UnitChecker;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.UnitDefinition;

public class SBUnit
implements Named {
    protected SBModel sbmodel;
    protected UnitDefinition unit;
    protected UnitChecker uc;
    protected String name;

    public SBUnit(SBModel sm, UnitDefinition c) throws Xcept {
        this.sbmodel = sm;
        this.unit = c;
        this.name = this.unit.getId();
        String decl = this.declString();
        NamedVal.NList options = new NamedVal.NList();
        ASServer server = ASServer.create((NamedVal.NList)options, null, null);
        UnitNList units = server.sysUnits();
        this.uc = new UnitChecker(units);
        if (this.uc.isConflict(this.name(), decl)) {
            this.sbmodel.changeUnit(this.name);
            this.name = this.sbmodel.mmlUnitName(this.name);
        }
    }

    public String name() {
        return this.name;
    }

    public String diagInfo() {
        return "UnitDefinition " + this.name();
    }

    public boolean isDefined() throws Xcept {
        return this.uc.isDefined(this.name);
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("unit " + this.name + " = " + this.declString() + ";");
    }

    public String declString() {
        double mult = 1.0;
        String decl = null;
        long nunits = this.unit.getNumUnits();
        int i = 0;
        while ((long)i < nunits) {
            Unit u = this.unit.getUnit(i);
            mult *= u.getMultiplier() * Math.pow(10.0, u.getScale());
            String s = this.kindToString(u.getKind());
            if (u.getExponent() != 1) {
                s = s + "^" + u.getExponent();
            }
            decl = decl == null ? s : decl + "*" + s;
            ++i;
        }
        if (decl == null) {
            decl = "scalar";
        }
        return Util.pretty((double)mult) + " " + decl;
    }

    public String kindToString(int kind) {
        switch (kind) {
            case 0: {
                return "ampere";
            }
            case 1: {
                return "becquerel";
            }
            case 2: {
                return "candela";
            }
            case 3: {
                return "celsius";
            }
            case 4: {
                return "coulomb";
            }
            case 5: {
                return "dimensionless";
            }
            case 6: {
                return "farad";
            }
            case 7: {
                return "gram";
            }
            case 8: {
                return "gray";
            }
            case 9: {
                return "henry";
            }
            case 10: {
                return "hertz";
            }
            case 11: {
                return "item";
            }
            case 12: {
                return "joule";
            }
            case 13: {
                return "katal";
            }
            case 14: {
                return "kelvin";
            }
            case 15: {
                return "kilogram";
            }
            case 16: {
                return "litre";
            }
            case 17: {
                return "litre";
            }
            case 18: {
                return "lumen";
            }
            case 19: {
                return "lux";
            }
            case 20: {
                return "metre";
            }
            case 21: {
                return "metre";
            }
            case 22: {
                return "mole";
            }
            case 23: {
                return "newton";
            }
            case 24: {
                return "ohm";
            }
            case 25: {
                return "pascal";
            }
            case 26: {
                return "radian";
            }
            case 27: {
                return "second";
            }
            case 28: {
                return "siemens";
            }
            case 29: {
                return "sievert";
            }
            case 30: {
                return "steradian";
            }
            case 31: {
                return "tesla";
            }
            case 32: {
                return "volt";
            }
            case 33: {
                return "watt";
            }
            case 34: {
                return "weber";
            }
            case 35: {
                return "invalid";
            }
        }
        return "";
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            long nunits = sbm.model.getNumUnitDefinitions();
            int i = 0;
            while ((long)i < nunits) {
                SBUnit sbu = new SBUnit(sbm, sbm.model.getUnitDefinition(i));
                if (!sbu.isDefined()) {
                    this.add(sbu);
                }
                ++i;
            }
        }

        public NList() {
        }

        public SBUnit sbunit(int i) {
            return (SBUnit)this.get(i);
        }

        public SBUnit sbunit(String n) {
            return (SBUnit)this.getByName(n);
        }
    }
}

