/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml2;

import JSim.aserver.ASServer;
import JSim.data.NamedVal;
import JSim.util.Expr;
import JSim.util.NameSpace;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Xcept;

public class UnitChecker
implements NameSpace {
    private UnitNList units;

    public UnitChecker(UnitNList units) {
        this.units = units;
    }

    public boolean isDefined(String name) throws Xcept {
        try {
            Unit.parse((NameSpace)this, (String)("1 " + name));
            return true;
        }
        catch (Xcept e) {
            return false;
        }
    }

    public boolean isConflict(String sbmlName, String jsimDef) throws Xcept {
        try {
            Unit usbml = Unit.parse((NameSpace)this, (String)("1 " + sbmlName));
            Unit udef = Unit.parse((NameSpace)this, (String)jsimDef);
            return !Unit.same((Unit)usbml, (Unit)udef);
        }
        catch (Xcept e) {
            return false;
        }
    }

    public Unit unitByName(String name) throws Xcept {
        return this.units.byName(name);
    }

    public Expr compByName(String name) throws Xcept {
        throw new Xcept("UnitChecker: compByName not implemented");
    }

    public Expr makeDeriv(Expr e1, Expr e2) throws Xcept {
        throw new Xcept("UnitChecker: makeDeriv not implemented");
    }

    public Expr funcCall(String name, Expr.List elist) throws Xcept {
        throw new Xcept("UnitChecker: funcCall not implemented");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Xcept("Usage: UnitChecker sbmlName jsimDef");
        }
        NamedVal.NList options = new NamedVal.NList();
        ASServer server = ASServer.create((NamedVal.NList)options, null, null);
        UnitNList units = server.sysUnits();
        UnitChecker checker = new UnitChecker(units);
        boolean isConflict = checker.isConflict(args[0], args[1]);
        System.out.println("isConflict=" + isConflict);
    }
}

