/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.util.PrettyFormat;
import JSim.util.Util;
import JSim.xsim.CF;
import JSim.xsim.CFBoxPar;
import JSim.xsim.CFItem;

public class CFGroup
extends CFItem {
    public String name;
    public String label;
    public int width;
    public int height;
    public boolean popup;
    public double pix_cfx;
    public double pix_cfy;
    public int fontSize;
    public double jsimReduce;
    public PrettyFormat posFmt;
    public CFItem.List items;

    public CFGroup(CF c, String n) {
        super(c);
        this.name = CFGroup.safeName(n);
        this.label = n;
        this.height = 1000;
        this.width = 1000;
        this.pix_cfy = 0.5;
        this.pix_cfx = 0.5;
        this.fontSize = 12;
        this.jsimReduce = 1.0;
        this.posFmt = new PrettyFormat(7);
        this.items = new CFItem.List();
    }

    public void set(String key, String value) {
        if ((key = key.toLowerCase()).equals("width")) {
            this.width = this.toInt(value);
        } else if (key.equals("height")) {
            this.height = this.toInt(value);
        } else if (key.equals("popup")) {
            this.popup = true;
        } else if (key.equals("label")) {
            this.label = value;
        }
    }

    public double xscale(double cfx) {
        double x = this.jsimReduce * cfx * this.pix_cfx / (double)this.fontSize;
        return Util.round((double)x, (double)0.1);
    }

    public double yscale(double cfy) {
        double y = this.jsimReduce * cfy * this.pix_cfy / (double)this.fontSize;
        return Util.round((double)y, (double)0.1);
    }

    public void writeRTML() {
        if (this.name.equals("Inputs")) {
            return;
        }
        if (this.name.equals("Outputs")) {
            return;
        }
        this.println("    <page name=\"" + this.name + "\">");
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.item(i) instanceof CFBoxPar) continue;
            this.items.item(i).writeRTML();
        }
        this.println("    </page>");
    }
}

