/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.util.Util;
import JSim.util.Xcept;
import JSim.xsim.CFGroup;
import JSim.xsim.CFItem;

public abstract class CFGroupItem
extends CFItem {
    public CFGroup group;
    public int x;
    public int y;
    public int w;
    public int h;
    public String font;

    public CFGroupItem(CFGroup g) {
        super(g.cf);
        this.group = g;
        this.group.items.add(this);
    }

    public void setDim(String[] d) {
        try {
            this.x = Util.toInt((String)d[0]);
            this.y = Util.toInt((String)d[1]);
            this.w = Util.toInt((String)d[2]);
            this.h = Util.toInt((String)d[3]);
        }
        catch (Xcept e) {
            this.error("toInt() error in setDim for group item " + this);
        }
    }

    public void set(String key, String value) {
        if ((key = key.toLowerCase()).equals("font")) {
            this.font = value;
        }
        this.setItem(key, value);
    }

    protected abstract void setItem(String var1, String var2);

    public String pos() {
        String sx = this.group.posFmt.format(this.group.xscale(this.x));
        String sy = this.group.posFmt.format(this.group.yscale(this.y));
        return "pos=\"" + sx + " " + sy + "\"";
    }

    public String size() {
        String sw = this.group.posFmt.format(this.group.xscale(this.w));
        String sh = this.group.posFmt.format(this.group.yscale(this.h));
        return "size=\"" + sw + " " + sh + "\"";
    }

    public void writeRTML() {
        this.println("\tclass name=\"" + this.getClass().getName() + "\"/>");
    }
}

