/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.xsim.CF;
import JSim.xsim.CFItem;
import JSim.xsim.CFMenuPage;
import java.util.ArrayList;

public class CFMenu
extends CFItem {
    public boolean top;
    public String text;
    public CFItem.List items;

    public CFMenu(CF c, String n) {
        super(c);
        this.text = n;
        this.top = this.text == null;
        this.items = new CFItem.List();
    }

    public boolean hasContent() {
        for (int i = 0; i < this.items.size(); ++i) {
            CFItem item = this.items.item(i);
            if (item instanceof CFMenu && ((CFMenu)item).hasContent()) {
                return true;
            }
            if (!(item instanceof CFMenuPage) || !((CFMenuPage)item).hasContent()) continue;
            return true;
        }
        return false;
    }

    public void writeRTML() {
        this.writeRTML("    ");
    }

    public void writeRTML(String indent) {
        if (!this.hasContent()) {
            return;
        }
        String tlab = this.text == null ? "" : CFMenu.textAttr(this.text);
        this.println(indent + "<menu" + tlab + ">");
        for (int i = 0; i < this.items.size(); ++i) {
            CFItem item = this.items.item(i);
            if (item instanceof CFMenu) {
                ((CFMenu)item).writeRTML(indent + "    ");
            }
            if (!(item instanceof CFMenuPage)) continue;
            ((CFMenuPage)item).writeRTML(indent + "    ");
        }
        this.println(indent + "</menu>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stack
    extends ArrayList<CFMenu> {
        public Stack() {
            super(4);
        }

        public void push(CFMenu m) {
            this.add(m);
        }

        public CFMenu top() {
            int n = this.size();
            if (n < 1) {
                return null;
            }
            return (CFMenu)this.get(n - 1);
        }

        public void pop() {
            int n = this.size();
            if (n > 0) {
                this.remove(n - 1);
            }
        }
    }
}

