/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.mml.Model;
import JSim.util.StringList;
import JSim.util.Xcept;
import JSim.xsim.CF;
import JSim.xsim.CFBox;
import JSim.xsim.CFBoxPar;
import JSim.xsim.CFButton;
import JSim.xsim.CFFeed;
import JSim.xsim.CFFigure;
import JSim.xsim.CFGroup;
import JSim.xsim.CFGroupItem;
import JSim.xsim.CFItem;
import JSim.xsim.CFIvar;
import JSim.xsim.CFMenu;
import JSim.xsim.CFMenuPage;
import JSim.xsim.CFModel;
import JSim.xsim.CFPar;
import JSim.xsim.CFParser;
import JSim.xsim.CFScanner;
import JSim.xsim.CFText;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;

public class CFReader
extends CF {
    public CFScanner scanner;
    public CFItem parseItem;
    public CFGroup parseGroup;
    public CFGroupItem parseGItem;
    public CFBox parseBox;
    public CFMenu.Stack menuStack;

    public CFReader(File f, Model u) throws Xcept {
        this.cfName = f.getAbsolutePath();
        this.modName = f.getName();
        int lx = this.modName.lastIndexOf(46);
        if (lx > 0) {
            this.modName = this.modName.substring(0, lx);
        }
        this.unitModel = u;
        this.out = new PrintWriter(System.out, true);
        this.err = new PrintWriter(System.err, true);
        this.maxloc = 2001;
        this.renamedPars = new CFItem.List();
        this.dims = new StringList(4);
        this.menuStack = new CFMenu.Stack();
        try {
            FileReader rdr = new FileReader(f);
            this.scanner = new CFScanner(rdr);
            CFParser parser = new CFParser(this.scanner);
            parser.cfr = this;
            parser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("parser failed one " + this.scanPos() + "  " + e);
        }
        this.maxloc += 1000;
        this.ivar.pstart.rename(this.ivar.name() + ".min");
        this.ivar.pstop.rename(this.ivar.name() + ".max");
        this.ivar.pincr.rename(this.ivar.name() + ".delta");
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.item(i).post();
        }
    }

    public void startItem(String s, String n) {
        if ((s = s.toLowerCase()).equals("model")) {
            this.parseItem = new CFModel(this);
        } else if (s.equals("ivar")) {
            this.parseItem = new CFIvar(this, n);
        } else if (s.equals("feed")) {
            this.parseItem = new CFFeed(this, n);
        } else if (s.equals("logical")) {
            this.parseItem = new CFPar(this, 1, n);
        } else if (s.equals("real")) {
            this.parseItem = new CFPar(this, 4, n);
        } else if (s.equals("choice")) {
            this.parseItem = new CFPar(this, 2, n);
        } else if (s.equals("int") || s.equals("integer")) {
            this.parseItem = new CFPar(this, 3, n);
        } else if (s.equals("string")) {
            this.parseItem = new CFPar(this, 5, n);
        } else if (s.equals("parinfo")) {
            this.parseItem = this.par(n);
        } else {
            this.error("illegal top-level item: \"" + s + "\"");
        }
    }

    public void startMenu(String n) {
        CFMenu m = new CFMenu(this, n);
        CFMenu parent = this.menuStack.top();
        if (parent != null) {
            parent.items.add(m);
        }
        this.menuStack.push(m);
    }

    public void addMenuPage(String n) {
        CFMenuPage p = new CFMenuPage(this, n);
        this.menuStack.top().items.add(p);
    }

    public void doneMenu() {
        this.menuStack.pop();
    }

    public void startGroup(String n) {
        this.parseGroup = new CFGroup(this, n);
        this.parseItem = this.parseGroup;
    }

    public void startGroupItem(String s, String n) {
        if (this.parseGroup == null) {
            this.error("group item \"" + n + "\"lacks parent group");
            return;
        }
        if ((s = s.toLowerCase()).equals("figure")) {
            this.parseItem = new CFFigure(this.parseGroup, n);
        } else if (s.equals("text")) {
            this.parseItem = new CFText(this.parseGroup, n);
        } else if (s.equals("parbtn") || s.equals("parbutton")) {
            this.parseItem = new CFButton(this.parseGroup, 1, n);
        } else if (s.equals("groupbtn") || s.equals("groupbutton")) {
            this.parseItem = new CFButton(this.parseGroup, 2, n);
        } else if (s.equals("feedbtn") || s.equals("feedbutton")) {
            this.parseItem = new CFButton(this.parseGroup, 3, n);
        } else if (s.equals("box")) {
            this.parseItem = new CFBox(this.parseGroup);
        } else {
            this.error("illegal group item: \"" + s + "\"");
        }
    }

    public void setDim(String[] dims) {
        if (!(this.parseItem instanceof CFGroupItem)) {
            this.error("setDim without group item");
            return;
        }
        ((CFGroupItem)this.parseItem).setDim(dims);
    }

    public void doneGroupItem() {
        this.parseItem = this.parseGroup;
    }

    public void startBox(String[] dims) {
        if (this.parseGroup == null) {
            this.error("box lacks parent group");
            return;
        }
        this.parseBox = new CFBox(this.parseGroup);
        this.parseItem = this.parseBox;
        this.setDim(dims);
    }

    public void startBoxPar(String n) {
        this.parseItem = new CFBoxPar(this.parseBox, n);
    }

    public void doneBoxPar() {
        this.parseItem = this.parseBox;
    }

    public void doneBox() {
        this.parseItem = this.parseGroup;
    }

    public void setParseAttr(String key, String value) {
        if (this.parseItem == null) {
            return;
        }
        this.parseItem.set(key, value);
    }

    public void setParseAttrList(String key, StringList value) {
        if (this.parseItem == null) {
            return;
        }
        this.parseItem.setList(key, value);
    }

    public String scanPos() {
        return this.cfName + ": near line #" + this.scanner.getLineNo() + " char #" + this.scanner.getCharNo() + " token \"" + this.scanner.tokText() + "\"";
    }
}

