/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Notes {
    private List notes;
    private static final Pattern checkNoteFormat = Pattern.compile("(?s).*<[sbml:]?notes>.?<p xmlns=\"http://www.w3.org/1999/xhtml\">(.*)</p>.?</[sbml:]?notes>.*");
    private static final Pattern getNotes = Pattern.compile("<notes>(.*)</notes>");

    private static String wrapItem(String item) {
        Matcher checkNotes = checkNoteFormat.matcher(item);
        if (checkNotes.matches()) {
            return item;
        }
        checkNotes = getNotes.matcher(item);
        if (checkNotes.matches()) {
            item = checkNotes.group(1);
        }
        return "<notes><p xmlns=\"http://www.w3.org/1999/xhtml\">" + item + "</p></notes>\n";
    }

    public void add(String note) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(Notes.wrapItem(note));
    }

    public void clear() {
        this.notes = null;
    }

    public String get(int index) {
        if (this.notes == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (String)this.notes.get(index);
    }

    public int size() {
        return this.notes == null ? 0 : this.notes.size();
    }

    public Iterator iterator() {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        return this.notes.iterator();
    }

    public void remove(int index) {
        if (this.notes == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.notes.remove(index);
    }

    public void set(int index, String note) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.set(index, Notes.wrapItem(note));
    }

    public String toString() {
        if (this.notes == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.notes.iterator();
        while (iterator.hasNext()) {
            String note = (String)iterator.next();
            if (note.split("\\s*</??notes>\\s*").length == 0) continue;
            buffer.append(note + "\n");
        }
        return buffer.toString();
    }

    Notes() {
    }
}

