/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.regex.Pattern;
import jigcell.sbml2.Event;
import jigcell.sbml2.Link;
import jigcell.sbml2.Model;
import jigcell.sbml2.SBase;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public abstract class SBaseId
extends SBase {
    private static final Pattern PATTERN_ID = Pattern.compile("\\A[a-zA-Z0-9_][a-zA-Z0-9_]*\\z");
    private String id;
    private String name;

    public static final boolean isValidId(String id) {
        return id != null && PATTERN_ID.matcher(id).matches();
    }

    public SBaseId() {
        this(null, null);
    }

    public SBaseId(String id, String name) {
        if (id != null) {
            this.setId(id);
        }
        if (name != null) {
            this.setName(name);
        }
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name == null ? this.id : this.name;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public boolean isValid(Model model) {
        if (!super.isValid(model)) {
            return false;
        }
        String id = this.getId();
        return this instanceof Event || this instanceof Link || this instanceof Model || id != null;
    }

    public final void setId(String id) {
        if (id != null && !SBaseId.isValidId(id)) {
            throw new IllegalArgumentException("Invalid SBML identifier: " + id);
        }
        this.id = id;
    }

    public final void setName(String name) {
        this.name = name;
    }

    protected void parse(Attributes attributes) {
        super.parse(attributes);
        this.setId(attributes.getValue("id"));
        this.setName(attributes.getValue("name"));
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        if (this.id != null) {
            printer.addAttribute("id", this.getId());
        }
        if (this.name != null) {
            printer.addAttribute("name", this.name);
        }
        return printer;
    }
}

