/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.math;

import java.util.Hashtable;
import jigcell.sbml2.math.MathMLConvertorSAX;
import jigcell.sbml2.math.SBMLNode;

public class MathMLConvertor {
    private static MathMLConvertorSAX saxConvertor;
    static boolean firstPiece;
    private Hashtable associative = new Hashtable();
    private Hashtable order = new Hashtable();

    public static void insertFunction(String function) {
        saxConvertor.insertFunction(function);
    }

    public static void reset() {
        saxConvertor.reset();
    }

    public static String toNormalMath(String mathML, boolean isLambda, boolean isRatelaw) throws Exception {
        firstPiece = true;
        saxConvertor = new MathMLConvertorSAX(mathML, isLambda, isRatelaw);
        StringBuffer normalMath = new StringBuffer();
        SBMLNode runningNode = saxConvertor.getRoot();
        if (saxConvertor.getRoot() == null) {
            return "";
        }
        normalMath.append(MathMLConvertor.treeOutput(runningNode));
        if (normalMath.toString().trim().length() == 0) {
            return "0";
        }
        return normalMath.toString();
    }

    private static String treeOutput(SBMLNode rootNode) {
        boolean operator = false;
        if (rootNode != null && rootNode.element != null && rootNode.element.toString() != null && rootNode.element.toString().startsWith("@")) {
            operator = true;
        }
        if (operator) {
            String temp = rootNode.element.toString().substring(1, rootNode.element.toString().length());
            if (temp.equals("piecewise")) {
                StringBuffer b = new StringBuffer("(");
                for (int i = 0; i < rootNode.children.size(); ++i) {
                    if (((SBMLNode)rootNode.children.get((int)i)).element.toString().equals("piece") && i != 0) {
                        b.append("else");
                    }
                    b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                    if (i + 1 == rootNode.children.size()) continue;
                    b.append("\n");
                }
                b.append(")");
                return b.toString();
            }
            if (temp.equals("piece")) {
                if (firstPiece) {
                    firstPiece = false;
                    return "if (" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + ") then " + "(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + ")\n";
                }
                return "elseif (" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + ") then " + "(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + ")\n";
            }
            if (temp.equals("otherwise")) {
                return "else (" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + ")\n";
            }
            if (temp.equals("eq")) {
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < rootNode.children.size(); ++i) {
                    b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                    if (i + 1 == rootNode.children.size()) continue;
                    b.append("==");
                }
                return b.toString();
            }
            if (temp.equals("neq")) {
                if (rootNode.children.size() == 2) {
                    return MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "!=" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1));
                }
            } else {
                if (temp.equals("gt")) {
                    StringBuffer b = new StringBuffer();
                    for (int i = 0; i < rootNode.children.size(); ++i) {
                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                        if (i + 1 == rootNode.children.size()) continue;
                        b.append(">");
                    }
                    return b.toString();
                }
                if (temp.equals("lt")) {
                    StringBuffer b = new StringBuffer();
                    for (int i = 0; i < rootNode.children.size(); ++i) {
                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                        if (i + 1 == rootNode.children.size()) continue;
                        b.append("<");
                    }
                    return b.toString();
                }
                if (temp.equals("geq")) {
                    StringBuffer b = new StringBuffer();
                    for (int i = 0; i < rootNode.children.size(); ++i) {
                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                        if (i + 1 == rootNode.children.size()) continue;
                        b.append(">=");
                    }
                    return b.toString();
                }
                if (temp.equals("leq")) {
                    StringBuffer b = new StringBuffer();
                    for (int i = 0; i < rootNode.children.size(); ++i) {
                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                        if (i + 1 == rootNode.children.size()) continue;
                        b.append("<=");
                    }
                    return b.toString();
                }
                if (temp.equals("plus")) {
                    StringBuffer b = new StringBuffer("(");
                    for (int i = 0; i < rootNode.children.size(); ++i) {
                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                        if (i + 1 == rootNode.children.size()) continue;
                        b.append("+");
                    }
                    b.append(")");
                    return b.toString();
                }
                if (temp.equals("minus")) {
                    if (rootNode.children.size() == 2) {
                        return "(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "-" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + ")";
                    }
                    return "(-" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + ")";
                }
                if (temp.equals("times")) {
                    StringBuffer b = new StringBuffer("(");
                    for (int i = 0; i < rootNode.children.size(); ++i) {
                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                        if (i + 1 == rootNode.children.size()) continue;
                        b.append("*");
                    }
                    b.append(")");
                    return b.toString();
                }
                if (temp.equals("divide")) {
                    if (rootNode.children.size() == 2) {
                        return "(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "/" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + ")";
                    }
                } else if (temp.equals("power")) {
                    if (rootNode.children.size() == 2) {
                        return "(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "^" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + ")";
                    }
                } else if (temp.equals("root")) {
                    if (rootNode.children.size() == 2) {
                        if (((SBMLNode)rootNode.children.get((int)0)).element.toString().equals("2")) {
                            return "(sqrt(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + "))";
                        }
                        return "(root(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "," + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + "))";
                    }
                } else {
                    if (temp.equals("abs")) {
                        return "(abs(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                    }
                    if (temp.equals("exp")) {
                        return "(exp(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                    }
                    if (temp.equals("ln")) {
                        return "(ln(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                    }
                    if (temp.equals("log")) {
                        if (rootNode.children.size() == 2) {
                            if (((SBMLNode)rootNode.children.get((int)0)).element.toString().equals("10")) {
                                return "(log10(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + "))";
                            }
                            return "(log(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "," + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(1)) + "))";
                        }
                    } else {
                        if (temp.equals("floor")) {
                            return "(floor(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                        }
                        if (temp.equals("ceiling")) {
                            return "(ceiling(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                        }
                        if (temp.equals("factorial")) {
                            return "(factorial" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                        }
                        if (temp.equals("and")) {
                            StringBuffer b = new StringBuffer();
                            for (int i = 0; i < rootNode.children.size(); ++i) {
                                b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                                if (i + 1 == rootNode.children.size()) continue;
                                b.append(" AND ");
                            }
                            return b.toString();
                        }
                        if (temp.equals("or")) {
                            StringBuffer b = new StringBuffer();
                            for (int i = 0; i < rootNode.children.size(); ++i) {
                                b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                                if (i + 1 == rootNode.children.size()) continue;
                                b.append(" OR ");
                            }
                            return b.toString();
                        }
                        if (temp.equals("xor")) {
                            StringBuffer b = new StringBuffer();
                            for (int i = 0; i < rootNode.children.size(); ++i) {
                                b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                                if (i + 1 == rootNode.children.size()) continue;
                                b.append(" XOR ");
                            }
                            return b.toString();
                        }
                        if (temp.equals("not")) {
                            return "(!" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + ")";
                        }
                        if (!temp.equals("logbase")) {
                            if (temp.equals("sin")) {
                                return "(sin(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("cos")) {
                                return "(cos(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("tan")) {
                                return "(tan(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("sec")) {
                                return "(sec(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("csc")) {
                                return "(csc(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("cot")) {
                                return "(cot(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("sinh")) {
                                return "(sinh(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("cosh")) {
                                return "(cosh(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("tanh")) {
                                return "(tanh(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("sech")) {
                                return "(sech(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("csch")) {
                                return "(csch(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("coth")) {
                                return "(coth(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arcsin")) {
                                return "(arcsin(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arccos")) {
                                return "(arccos(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arctan")) {
                                return "(arctan(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arcsinh")) {
                                return "(arcsinh(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arccosh")) {
                                return "(arccosh(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arctanh")) {
                                return "(arctanh(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arccot")) {
                                return "(arccot(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arccoth")) {
                                return "(arccoth(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arccsc")) {
                                return "(arccsc(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arccsch")) {
                                return "(arccsch(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arcsec")) {
                                return "(arcsec(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("arcsech")) {
                                return "(arcsech(" + MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(0)) + "))";
                            }
                            if (temp.equals("true")) {
                                return "(true)";
                            }
                            if (temp.equals("false")) {
                                return "(false)";
                            }
                            if (temp.equals("notanumber")) {
                                return "(nan)";
                            }
                            if (temp.equals("pi")) {
                                return "(pi)";
                            }
                            if (temp.equals("infinity")) {
                                return "(infinity)";
                            }
                            if (temp.equals("exponentiale")) {
                                return "(exponentiale)";
                            }
                            if (!(temp.equals("semantics") || temp.equals("annotation") || temp.equals("annotation-xml"))) {
                                if (temp.equals("time")) {
                                    return "t";
                                }
                                if (temp.equals("delay")) {
                                    StringBuffer b = new StringBuffer();
                                    for (int i = 0; i < 2; ++i) {
                                        b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                                        if (i != 0) continue;
                                        b.append(",");
                                    }
                                    return "delay(" + b.toString() + ")";
                                }
                            }
                        }
                    }
                }
            }
        } else {
            if (rootNode.element.toString() != null && saxConvertor.getFunctions().containsKey(rootNode.element.toString())) {
                StringBuffer b = new StringBuffer(rootNode.element.toString() + "(");
                for (int i = 0; i < rootNode.children.size(); ++i) {
                    b.append(MathMLConvertor.treeOutput((SBMLNode)rootNode.children.get(i)));
                    if (i + 1 == rootNode.children.size()) continue;
                    b.append(",");
                }
                b.append(")");
                return b.toString();
            }
            return rootNode.element.toString();
        }
        return "";
    }

    public MathMLConvertor() {
        saxConvertor = new MathMLConvertorSAX();
        firstPiece = true;
        this.order = new Hashtable(30);
        this.order.put("power", new Integer(1));
        this.order.put("times", new Integer(2));
        this.order.put("divide", new Integer(2));
        this.order.put("plus", new Integer(3));
        this.order.put("minus", new Integer(3));
        this.order.put("eq", new Integer(4));
        this.order.put("neq", new Integer(4));
        this.order.put("gt", new Integer(4));
        this.order.put("lt", new Integer(4));
        this.order.put("geq", new Integer(4));
        this.order.put("leq", new Integer(4));
        this.order.put("not", new Integer(5));
        this.order.put("and", new Integer(6));
        this.order.put("or", new Integer(7));
        this.associative = new Hashtable(12);
        this.associative.put(new Integer(1), new Boolean(true));
        this.associative.put(new Integer(2), new Boolean(true));
        this.associative.put(new Integer(3), new Boolean(true));
        this.associative.put(new Integer(4), new Boolean(false));
        this.associative.put(new Integer(5), new Boolean(true));
        this.associative.put(new Integer(6), new Boolean(true));
        this.associative.put(new Integer(7), new Boolean(true));
    }

    static {
        firstPiece = true;
        saxConvertor = new MathMLConvertorSAX();
    }
}

