/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.math;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jigcell.sbml2.math.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class MathMLExpression {
    private static StringBuffer tabs = new StringBuffer();
    private ArrayList functionArgs = new ArrayList();
    private boolean lambdaFunction;
    private boolean lookForFunctionArgs = true;
    private Node mathMLParseTree;
    private Node simpleTree;
    private StringBuffer mathML;

    public static String[] getIdentifiers(Node cur) {
        return MathMLExpression.getIdentifiers_(cur).toArray(new String[0]);
    }

    public static void printParseTree(Node cur) {
        System.out.println(tabs + "node: " + cur.getQName() + ", value: " + cur.getValue().trim());
        tabs.append("    ");
        for (int i = 0; i < cur.getNumChildren(); ++i) {
            MathMLExpression.printParseTree(cur.getChild(i));
        }
        tabs.delete(tabs.length() - 4, tabs.length());
    }

    private static ArrayList getIdentifiers_(Node cur) {
        String type = cur.getSimpleName().toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (type.equals("cn")) {
            return arrayList;
        }
        if (type.equals("ci")) {
            arrayList.add(cur.getValue());
        } else {
            for (int i = 0; i < cur.getNumChildren(); ++i) {
                arrayList.addAll(MathMLExpression.getIdentifiers_(cur.getChild(i)));
            }
        }
        return arrayList;
    }

    public MathMLExpression(String mathML) throws SAXException, IOException, ParserConfigurationException {
        this.parse(new InputSource(new StringReader(mathML)));
    }

    public Node getExpression() throws Exception {
        if (this.simpleTree == null) {
            this.simpleTree = this.genSimpleTree(this.mathMLParseTree);
        }
        return this.simpleTree;
    }

    public String[] getFunctionArguments() throws Exception {
        if (this.simpleTree == null) {
            this.simpleTree = this.genSimpleTree(this.mathMLParseTree);
        }
        return this.functionArgs.toArray(new String[0]);
    }

    public Node getMathMLParseTree() {
        return this.mathMLParseTree;
    }

    public boolean isLambdaFunction() {
        return this.lambdaFunction;
    }

    public void setLambdaFunction(boolean lambdaFunction) {
        this.lambdaFunction = lambdaFunction;
    }

    public Node solve(String var) throws Exception {
        if (this.simpleTree == null) {
            this.simpleTree = this.genSimpleTree(this.mathMLParseTree);
        }
        Equation equation = this.solve_(this.simpleTree, var);
        if (equation.right == null) {
            throw new Exception("Variable doesn't occur on the right side of its expression: " + var);
        }
        if (equation.left == null) {
            throw new Exception("Variable occurs alone on the right side of its expression: " + var);
        }
        Node minus = new Node("minus", "");
        boolean isOne = false;
        try {
            if (Double.parseDouble(equation.right.getValue()) == 1.0) {
                isOne = true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (isOne) {
            minus.addChild(equation.left);
        } else {
            Node divide = new Node("divide", "");
            minus.addChild(divide);
            divide.addChild(equation.left);
            divide.addChild(equation.right);
        }
        return minus;
    }

    private Node genSimpleTree(Node current) throws Exception {
        String name = current.getSimpleName().toLowerCase();
        if (name.equals("ci") || name.equals("csymbol") || name.equals("true") || name.equals("false") || name.equals("notanumber") || name.equals("pi") || name.equals("infinity") || name.equals("exponentiale")) {
            if (current.getNumChildren() != 0) {
                throw new Exception("Expected 0 children for " + name + " and there are " + current.getNumChildren() + " children.");
            }
            return new Node(current);
        }
        if (name.equals("cn")) {
            if (current.getNumChildren() == 0) {
                return new Node(current);
            }
            if (current.getNumChildren() != 1) {
                throw new Exception("Node cn must have 0 or 1 children.");
            }
            Node newNode = new Node(current);
            String type = newNode.getAttributes().getValue("type");
            StringTokenizer values = new StringTokenizer(newNode.getValue());
            if (type.equals("e-notation")) {
                newNode.setValue(String.valueOf(Double.parseDouble(values.nextToken() + "E" + values.nextToken())));
            } else if (type.equals("rational")) {
                newNode.setValue(String.valueOf(Double.parseDouble(values.nextToken()) / Double.parseDouble(values.nextToken())));
            } else {
                throw new Exception("Unknown cn type: " + type + ".");
            }
            newNode.removeAllChildren();
            return newNode;
        }
        if (name.equals("piecewise") || name.equals("piece") || name.equals("otherwise")) {
            int numChildren = current.getNumChildren();
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            if (name.equals("piecewise")) {
                for (int i = 0; i < numChildren; ++i) {
                    newNode.addChild(new Node(this.genSimpleTree(current.getChild(i))));
                }
            } else if (name.equals("piece")) {
                newNode.addChild(new Node(this.genSimpleTree(current.getChild(0))));
                newNode.addChild(new Node(this.genSimpleTree(current.getChild(1))));
            } else if (name.equals("otherwise")) {
                newNode.addChild(new Node(this.genSimpleTree(current.getChild(0))));
            }
            return newNode;
        }
        if (name.equals("apply")) {
            int numChildren = current.getNumChildren();
            if (numChildren == 0) {
                throw new Exception("Node apply must have at least one child.");
            }
            Node newNode = new Node(current.getChild(0));
            if (newNode.getSimpleName().equalsIgnoreCase("ci")) {
                newNode.setQName("function");
            }
            newNode.children = new ArrayList(current.children);
            newNode.children.remove(0);
            return this.genSimpleTree(newNode);
        }
        if (name.equals("eq") || name.equals("neq") || name.equals("gt") || name.equals("lt") || name.equals("geq") || name.equals("leq") || name.equals("divide") || name.equals("power")) {
            if (current.getNumChildren() != 2) {
                throw new Exception("Number of children must be equal to 2 for binary operator " + name + ".  There are " + current.getNumChildren() + " children.");
            }
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            newNode.addChild(this.genSimpleTree(current.getChild(0)));
            newNode.addChild(this.genSimpleTree(current.getChild(1)));
            return newNode;
        }
        if (name.equals("and") || name.equals("or") || name.equals("xor")) {
            if (current.getNumChildren() < 2) {
                throw new Exception("Operator " + name + " must have at least two children.");
            }
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            for (int i = 0; i < current.getNumChildren(); ++i) {
                newNode.addChild(this.genSimpleTree(current.getChild(i)));
            }
            while (newNode.getNumChildren() > 2) {
                Node rightNode = newNode.removeChild(newNode.getNumChildren() - 1);
                Node leftNode = newNode.removeChild(newNode.getNumChildren() - 1);
                Node middleNode = new Node("math:" + name, "");
                middleNode.addChild(leftNode);
                middleNode.addChild(rightNode);
                newNode.addChild(middleNode);
            }
            return newNode;
        }
        if (name.equals("root")) {
            if (current.getNumChildren() == 1) {
                if (current.getChild(0).getSimpleName().equalsIgnoreCase("degree")) {
                    throw new Exception("Operator root is missing its radicand.");
                }
                Node degree = new Node("math:degree", "");
                degree.addChild(new Node("math:cn", "2"));
                current.addChild(degree);
            }
            if (current.getNumChildren() != 2) {
                throw new Exception("Number of children must be equal to 2 for binary operator " + name + ".  There are " + current.getNumChildren() + " children.");
            }
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            if (current.getChild(0).getSimpleName().equalsIgnoreCase("degree")) {
                newNode.addChild(this.genSimpleTree(current.getChild(1)));
                newNode.addChild(this.genSimpleTree(current.getChild(0)));
            } else {
                newNode.addChild(this.genSimpleTree(current.getChild(0)));
                newNode.addChild(this.genSimpleTree(current.getChild(1)));
            }
            return newNode;
        }
        if (name.equals("times") || name.equals("plus")) {
            int numChildren = current.getNumChildren();
            switch (numChildren) {
                case 0: {
                    if (name.equals("times")) {
                        return new Node("cn", "1");
                    }
                    return new Node("cn", "0");
                }
                case 1: {
                    return this.genSimpleTree(current.getChild(0));
                }
            }
            Node leftNode = this.genSimpleTree(current.getChild(0));
            Node rightNode = new Node(current);
            Node newNode = new Node(current);
            rightNode.removeChild(0);
            rightNode = this.genSimpleTree(rightNode);
            newNode.removeAllChildren();
            newNode.addChild(leftNode);
            newNode.addChild(rightNode);
            return newNode;
        }
        if (name.equals("minus")) {
            int numChildren = current.getNumChildren();
            if (numChildren > 2 || numChildren < 1) {
                throw new Exception("Minus expects 1 or 2 children and has " + numChildren + ".");
            }
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            newNode.addChild(this.genSimpleTree(current.getChild(0)));
            if (numChildren == 2) {
                newNode.addChild(this.genSimpleTree(current.getChild(1)));
            }
            return newNode;
        }
        if (name.equals("log")) {
            int numChildren = current.getNumChildren();
            if (numChildren > 2 || numChildren < 1) {
                throw new Exception("Log expects 1 or 2 children and has " + numChildren + ".");
            }
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            if (numChildren == 2) {
                if (!current.getChild(0).getSimpleName().equalsIgnoreCase("logbase")) {
                    throw new Exception("Log expects first child to be logbase when there are 2 children.  First child is " + current.getChild(0).getSimpleName() + ".");
                }
                newNode.addChild(this.genSimpleTree(current.getChild(0)));
                newNode.addChild(this.genSimpleTree(current.getChild(1)));
            } else {
                newNode.addChild(new Node("cn", "10"));
                newNode.addChild(this.genSimpleTree(current.getChild(0)));
            }
            return newNode;
        }
        if (name.equals("logbase") || name.equals("degree")) {
            if (current.getNumChildren() != 1) {
                throw new Exception("Logbase and degree expect exactly 1 child and have " + current.getNumChildren());
            }
            return this.genSimpleTree(current.getChild(0));
        }
        if (name.equals("bvar")) {
            if (!this.lambdaFunction) {
                throw new Exception("Bvar found in non-lambdaFunction.");
            }
            if (!this.lookForFunctionArgs) {
                throw new Exception("Bvar found out of place in a lambdaFunction.");
            }
            if (current.getNumChildren() != 1) {
                throw new Exception("Bvar expects exactly 1 child and has " + current.getNumChildren());
            }
            Node ciNode = current.getChild(0);
            if (!ciNode.getSimpleName().equalsIgnoreCase("ci")) {
                throw new Exception("Bvar expects its child to be ci and its child is " + ciNode.getSimpleName() + ".");
            }
            this.functionArgs.add(ciNode.getValue());
            return null;
        }
        if (name.equals("abs") || name.equals("exp") || name.equals("ln") || name.equals("floor") || name.equals("ceiling") || name.equals("factorial") || name.equals("not") || name.equals("sin") || name.equals("cos") || name.equals("tan") || name.equals("sec") || name.equals("csc") || name.equals("cot") || name.equals("sinh") || name.equals("cosh") || name.equals("tanh") || name.equals("sech") || name.equals("csch") || name.equals("coth") || name.equals("arcsin") || name.equals("arccos") || name.equals("arctan") || name.equals("arcsec") || name.equals("arccsc") || name.equals("arccot") || name.equals("arcsinh") || name.equals("arccosh") || name.equals("arctanh") || name.equals("arcsech") || name.equals("arccsch") || name.equals("arccoth")) {
            if (current.getNumChildren() != 1) {
                throw new Exception("The function " + name + " epects one argument and has " + current.getNumChildren() + ".");
            }
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            newNode.addChild(this.genSimpleTree(current.getChild(0)));
            return newNode;
        }
        if (name.equals("semantics") || name.equals("math")) {
            if (current.getNumChildren() != 1) {
                throw new Exception("The element " + name + " can only have one child with " + "this parser and has " + current.getNumChildren() + ".");
            }
            return this.genSimpleTree(current.getChild(0));
        }
        if (name.equals("treeroot") || name.equals("lambda")) {
            current = this.stripComments(current)[0];
            int numChildren = current.getNumChildren();
            int i = 0;
            this.lookForFunctionArgs = true;
            Node newNode = this.genSimpleTree(current.getChild(i));
            Node leftOverNode = null;
            while (newNode == null && i < numChildren - 1) {
                newNode = this.genSimpleTree(current.getChild(++i));
            }
            this.lookForFunctionArgs = false;
            while (leftOverNode == null && i < numChildren - 1) {
                leftOverNode = this.genSimpleTree(current.getChild(++i));
            }
            if (leftOverNode != null) {
                throw new Exception("TREEROOT has more than one expression.");
            }
            return newNode;
        }
        if (name.equals("function")) {
            int numChildren = current.getNumChildren();
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            for (int i = 0; i < numChildren; ++i) {
                newNode.addChild(this.genSimpleTree(current.getChild(i)));
            }
            return newNode;
        }
        throw new Exception("Unknown node with name " + name + ".");
    }

    private void parse(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        MathMLHandler handler = new MathMLHandler();
        parser.parse(is, (DefaultHandler)handler);
        this.mathMLParseTree = handler.root;
    }

    private NoVarTree removeVar(Node cur, String var) throws Exception {
        String type = cur.getSimpleName().toLowerCase();
        NoVarTree ret = new NoVarTree();
        ret.varWasHere = false;
        ret.treeWithoutVar = null;
        if (!type.matches("times|ci|cn")) {
            throw new Exception("Unsupported operation: " + type);
        }
        if (type.equals("ci")) {
            if (var.equals(cur.getValue())) {
                ret.varWasHere = true;
            } else {
                ret.treeWithoutVar = cur;
            }
        } else if (type.equals("cn")) {
            ret.treeWithoutVar = cur;
        } else if (type.equals("times")) {
            if (cur.getNumChildren() != 2) {
                throw new Exception("The times operator must have exactly 2 children, it has " + cur.getNumChildren());
            }
            NoVarTree left = this.removeVar(cur.getChild(0), var);
            NoVarTree right = this.removeVar(cur.getChild(1), var);
            if (left.treeWithoutVar == null) {
                right.varWasHere = true;
                return right;
            }
            if (right.treeWithoutVar == null) {
                left.varWasHere = true;
                return left;
            }
            ret.varWasHere = left.varWasHere || right.varWasHere;
            ret.treeWithoutVar = cur;
        }
        return ret;
    }

    private Equation solve_(Node cur, String var) throws Exception {
        String type = cur.getSimpleName().toLowerCase();
        Equation equation = new Equation();
        equation.right = null;
        equation.left = null;
        if (!type.matches("plus|minus|times|ci|cn")) {
            throw new Exception("Unsupported operation: " + type);
        }
        if (type.equals("plus")) {
            if (cur.getNumChildren() != 2) {
                throw new Exception("The plus operator must have exactly 2 children, it has " + cur.getNumChildren());
            }
            Equation child0 = this.solve_(cur.getChild(0), var);
            Equation child1 = this.solve_(cur.getChild(1), var);
            equation.left = child0.left;
            equation.right = child0.right;
            if (equation.left == null) {
                equation.left = child1.left;
            } else if (child1.left != null) {
                equation.left = new Node("plus", "");
                equation.left.addChild(child0.left);
                equation.left.addChild(child1.left);
            }
            if (equation.right == null) {
                equation.right = child1.right;
            } else if (child1.right != null) {
                equation.right = new Node("plus", "");
                equation.right.addChild(child0.right);
                equation.right.addChild(child1.right);
            }
        } else if (type.equals("minus")) {
            int numChildren = cur.getNumChildren();
            if (numChildren != 2 && numChildren != 1) {
                throw new Exception("The minus operator must have 1 or 2 children, it has " + numChildren);
            }
            if (numChildren == 1) {
                Equation child0 = this.solve_(cur.getChild(0), var);
                if (child0.left != null) {
                    equation.left = new Node("minus", "");
                    equation.left.addChild(child0.left);
                }
                if (child0.right != null) {
                    equation.right = new Node("minus", "");
                    equation.right.addChild(child0.right);
                }
            } else {
                Equation child0 = this.solve_(cur.getChild(0), var);
                Equation child1 = this.solve_(cur.getChild(1), var);
                if (child1.left != null) {
                    equation.left = new Node("minus", "");
                    if (child0.left != null) {
                        equation.left.addChild(child0.left);
                    }
                    equation.left.addChild(child1.left);
                } else {
                    equation.left = child0.left;
                }
                if (child1.right != null) {
                    equation.right = new Node("minus", "");
                    if (child0.right != null) {
                        equation.right.addChild(child0.right);
                    }
                    equation.right.addChild(child1.right);
                } else {
                    equation.right = child0.right;
                }
            }
        } else if (type.equals("times")) {
            NoVarTree noVarTree = this.removeVar(cur, var);
            if (noVarTree.treeWithoutVar == null) {
                equation.right = new Node("cn", "1");
            } else if (noVarTree.varWasHere) {
                equation.right = noVarTree.treeWithoutVar;
            } else {
                equation.left = noVarTree.treeWithoutVar;
            }
        } else if (type.equals("ci")) {
            if (cur.getValue().equals(var)) {
                equation.right = new Node("cn", "1");
            } else {
                equation.left = cur;
            }
        } else if (type.equals("cn")) {
            equation.left = cur;
        }
        return equation;
    }

    private Node[] stripComments(Node current) throws Exception {
        String name = current.getSimpleName().toLowerCase();
        if (name.equals("annotation")) {
            return null;
        }
        if (name.equals("annotation-xml")) {
            if (!current.getAttributes().getValue("encoding").equalsIgnoreCase("MathML-Content")) {
                return null;
            }
            ArrayList<Node> newNodes = new ArrayList<Node>();
            int numChildren = current.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node[] tempNodes = this.stripComments(current.getChild(i));
                for (int j = 0; j < tempNodes.length; ++j) {
                    if (tempNodes[j] == null) continue;
                    newNodes.add(tempNodes[j]);
                }
            }
            if (newNodes.size() == 0) {
                return null;
            }
            return newNodes.toArray(new Node[0]);
        }
        if (name.equals("treeroot")) {
            Node newNode = new Node(current);
            newNode.removeAllChildren();
            int numChildren = current.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node[] tempNodes = this.stripComments(current.getChild(i));
                for (int j = 0; j < tempNodes.length; ++j) {
                    if (tempNodes[j] == null) continue;
                    newNode.addChild(tempNodes[j]);
                }
            }
            if (newNode.getNumChildren() == 0) {
                return null;
            }
            Node[] retNode = new Node[]{newNode};
            return retNode;
        }
        if (name.matches("semantics|math")) {
            ArrayList<Node> newNodes = new ArrayList<Node>();
            int numChildren = current.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node[] tempNodes = this.stripComments(current.getChild(i));
                for (int j = 0; j < tempNodes.length; ++j) {
                    if (tempNodes[j] == null) continue;
                    newNodes.add(tempNodes[j]);
                }
            }
            if (newNodes.size() == 0) {
                return null;
            }
            return newNodes.toArray(new Node[0]);
        }
        Node newNode = new Node(current);
        newNode.removeAllChildren();
        int numChildren = current.getNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            Node[] tempNodes = this.stripComments(current.getChild(i));
            for (int j = 0; j < tempNodes.length; ++j) {
                if (tempNodes[j] == null) continue;
                newNode.addChild(tempNodes[j]);
            }
        }
        Node[] retNode = new Node[]{newNode};
        return retNode;
    }

    public void searchAndRecordIds(Set setOfUsedIds) {
        HashSet<String> bvarSet = new HashSet<String>();
        this.simpleTree = null;
        Node node = this.mathMLParseTree.getChild(0);
        while (node != null) {
            String nodeType = node.getQName();
            if (nodeType.endsWith("lambda")) {
                int numberOfBvars = node.getNumChildren() - 1;
                for (int i = 0; i < numberOfBvars; ++i) {
                    Node bvarNode = node.getChild(i);
                    if (!bvarNode.getQName().endsWith("bvar")) continue;
                    bvarSet.add(bvarNode.getChild(0).getValue());
                }
            }
            if (nodeType != null && nodeType.endsWith("ci") && !bvarSet.contains(node.getValue())) {
                setOfUsedIds.add(node.getValue());
            }
            if (node.getNumChildren() > 0) {
                node = node.getChild(0);
                continue;
            }
            Node parent = node.getParent();
            List children = parent.getListOfChildren();
            int siblingIndex = children.indexOf(node) + 1;
            while (siblingIndex == children.size() && node != this.mathMLParseTree) {
                parent = (node = node.getParent()).getParent();
                if (parent == this.mathMLParseTree) {
                    return;
                }
                children = parent.getListOfChildren();
                siblingIndex = children.indexOf(node) + 1;
            }
            node = parent.getChild(siblingIndex);
        }
        bvarSet.clear();
    }

    public void searchAndReplaceIds(Map oldToNewIds) {
        HashSet<String> bvarSet = new HashSet<String>();
        this.simpleTree = null;
        Node node = this.mathMLParseTree.getChild(0);
        while (node != null) {
            String nodeId;
            String nodeType = node.getQName();
            if (nodeType.endsWith("lambda")) {
                int numberOfBvars = node.getNumChildren() - 1;
                for (int i = 0; i < numberOfBvars; ++i) {
                    Node bvarNode = node.getChild(i);
                    if (!bvarNode.getQName().endsWith("bvar")) continue;
                    bvarSet.add(bvarNode.getChild(0).getValue());
                }
            }
            if (nodeType != null && nodeType.endsWith("ci") && (nodeId = (String)oldToNewIds.get(node.getValue())) != null && !bvarSet.contains(node.getValue())) {
                node.setValue(nodeId);
            }
            if (node.getNumChildren() > 0) {
                node = node.getChild(0);
                continue;
            }
            Node parent = node.getParent();
            List children = parent.getListOfChildren();
            int siblingIndex = children.indexOf(node) + 1;
            while (siblingIndex == children.size() && node != this.mathMLParseTree) {
                parent = (node = node.getParent()).getParent();
                if (parent == this.mathMLParseTree) {
                    return;
                }
                children = parent.getListOfChildren();
                siblingIndex = children.indexOf(node) + 1;
            }
            node = parent.getChild(siblingIndex);
        }
        bvarSet.clear();
    }

    public String toString() {
        this.mathML = new StringBuffer();
        try {
            this.generateMathML(this.mathMLParseTree.getChild(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mathML.delete(this.mathML.length() - 1, this.mathML.length());
        return this.mathML.toString();
    }

    private void generateMathML(Node cur) throws Exception {
        String nodeType = cur.getQName();
        if (nodeType == null) {
            throw new Exception("Node type was null");
        }
        String nodeValue = cur.getValue().trim();
        if (nodeValue == null) {
            nodeValue = "";
        }
        if (!cur.getParent().getQName().endsWith("bvar")) {
            this.mathML.append(tabs);
        }
        this.mathML.append("<" + nodeType);
        if (cur.getNumChildren() == 0 && nodeValue.equals("")) {
            this.mathML.append("/>\n");
            return;
        }
        if (cur.getNumChildren() == 0) {
            this.mathML.append(">" + nodeValue + "</" + nodeType + ">\n");
            return;
        }
        this.mathML.append(">" + nodeValue);
        if (!nodeType.endsWith("bvar")) {
            this.mathML.append("\n");
        }
        tabs.append("    ");
        for (int i = 0; i < cur.getNumChildren(); ++i) {
            this.generateMathML(cur.getChild(i));
        }
        tabs.delete(tabs.length() - 4, tabs.length());
        if (nodeType.endsWith("bvar")) {
            this.mathML.delete(this.mathML.length() - 1, this.mathML.length());
            this.mathML.append("</" + cur.getQName() + ">\n");
        } else {
            this.mathML.append(tabs + "</" + cur.getQName() + ">\n");
        }
    }

    protected class NoVarTree {
        boolean varWasHere;
        Node treeWithoutVar;

        protected NoVarTree() {
        }
    }

    protected class MathMLHandler
    extends DefaultHandler {
        protected Node root;
        private Node current;

        protected MathMLHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            this.current.appendToValue(new String(ch, start, length));
        }

        public void endDocument() {
        }

        public void endElement(String uri, String localName, String qName) {
            this.current.setValue(this.current.getValue().trim().replaceAll("[ \t\n\r]+", " "));
            this.current = this.current.getParent();
        }

        public void startDocument() {
            this.current = this.root = new Node("", "", "TREEROOT", null);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Node newNode = new Node(this.current, uri, localName, qName, new AttributesImpl(attributes));
            this.current.addChild(newNode);
            this.current = newNode;
        }
    }

    protected class Equation {
        Node left;
        Node right;

        protected Equation() {
        }
    }
}

