/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;

public class Node {
    protected List children;
    protected Attributes attributes;
    protected Node parent;
    protected String localName;
    protected String qName;
    protected String uri;
    protected StringBuffer value;

    public Node(Node oldNode) {
        this.attributes = oldNode.attributes;
        this.children = new ArrayList(oldNode.children);
        this.localName = oldNode.localName;
        this.parent = oldNode.parent;
        this.qName = oldNode.qName;
        this.uri = oldNode.uri;
        this.value = new StringBuffer(oldNode.value.toString());
    }

    public Node(Node oldNode, String value, Node[] children) {
        this(oldNode);
        this.children = Arrays.asList(children);
        this.value = new StringBuffer(value);
    }

    public Node(Node parent, String uri, String localName, String qName, Attributes attributes) {
        this.parent = parent;
        this.attributes = attributes;
        this.localName = localName;
        this.qName = qName;
        this.uri = uri;
        this.value = new StringBuffer();
        this.children = new ArrayList();
    }

    public Node(String uri, String localName, String qName, Attributes attributes) {
        this(null, uri, localName, qName, attributes);
    }

    public Node(String qName, String value, Node[] children) {
        this(null, null, null, qName, null);
        this.value = new StringBuffer(value);
        for (int i = 0; i < children.length; ++i) {
            this.addChild(children[i]);
        }
    }

    public Node(String qName, String value, Node child1, Node child2) {
        this(null, null, null, qName, null);
        this.value = new StringBuffer(value);
        this.addChild(child1);
        this.addChild(child2);
    }

    public Node(String qName, String value, Node child) {
        this(null, null, null, qName, null);
        this.value = new StringBuffer(value);
        this.addChild(child);
    }

    public Node(String qName, String value) {
        this(null, null, null, qName, null);
        this.value = new StringBuffer(value);
    }

    public Node() {
        this(null, "", "", "", null);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Node getChild(int index) {
        return (Node)this.children.get(index);
    }

    public Node[] getChildren() {
        return this.children.toArray(new Node[0]);
    }

    public List getListOfChildren() {
        return this.children;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public Node getParent() {
        return this.parent;
    }

    public String getQName() {
        return this.qName;
    }

    public String getSimpleName() {
        if (this.qName.startsWith("math:")) {
            return this.qName.substring(5);
        }
        return this.qName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getValue() {
        return this.value.toString();
    }

    protected void addChild(Node child) {
        child.setParent(this);
        this.children.add(child);
    }

    protected void appendToValue(String s) {
        this.value.append(s);
    }

    protected void removeAllChildren() {
        this.children = new ArrayList();
    }

    protected Node removeChild(int index) {
        return (Node)this.children.remove(index);
    }

    protected void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    protected void setLocalName(String localName) {
        this.localName = localName;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    protected void setQName(String qName) {
        this.qName = qName;
    }

    protected void setUri(String uri) {
        this.uri = uri;
    }

    protected void setValue(String value) {
        this.value = new StringBuffer(value);
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        String thisNodeS = indent + this.qName + ": " + this.value + "\n";
        indent = indent + "  ";
        String childrenS = "";
        for (int i = 0; i < this.children.size(); ++i) {
            childrenS = childrenS + ((Node)this.children.get(i)).toString(indent);
        }
        return thisNodeS + childrenS;
    }
}

