/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import jigcell.sbml2.Reaction;
import jigcell.sbml2.tests.SBMLModelTests;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AlgebraicModelTests
extends SBMLModelTests {
    public static void main(String[] args) {
        TestRunner.run((Test)AlgebraicModelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(AlgebraicModelTests.class);
    }

    public AlgebraicModelTests(String name) {
        super(name);
        this.modelName = "l2v1-algebraic.sbml";
    }

    public void testCompartment0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getCompartments().size() == 1 ? 1 : 0) != 0);
    }

    public void testCompartment1() throws Exception {
        this.testCompartment("cell", true, null, Double.NaN, 3, "volume");
    }

    public void testEvent0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public void testFunction0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getFunctionDefinitions().size() == 0 ? 1 : 0) != 0);
    }

    public void testModel1() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getId() == null ? 1 : 0) != 0);
    }

    public void testParameter0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getParameters().size() == 1 ? 1 : 0) != 0);
    }

    public void testParameter1() throws Exception {
        this.testParameter("Keq", 2.5);
    }

    public void testReaction0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getReactions().size() == 2 ? 1 : 0) != 0);
    }

    public void testReaction1() throws Exception {
        Reaction reaction = this.testReaction("in", null, true);
        AlgebraicModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "X0", 1.0);
        AlgebraicModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "T", 1.0);
        AlgebraicModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 1 ? 1 : 0) != 0);
        this.testParameter(reaction, "k1", 0.1);
    }

    public void testReaction2() throws Exception {
        Reaction reaction = this.testReaction("out", null, true);
        AlgebraicModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "T", 1.0);
        AlgebraicModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "X1", 1.0);
        AlgebraicModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 1 ? 1 : 0) != 0);
        this.testParameter(reaction, "k2", 0.15);
    }

    public void testRule0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getRules().size() == 2 ? 1 : 0) != 0);
    }

    public void testSpecies0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getSpecies().size() == 5 ? 1 : 0) != 0);
    }

    public void testSpecies1() throws Exception {
        this.testSpecies("X0", "cell", 1.0, false, false);
    }

    public void testSpecies2() throws Exception {
        this.testSpecies("X1", "cell", 0.0, false, false);
    }

    public void testSpecies3() throws Exception {
        this.testSpecies("T", "cell", 0.0, false, false);
    }

    public void testSpecies4() throws Exception {
        this.testSpecies("S1", "cell", 0.0, false, false);
    }

    public void testSpecies5() throws Exception {
        this.testSpecies("S2", "cell", 0.0, false, false);
    }

    public void testUnit0() throws Exception {
        AlgebraicModelTests.assertTrue((this.model.getUnitDefinitions().size() == 0 ? 1 : 0) != 0);
    }
}

