/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import jigcell.sbml2.Reaction;
import jigcell.sbml2.tests.SBMLModelTests;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ODEModelTests
extends SBMLModelTests {
    public static void main(String[] args) {
        TestRunner.run((Test)ODEModelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(ODEModelTests.class);
    }

    public ODEModelTests(String name) {
        super(name);
        this.modelName = "l2v1-mc-ode.sbml";
    }

    public void testCompartment0() throws Exception {
        ODEModelTests.assertTrue((this.model.getCompartments().size() == 2 ? 1 : 0) != 0);
    }

    public void testCompartment1() throws Exception {
        this.testCompartment("V0", true, null, 10.0, 3, "volume");
    }

    public void testCompartment2() throws Exception {
        this.testCompartment("V1", false, null, 1.0, 3, "volume");
    }

    public void testEvent0() throws Exception {
        ODEModelTests.assertTrue((this.model.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public void testModel1() throws Exception {
        ODEModelTests.assertTrue((boolean)this.model.getId().equals("ODEExampleModel"));
    }

    public void testParameter0() throws Exception {
        ODEModelTests.assertTrue((this.model.getParameters().size() == 6 ? 1 : 0) != 0);
    }

    public void testParameter1() throws Exception {
        this.testParameter("K0", 0.1);
    }

    public void testParameter2() throws Exception {
        this.testParameter("K1", 0.5);
    }

    public void testParameter3() throws Exception {
        this.testParameter("K2", 0.1);
    }

    public void testParameter4() throws Exception {
        this.testParameter("K3", 0.5);
    }

    public void testParameter5() throws Exception {
        this.testParameter("Kv", 0.5);
    }

    public void testParameter6() throws Exception {
        this.testParameter("Kin", 0.1);
    }

    public void testReaction0() throws Exception {
        ODEModelTests.assertTrue((this.model.getReactions().size() == 4 ? 1 : 0) != 0);
    }

    public void testReaction1() throws Exception {
        Reaction reaction = this.testReaction("reaction_1", null, false);
        ODEModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "X0", 1.0);
        ODEModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "S1", 1.0);
        ODEModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction2() throws Exception {
        Reaction reaction = this.testReaction("reaction_2", null, false);
        ODEModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "S1", 1.0);
        ODEModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "S2", 1.0);
        ODEModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction3() throws Exception {
        Reaction reaction = this.testReaction("reaction_3", null, false);
        ODEModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "S2", 1.0);
        ODEModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "S3", 1.0);
        ODEModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction4() throws Exception {
        Reaction reaction = this.testReaction("reaction_4", null, false);
        ODEModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "S3", 1.0);
        ODEModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "X4", 1.0);
        ODEModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testRule0() throws Exception {
        ODEModelTests.assertTrue((this.model.getRules().size() == 2 ? 1 : 0) != 0);
    }

    public void testSpecies0() throws Exception {
        ODEModelTests.assertTrue((this.model.getSpecies().size() == 5 ? 1 : 0) != 0);
    }

    public void testSpecies1() throws Exception {
        this.testSpecies("X0", "V0", 0.0, false, true);
    }

    public void testSpecies2() throws Exception {
        this.testSpecies("S1", "V0", 0.0, false, false);
    }

    public void testSpecies3() throws Exception {
        this.testSpecies("S2", "V0", 0.0, false, false);
    }

    public void testSpecies4() throws Exception {
        this.testSpecies("S3", "V1", 0.0, false, false);
    }

    public void testSpecies5() throws Exception {
        this.testSpecies("X4", "V1", 0.0, true, true);
    }

    public void testUnit0() throws Exception {
        ODEModelTests.assertTrue((this.model.getUnitDefinitions().size() == 0 ? 1 : 0) != 0);
    }
}

