/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import java.util.List;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.Unit;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.tests.SBMLModelTests;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UnitModelTests
extends SBMLModelTests {
    public static void main(String[] args) {
        TestRunner.run((Test)UnitModelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(UnitModelTests.class);
    }

    public UnitModelTests(String name) {
        super(name);
        this.modelName = "l2v1-units.sbml";
    }

    public void testCompartment0() throws Exception {
        UnitModelTests.assertTrue((this.model.getCompartments().size() == 1 ? 1 : 0) != 0);
    }

    public void testCompartment1() throws Exception {
        this.testCompartment("cell", true, null, Double.NaN, 3, "volume");
    }

    public void testEvent0() throws Exception {
        UnitModelTests.assertTrue((this.model.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public void testModel1() throws Exception {
        UnitModelTests.assertTrue((this.model.getId() == null ? 1 : 0) != 0);
    }

    public void testParameter0() throws Exception {
        UnitModelTests.assertTrue((this.model.getParameters().size() == 2 ? 1 : 0) != 0);
    }

    public void testParameter1() throws Exception {
        this.testParameter("vm", 2.0, "mmls", true);
    }

    public void testParameter2() throws Exception {
        this.testParameter("km", 2.0, "mm", true);
    }

    public void testReaction0() throws Exception {
        UnitModelTests.assertTrue((this.model.getReactions().size() == 3 ? 1 : 0) != 0);
    }

    public void testReaction1() throws Exception {
        Reaction reaction = this.testReaction("v1", null, true);
        UnitModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "x0", 1.0);
        UnitModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "s1", 1.0);
        UnitModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction2() throws Exception {
        Reaction reaction = this.testReaction("v2", null, true);
        UnitModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "s1", 1.0);
        UnitModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "s2", 1.0);
        UnitModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction3() throws Exception {
        Reaction reaction = this.testReaction("v3", null, true);
        UnitModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "s2", 1.0);
        UnitModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "x1", 1.0);
        UnitModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 0 ? 1 : 0) != 0);
    }

    public void testRule0() throws Exception {
        UnitModelTests.assertTrue((this.model.getRules().size() == 0 ? 1 : 0) != 0);
    }

    public void testSpecies0() throws Exception {
        UnitModelTests.assertTrue((this.model.getSpecies().size() == 4 ? 1 : 0) != 0);
    }

    public void testSpecies1() throws Exception {
        this.testSpecies("x0", "cell", 1.0, false, false);
    }

    public void testSpecies2() throws Exception {
        this.testSpecies("x1", "cell", 1.0, false, false);
    }

    public void testSpecies3() throws Exception {
        this.testSpecies("s1", "cell", 1.0, false, false);
    }

    public void testSpecies4() throws Exception {
        this.testSpecies("s2", "cell", 1.0, false, false);
    }

    public void testUnit0() throws Exception {
        UnitModelTests.assertTrue((this.model.getUnitDefinitions().size() == 3 ? 1 : 0) != 0);
    }

    public void testUnit1() throws Exception {
        UnitDefinition definition = this.testUnitDefinition("substance", 1);
        List units = definition.getUnits();
        this.testUnit((Unit)units.get(0), 1, "mole", 1.0, 0.0, -3);
    }

    public void testUnit2() throws Exception {
        UnitDefinition definition = this.testUnitDefinition("mmls", 3);
        List units = definition.getUnits();
        this.testUnit((Unit)units.get(0), 1, "mole", 1.0, 0.0, -3);
        this.testUnit((Unit)units.get(1), -1, "litre", 1.0, 0.0, 0);
        this.testUnit((Unit)units.get(2), -1, "second", 1.0, 0.0, 0);
    }

    public void testUnit3() throws Exception {
        UnitDefinition definition = this.testUnitDefinition("mm", 1);
        List units = definition.getUnits();
        this.testUnit((Unit)units.get(0), 1, "mole", 1.0, 0.0, -3);
    }
}

