/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.libsbml;

import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.libsbml;
import org.sbml.libsbml.libsbmlJNI;

public class SBMLReader {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected SBMLReader(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(SBMLReader sBMLReader) {
        return sBMLReader == null ? 0L : sBMLReader.swigCPtr;
    }

    protected static long getCPtrAndDisown(SBMLReader sBMLReader) {
        long l = 0L;
        if (sBMLReader != null) {
            l = sBMLReader.swigCPtr;
            sBMLReader.swigCMemOwn = false;
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                libsbmlJNI.delete_SBMLReader(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return this.swigCPtr == SBMLReader.getCPtr((SBMLReader)object);
    }

    public int hashCode() {
        return (int)(this.swigCPtr ^ this.swigCPtr >>> 32);
    }

    public SBMLReader() {
        this(libsbmlJNI.new_SBMLReader(), true);
    }

    public SBMLDocument readSBML(String string) {
        long l = libsbmlJNI.SBMLReader_readSBML(this.swigCPtr, this, libsbml.getAbsolutePath(string));
        return l == 0L ? null : new SBMLDocument(l, true);
    }

    public SBMLDocument readSBMLFromFile(String string) {
        long l = libsbmlJNI.SBMLReader_readSBMLFromFile(this.swigCPtr, this, libsbml.getAbsolutePath(string));
        return l == 0L ? null : new SBMLDocument(l, true);
    }

    public SBMLDocument readSBMLFromString(String string) {
        long l = libsbmlJNI.SBMLReader_readSBMLFromString(this.swigCPtr, this, string);
        return l == 0L ? null : new SBMLDocument(l, true);
    }

    public static boolean hasZlib() {
        return libsbmlJNI.SBMLReader_hasZlib();
    }

    public static boolean hasBzip2() {
        return libsbmlJNI.SBMLReader_hasBzip2();
    }
}

