/*
 * Decompiled with CFR 0.152.
 */
import JSim.gui.plugin.GModelEasel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class MyEasel
extends GModelEasel {
    private int ncomp = 2;
    private JPanel panel = new JPanel();
    private JPanel figure;
    static MyEasel easel;

    public MyEasel(GModelEasel.Callbacks cb) throws Exception {
        super(cb);
        MyAction a_more = new MyAction("MORE", 1);
        JButton b_more = new JButton(a_more);
        this.panel.add(b_more);
        MyAction a_less = new MyAction("FEWER", -1);
        JButton b_less = new JButton(a_less);
        this.panel.add(b_less);
        MyAction a_comp = new MyAction("Compile!", 0);
        JButton b_comp = new JButton(a_comp);
        this.panel.add(b_comp);
        this.figure = new JPanel(null){

            public void paint(Graphics g) {
                int w = this.getSize().width;
                int h = this.getSize().height;
                g.setColor(Color.white);
                g.fillRect(0, 0, w, h);
                int b = 10;
                int l = w / 2 - b * (MyEasel.this.ncomp - 1) - b / 2;
                g.setColor(Color.black);
                for (int x = 0; x < MyEasel.this.ncomp; ++x) {
                    g.fillRect(l + x * b * 2, h / 2, b, b);
                }
                g.drawLine(l, h / 2 + b / 2, l + (MyEasel.this.ncomp - 1) * b * 2, h / 2 + b / 2);
            }
        };
        this.figure.setPreferredSize(new Dimension(180, 50));
        this.panel.add(this.figure);
    }

    public JComponent getJComponent() {
        return this.panel;
    }

    public String getMML() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("// MML text automatically generated by MyEasel plugin\n");
        buf.append("math main {\n");
        buf.append("  realDomain t; t.min=0; t.max=10; t.delta=0.1;\n");
        for (i = 0; i < this.ncomp; ++i) {
            buf.append("  real v" + i + "(t); when (t=t.min) v" + i + "=" + i + ";\n");
        }
        for (i = 0; i < this.ncomp; ++i) {
            buf.append("  v" + i + ":t=0");
            if (i > 0) {
                buf.append("+(v" + (i - 1) + "-v" + i + ")");
            }
            if (i < this.ncomp - 1) {
                buf.append("+(v" + (i + 1) + "-v" + i + ")");
            }
            buf.append(";\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("MyEasel");
        JRootPane root = frame.getRootPane();
        root.setPreferredSize(new Dimension(200, 150));
        MyCallbacks cb = new MyCallbacks();
        easel = new MyEasel(cb);
        root.setContentPane(easel.getJComponent());
        frame.pack();
        frame.setVisible(true);
    }

    public static class MyCallbacks
    implements GModelEasel.Callbacks {
        public void easelCompile() {
            String text = easel.getMML();
            System.out.println("Compiling...\n" + text);
            System.exit(0);
        }

        public void easelStateChanged(int flags) {
        }
    }

    public class MyAction
    extends AbstractAction {
        private int which;

        public MyAction(String n, int w) {
            super(n);
            this.which = w;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.which == 0) {
                if (MyEasel.this.callbacks != null) {
                    MyEasel.this.callbacks.easelCompile();
                }
                return;
            }
            MyEasel.this.ncomp += this.which;
            if (MyEasel.this.ncomp < 1) {
                MyEasel.this.ncomp = 1;
            }
            if (MyEasel.this.ncomp > 9) {
                MyEasel.this.ncomp = 9;
            }
            MyEasel.this.figure.repaint();
            if (MyEasel.this.callbacks != null) {
                MyEasel.this.callbacks.easelStateChanged(3);
            }
        }
    }
}

