/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;

public class ClassLoader
extends java.lang.ClassLoader {
    private Hashtable classes = new Hashtable();
    private String[] ignored_packages = new String[]{"java.", "javax.", "sun."};

    public ClassLoader() {
    }

    public ClassLoader(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + this.ignored_packages.length];
        System.arraycopy(this.ignored_packages, 0, stringArray2, 0, this.ignored_packages.length);
        System.arraycopy(stringArray, 0, stringArray2, this.ignored_packages.length, stringArray.length);
        this.ignored_packages = stringArray2;
    }

    protected Class loadClass(String string, boolean bl2) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = (Class<?>)this.classes.get(string);
        if (clazz == null) {
            for (int i2 = 0; i2 < this.ignored_packages.length; ++i2) {
                if (!string.startsWith(this.ignored_packages[i2])) continue;
                clazz = Class.forName(string);
                break;
            }
            if (clazz == null) {
                JavaClass javaClass = null;
                javaClass = string.indexOf("$$BCEL$$") >= 0 ? this.createClass(string) : this.modifyClass(Repository.lookupClass(string));
                if (javaClass != null) {
                    byte[] byArray = javaClass.getBytes();
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                } else {
                    clazz = Class.forName(string);
                }
            }
            if (bl2) {
                this.resolveClass(clazz);
            }
        }
        this.classes.put(string, clazz);
        return clazz;
    }

    protected JavaClass modifyClass(JavaClass javaClass) {
        return javaClass;
    }

    protected JavaClass createClass(String string) {
        Object object;
        Object object2;
        int n2 = string.indexOf("$$BCEL$$");
        String string2 = string.substring(n2 + 8);
        JavaClass javaClass = null;
        try {
            object2 = Utility.decode(string2, true);
            object = new ClassParser(new ByteArrayInputStream((byte[])object2), "foo");
            javaClass = ((ClassParser)object).parse();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        object2 = javaClass.getConstantPool();
        object = (ConstantClass)((ConstantPool)object2).getConstant(javaClass.getClassNameIndex(), (byte)7);
        ConstantUtf8 constantUtf8 = (ConstantUtf8)((ConstantPool)object2).getConstant(((ConstantClass)object).getNameIndex(), (byte)1);
        constantUtf8.setBytes(string.replace('.', '/'));
        return javaClass;
    }
}

