/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMStateSet;
import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaException;
import com.sun.org.apache.xerces.internal.impl.xs.XSConstraints;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSWildcardDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMBinOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMUniOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.xni.QName;
import java.util.Hashtable;
import java.util.Vector;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int[] fElemMapId = null;
    private int fElemMapSize = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private static long time = 0L;

    public XSDFACM(CMNode cMNode, int n2) {
        this.fLeafCount = n2;
        this.buildDFA(cMNode);
    }

    public boolean isFinalState(int n2) {
        return n2 < 0 ? false : this.fFinalStateFlags[n2];
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        int n2;
        int n3 = nArray[0];
        if (n3 == -1 || n3 == -2) {
            if (n3 == -1) {
                nArray[0] = -2;
            }
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        int n4 = 0;
        Object object = null;
        for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
            n4 = this.fTransTable[n3][n2];
            if (n4 == -1) continue;
            int n5 = this.fElemMapType[n2];
            if (n5 == 1) {
                object = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n2]);
                if (object == null) continue;
                break;
            }
            if (n5 != 2 || !((XSWildcardDecl)this.fElemMap[n2]).allowNamespace(qName.uri)) continue;
            object = this.fElemMap[n2];
            break;
        }
        if (n2 == this.fElemMapSize) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = n4;
        return object;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            int n2 = this.fElemMapType[i2];
            if (n2 == 1) {
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[i2]);
                if (xSElementDecl == null) continue;
                return xSElementDecl;
            }
            if (n2 != 2 || !((XSWildcardDecl)this.fElemMap[i2]).allowNamespace(qName.uri)) continue;
            return this.fElemMap[i2];
        }
        return null;
    }

    public int[] startContentModel() {
        int[] nArray = new int[2];
        nArray[0] = 0;
        return nArray;
    }

    public boolean endContentModel(int[] nArray) {
        return this.fFinalStateFlags[nArray[0]];
    }

    private void buildDFA(CMNode cMNode) {
        int n2;
        int n3;
        int n4;
        int n5 = this.fLeafCount;
        XSCMLeaf xSCMLeaf = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, cMNode, xSCMLeaf);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (n4 = 0; n4 < this.fLeafCount; ++n4) {
            this.fFollowList[n4] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapId = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        for (n4 = 0; n4 < this.fLeafCount; ++n4) {
            this.fElemMap[n4] = null;
            n3 = this.fLeafList[n4].getParticleId();
            for (n2 = 0; n2 < this.fElemMapSize && n3 != this.fElemMapId[n2]; ++n2) {
            }
            if (n2 != this.fElemMapSize) continue;
            this.fElemMap[this.fElemMapSize] = this.fLeafList[n4].getLeaf();
            this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n4];
            this.fElemMapId[this.fElemMapSize] = n3;
            ++this.fElemMapSize;
        }
        --this.fElemMapSize;
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        n2 = 0;
        for (n3 = 0; n3 < this.fElemMapSize; ++n3) {
            int n6 = this.fElemMapId[n3];
            for (int i2 = 0; i2 < this.fLeafCount; ++i2) {
                if (n6 != this.fLeafList[i2].getParticleId()) continue;
                nArray[n2++] = i2;
            }
            nArray[n2++] = -1;
        }
        n3 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n3];
        this.fFinalStateFlags = new boolean[n3];
        this.fTransTable = new int[n3][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n7 = 0;
        int n8 = 0;
        this.fTransTable[n8] = this.makeDefStateList();
        cMStateSetArray[n8] = cMStateSet;
        ++n8;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n7 < n8) {
            cMStateSet = cMStateSetArray[n7];
            int[] nArray2 = this.fTransTable[n7];
            this.fFinalStateFlags[n7] = cMStateSet.getBit(n5);
            ++n7;
            CMStateSet cMStateSet2 = null;
            int n9 = 0;
            for (int i3 = 0; i3 < this.fElemMapSize; ++i3) {
                int n10;
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n11 = nArray[n9++];
                while (n11 != -1) {
                    if (cMStateSet.getBit(n11)) {
                        cMStateSet2.union(this.fFollowList[n11]);
                    }
                    n11 = nArray[n9++];
                }
                if (cMStateSet2.isEmpty()) continue;
                Integer n12 = (Integer)hashtable.get(cMStateSet2);
                int n13 = n10 = n12 == null ? n8 : n12;
                if (n10 == n8) {
                    cMStateSetArray[n8] = cMStateSet2;
                    this.fTransTable[n8] = this.makeDefStateList();
                    hashtable.put(cMStateSet2, new Integer(n8));
                    ++n8;
                    cMStateSet2 = null;
                }
                nArray2[i3] = n10;
                if (n8 != n3) continue;
                int n14 = (int)((double)n3 * 1.5);
                CMStateSet[] cMStateSetArray2 = new CMStateSet[n14];
                boolean[] blArray = new boolean[n14];
                int[][] nArrayArray = new int[n14][];
                for (int i4 = 0; i4 < n3; ++i4) {
                    cMStateSetArray2[i4] = cMStateSetArray[i4];
                    blArray[i4] = this.fFinalStateFlags[i4];
                    nArrayArray[i4] = this.fTransTable[i4];
                }
                n3 = n14;
                cMStateSetArray = cMStateSetArray2;
                this.fFinalStateFlags = blArray;
                this.fTransTable = nArrayArray;
            }
        }
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        this.fElemMapId = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 101) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 102) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((XSCMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((XSCMBinOp)cMNode).getRight().firstPos();
            for (int i2 = 0; i2 < this.fLeafCount; ++i2) {
                if (!cMStateSet.getBit(i2)) continue;
                this.fFollowList[i2].union(cMStateSet2);
            }
        } else if (cMNode.type() == 4 || cMNode.type() == 6) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            for (int i3 = 0; i3 < this.fLeafCount; ++i3) {
                if (!cMStateSet3.getBit(i3)) continue;
                this.fFollowList[i3].union(cMStateSet);
            }
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("   ");
        }
        n3 = cMNode.type();
        switch (n3) {
            case 101: 
            case 102: {
                if (n3 == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMBinOp)cMNode).getLeft(), n2 + 1);
                this.dumpTree(((XSCMBinOp)cMNode).getRight(), n2 + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMUniOp)cMNode).getChild(), n2 + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)cMNode).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)cMNode).getLeaf() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            nArray[i2] = -1;
        }
        return nArray;
    }

    private void postTreeBuildInit(CMNode cMNode) throws RuntimeException {
        cMNode.setMaxStates(this.fLeafCount);
        XSCMLeaf xSCMLeaf = null;
        int n2 = 0;
        if (cMNode.type() == 2) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n2 = xSCMLeaf.getPosition();
            this.fLeafList[n2] = xSCMLeaf;
            this.fLeafListType[n2] = 2;
        } else if (cMNode.type() == 101 || cMNode.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 4 || cMNode.type() == 6 || cMNode.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)cMNode).getChild());
        } else if (cMNode.type() == 1) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n2 = xSCMLeaf.getPosition();
            this.fLeafList[n2] = xSCMLeaf;
            this.fLeafListType[n2] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n2;
        int n3;
        byte[][] byArray = new byte[this.fElemMapSize][this.fElemMapSize];
        for (n3 = 0; n3 < this.fTransTable.length && this.fTransTable[n3] != null; ++n3) {
            for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
                for (int i2 = n2 + 1; i2 < this.fElemMapSize; ++i2) {
                    if (this.fTransTable[n3][n2] == -1 || this.fTransTable[n3][i2] == -1 || byArray[n2][i2] != 0) continue;
                    byArray[n2][i2] = XSConstraints.overlapUPA(this.fElemMap[n2], this.fElemMap[i2], substitutionGroupHandler) ? 1 : -1;
                }
            }
        }
        for (n3 = 0; n3 < this.fElemMapSize; ++n3) {
            for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
                if (byArray[n3][n2] != 1) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[n3].toString(), this.fElemMap[n2].toString()});
            }
        }
        for (n3 = 0; n3 < this.fElemMapSize; ++n3) {
            if (this.fElemMapType[n3] != 2) continue;
            XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)this.fElemMap[n3];
            if (xSWildcardDecl.fType != 3 && xSWildcardDecl.fType != 2) continue;
            return true;
        }
        return false;
    }

    public Vector whatCanGoHere(int[] nArray) {
        int n2 = nArray[0];
        if (n2 < 0) {
            n2 = nArray[1];
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            if (this.fTransTable[n2][i2] == -1) continue;
            vector.addElement(this.fElemMap[i2]);
        }
        return vector;
    }
}

