/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.ParameterDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor
extends FeatureDescriptor {
    private Reference methodRef;
    private String[] paramNames;
    private List params;
    private ParameterDescriptor[] parameterDescriptors;

    public MethodDescriptor(Method method) {
        this(method, null);
    }

    public MethodDescriptor(Method method, ParameterDescriptor[] parameterDescriptorArray) {
        this.setName(method.getName());
        this.setMethod(method);
        this.parameterDescriptors = parameterDescriptorArray;
    }

    public synchronized Method getMethod() {
        Class clazz;
        Method method = this.getMethod0();
        if (method == null && (clazz = this.getClass0()) != null) {
            Class[] classArray = this.getParams();
            if (classArray == null) {
                for (int i2 = 0; i2 < 3 && (method = Introspector.findMethod(clazz, this.getName(), i2, null)) == null; ++i2) {
                }
            } else {
                method = Introspector.findMethod(clazz, this.getName(), classArray.length, classArray);
            }
            this.setMethod(method);
        }
        return method;
    }

    private synchronized void setMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.setParams(method.getParameterTypes());
        this.methodRef = MethodDescriptor.createReference(method, true);
    }

    private Method getMethod0() {
        return (Method)MethodDescriptor.getObject(this.methodRef);
    }

    private synchronized void setParams(Class[] classArray) {
        if (classArray == null) {
            return;
        }
        this.paramNames = new String[classArray.length];
        this.params = new ArrayList(classArray.length);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.paramNames[i2] = classArray[i2].getName();
            this.params.add(new WeakReference<Class>(classArray[i2]));
        }
    }

    String[] getParamNames() {
        return this.paramNames;
    }

    private synchronized Class[] getParams() {
        Class[] classArray = new Class[this.params.size()];
        for (int i2 = 0; i2 < this.params.size(); ++i2) {
            Reference reference = (Reference)this.params.get(i2);
            Class clazz = (Class)reference.get();
            if (clazz == null) {
                return null;
            }
            classArray[i2] = clazz;
        }
        return classArray;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    MethodDescriptor(MethodDescriptor methodDescriptor, MethodDescriptor methodDescriptor2) {
        super(methodDescriptor, methodDescriptor2);
        this.methodRef = methodDescriptor.methodRef;
        if (methodDescriptor2.methodRef != null) {
            this.methodRef = methodDescriptor2.methodRef;
        }
        this.params = methodDescriptor.params;
        if (methodDescriptor2.params != null) {
            this.params = methodDescriptor2.params;
        }
        this.paramNames = methodDescriptor.paramNames;
        if (methodDescriptor2.paramNames != null) {
            this.paramNames = methodDescriptor2.paramNames;
        }
        this.parameterDescriptors = methodDescriptor.parameterDescriptors;
        if (methodDescriptor2.parameterDescriptors != null) {
            this.parameterDescriptors = methodDescriptor2.parameterDescriptors;
        }
    }

    MethodDescriptor(MethodDescriptor methodDescriptor) {
        super(methodDescriptor);
        this.methodRef = methodDescriptor.methodRef;
        this.params = methodDescriptor.params;
        this.paramNames = methodDescriptor.paramNames;
        if (methodDescriptor.parameterDescriptors != null) {
            int n2 = methodDescriptor.parameterDescriptors.length;
            this.parameterDescriptors = new ParameterDescriptor[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.parameterDescriptors[i2] = new ParameterDescriptor(methodDescriptor.parameterDescriptors[i2]);
            }
        }
    }
}

