/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XModalityProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisibilityEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWarningWindow;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsDevice;

class XWindowPeer
extends XPanelPeer
implements WindowPeer,
DisplayChangedListener {
    private static Logger log = Logger.getLogger("sun.awt.X11.XWindowPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus");
    private static Set windows = new HashSet();
    static XAtom wm_protocols;
    static XAtom wm_delete_window;
    static XAtom wm_take_focus;
    Insets insets = new Insets(0, 0, 0, 0);
    XWindowAttributesData winAttr;
    boolean cachedFocusableWindow;
    XWarningWindow warningWindow;
    XDialogPeer modalBlocker;
    boolean modalExclude;
    private boolean stateChanged;
    private int savedState;
    private boolean mustControlStackPosition = false;
    private XEventDispatcher rootPropertyEventDispatcher = null;
    private boolean firstMapped = true;
    static Font defaultFont;
    private int dropTargetCount = 0;

    XWindowPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams.putIfNull((Object)"parent window", new Long(0L)));
    }

    XWindowPeer(Window window) {
        super(new XCreateWindowParams(new Object[]{"target", window, "parent window", new Long(0L)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInit(XCreateWindowParams xCreateWindowParams) {
        Color color;
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.putIfNull((Object)"bit gravity", new Integer(1));
        this.savedState = 0;
        windows.add(this);
        this.winAttr = new XWindowAttributesData();
        this.insets = new Insets(0, 0, 0, 0);
        xCreateWindowParams.put("overrideRedirect", this.isOverrideRedirect());
        try {
            XToolkit.awtLock();
            if (wm_protocols == null) {
                wm_protocols = XAtom.get("WM_PROTOCOLS");
                wm_delete_window = XAtom.get("WM_DELETE_WINDOW");
                wm_take_focus = XAtom.get("WM_TAKE_FOCUS");
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.cachedFocusableWindow = this.isFocusableWindow();
        Font font = this.target.getFont();
        if (font == null) {
            if (defaultFont == null) {
                defaultFont = new Font("Dialog", 0, 12);
            }
            font = defaultFont;
            this.target.setFont(font);
        }
        if ((color = this.target.getBackground()) == null) {
            SystemColor systemColor = SystemColor.window;
            this.target.setBackground(systemColor);
        }
        if ((color = this.target.getForeground()) == null) {
            this.target.setForeground(SystemColor.windowText);
        }
    }

    private void initWMProtocols() {
        wm_protocols.setAtomListProperty((XBaseWindow)this, this.getWMProtocols());
    }

    protected XAtomList getWMProtocols() {
        return new XAtomList();
    }

    protected String getWMName() {
        String string = this.target.getName();
        if (string == null || string.trim().equals("")) {
            string = " ";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.initWMProtocols();
        Window window = (Window)this.target;
        Window window2 = window.getOwner();
        if (window2 != null) {
            long l2;
            XWindow xWindow = (XWindow)((Object)window2.getPeer());
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.fine("Owner is " + window2);
                focusLog.fine("Owner peer is " + xWindow);
                focusLog.fine("Owner X window " + xWindow.getWindow());
                focusLog.fine("Owner content X window " + xWindow.getContentWindow());
            }
            if ((l2 = xWindow.getWindow()) != 0L) {
                try {
                    XToolkit.awtLock();
                    if (focusLog.isLoggable(Level.FINE)) {
                        focusLog.fine("Setting transient on " + this.getWindow() + " for " + l2);
                    }
                    XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), this.getWindow(), l2);
                    XWMHints xWMHints = this.getWMHints();
                    xWMHints.set_flags(xWMHints.get_flags() | 0x40L);
                    xWMHints.set_window_group(l2);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
        if (((Window)this.target).getWarningString() != null) {
            this.warningWindow = new XWarningWindow((Window)this.target, this.getWindow());
        }
        this.setSaveUnder(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFocusability() {
        try {
            XToolkit.awtLock();
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(xWMHints.get_flags() | 1L);
            xWMHints.set_input(false);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int n2, int n3) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n2, n3));
    }

    public Insets insets() {
        return this.getInsets();
    }

    boolean isFocusableWindow() {
        return ((Window)this.target).isFocusableWindow();
    }

    boolean isNativelyNonFocusableWindow() {
        if (XToolkit.isToolkitThread()) {
            return this.isSimpleWindow() || !this.isFocusableWindow();
        }
        return this.isSimpleWindow() || !this.cachedFocusableWindow;
    }

    public void handleWindowFocusInSync(long l2) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        XWindowPeer.sendEvent(windowEvent);
    }

    public void handleWindowFocusIn(long l2) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        this.postEvent(XWindowPeer.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOut(Window window, long l2) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        this.postEvent(XWindowPeer.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOutSync(Window window, long l2) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        XWindowPeer.sendEvent(windowEvent);
    }

    void resetTargetGC(Component component) {
        ComponentAccessor.resetGC(component);
    }

    public void checkIfOnNewScreen(Rectangle rectangle) {
        if (!XToolkit.localEnv.runningXinerama()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("XWindowPeer: Check if we've been moved to a new screen since we're running in Xinerama mode");
        }
        int n2 = rectangle.width * rectangle.height;
        int n3 = 0;
        int n4 = ((X11GraphicsDevice)this.getGraphicsConfiguration().getDevice()).getScreen();
        int n5 = 0;
        GraphicsDevice[] graphicsDeviceArray = XToolkit.localEnv.getScreenDevices();
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            int n6;
            Rectangle rectangle2 = graphicsDeviceArray[i2].getDefaultConfiguration().getBounds();
            if (!rectangle.intersects(rectangle2)) continue;
            int n7 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - Math.max(rectangle.x, rectangle2.x);
            int n8 = n7 * (n6 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - Math.max(rectangle.y, rectangle2.y));
            if (n8 == n2) {
                n5 = i2;
                break;
            }
            if (n8 <= n3) continue;
            n3 = n8;
            n5 = i2;
        }
        if (n5 != n4) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("XWindowPeer: Moved to a new screen");
            }
            this.draggedToNewScreen(n5);
        }
    }

    public void draggedToNewScreen(int n2) {
        final int n3 = n2;
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                XWindowPeer.this.displayChanged(n3);
            }
        });
    }

    public void displayChanged(int n2) {
        this.resetLocalGC(n2);
        this.resetTargetGC(this.target);
        super.displayChanged(n2);
    }

    public void handleConfigureNotifyEvent(long l2) {
        XConfigureEvent xConfigureEvent = new XConfigureEvent(l2);
        this.checkIfOnNewScreen(new Rectangle(xConfigureEvent.get_x(), xConfigureEvent.get_y(), xConfigureEvent.get_width(), xConfigureEvent.get_height()));
        super.handleConfigureNotifyEvent(l2);
    }

    final boolean focusAllowedFor() {
        boolean bl2;
        XModalityProtocol xModalityProtocol;
        if (this.isNativelyNonFocusableWindow()) {
            return false;
        }
        Iterator iterator = XWM.getWM().getProtocols(XModalityProtocol.class).iterator();
        for (bl2 = true; iterator.hasNext() && bl2; bl2 &= !(xModalityProtocol = (XModalityProtocol)iterator.next()).isBlocked(null, this)) {
        }
        return bl2;
    }

    public void handleFocusEvent(long l2) {
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent(l2);
        focusLog.log(Level.FINE, "{0}", new Object[]{xFocusChangeEvent});
        if (this.isEventDisabled(xFocusChangeEvent)) {
            return;
        }
        if (xFocusChangeEvent.get_type() == 9) {
            if (this.focusAllowedFor() && (xFocusChangeEvent.get_mode() == 0 || xFocusChangeEvent.get_mode() == 3)) {
                this.handleWindowFocusIn(xFocusChangeEvent.get_serial());
            }
        } else if (!(xFocusChangeEvent.get_mode() != 0 && xFocusChangeEvent.get_mode() != 3 || this.isNativelyNonFocusableWindow())) {
            XWindowPeer xWindowPeer = (XWindowPeer)XToolkit.windowToXWindow(this.xGetInputFocus());
            Object object = xWindowPeer != null ? xWindowPeer.getTarget() : null;
            Window window = null;
            if (object instanceof Window) {
                window = (Window)object;
            }
            if (xWindowPeer != null && xWindowPeer.isNativelyNonFocusableWindow()) {
                return;
            }
            if (xWindowPeer != null && !xWindowPeer.focusAllowedFor()) {
                xWindowPeer = null;
            }
            if (this == xWindowPeer) {
                window = null;
            }
            this.handleWindowFocusOut(window, xFocusChangeEvent.get_serial());
        }
    }

    public void dispatchEvent(XAnyEvent xAnyEvent) {
        int n2 = xAnyEvent.get_type();
        switch (n2) {
            case 9: 
            case 10: {
                this.handleFocusEvent(xAnyEvent.pData);
            }
        }
        super.dispatchEvent(xAnyEvent);
    }

    void setSaveUnder(boolean bl2) {
    }

    public void toFront() {
        if (this.isOverrideRedirect() && this.mustControlStackPosition) {
            this.mustControlStackPosition = false;
            this.removeRootPropertyEventDispatcher();
        }
        if (this.isVisible()) {
            super.toFront();
            if (this.isFocusableWindow() && !this.isWithdrawn()) {
                this.requestInitialFocus();
            }
        } else {
            this.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBack() {
        try {
            XToolkit.awtLock();
            if (!this.isOverrideRedirect()) {
                XlibWrapper.XLowerWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                this.lowerOverrideRedirect();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerOverrideRedirect() {
        HashSet<Long> hashSet = new HashSet<Long>();
        Iterator iterator = windows.iterator();
        XWindowPeer xWindowPeer = null;
        long l2 = 0L;
        long l3 = 0L;
        while (iterator.hasNext()) {
            xWindowPeer = (XWindowPeer)iterator.next();
            l2 = this.getToplevelWindow(xWindowPeer.getWindow());
            if (xWindowPeer.equals(this)) {
                l3 = l2;
            }
            if (l2 <= 0L) continue;
            hashSet.add(new Long(l2));
        }
        long l4 = -1L;
        long l5 = -1L;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        XQueryTree xQueryTree = new XQueryTree(XToolkit.getDefaultRootWindow());
        try {
            if (xQueryTree.execute() > 0) {
                int n6 = xQueryTree.get_nchildren();
                long l6 = xQueryTree.get_children();
                for (n5 = 0; n5 < n6; ++n5) {
                    long l7 = Native.getWindow(l6, n5);
                    if (l7 == l3) {
                        n2 = n5;
                        continue;
                    }
                    if (this.isDesktopWindow(l7)) {
                        n3 = n5;
                        l4 = l7;
                        continue;
                    }
                    if (n4 >= 0 || !hashSet.contains(new Long(l7)) || l7 == l3) continue;
                    n4 = n5;
                    l5 = l7;
                }
            }
            if ((n2 < n4 || n4 < 0) && n3 < n2) {
                return;
            }
            long l8 = Native.allocateLongArray(2);
            Native.putLong(l8, 0, l5);
            Native.putLong(l8, 1, l3);
            XlibWrapper.XRestackWindows(XToolkit.getDisplay(), l8, 2);
            XlibWrapper.unsafe.freeMemory(l8);
            if (!this.mustControlStackPosition) {
                this.mustControlStackPosition = true;
                this.addRootPropertyEventDispatcher();
            }
        }
        finally {
            xQueryTree.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long l2) {
        long l3;
        long l4;
        long l5 = l2;
        do {
            l3 = l5;
            XQueryTree xQueryTree = new XQueryTree(l5);
            try {
                if (xQueryTree.execute() == 0) {
                    long l6 = 0L;
                    return l6;
                }
                l4 = xQueryTree.get_root();
                l5 = xQueryTree.get_parent();
            }
            finally {
                xQueryTree.dispose();
            }
        } while (l5 != l4);
        return l3;
    }

    private boolean isDesktopWindow(long l2) {
        return XWM.getWM().isDesktopWindow(l2);
    }

    public void updateAlwaysOnTop() {
        XWM.getWM().setLayer(this, ((Window)this.target).isAlwaysOnTop() ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteDefaultPosition() {
        if (((Window)this.target).isLocationByPlatform()) {
            Object object = XWindowPeer.getAWTLock();
            synchronized (object) {
                Rectangle rectangle = this.getBounds();
                XSizeHints xSizeHints = this.getHints();
                this.setSizeHints(xSizeHints.get_flags() & 0xFFFFFFFFFFFFFFFAL, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void setVisible(boolean bl2) {
        this.updateFocusability();
        this.promoteDefaultPosition();
        super.setVisible(bl2);
    }

    boolean isSimpleWindow() {
        return !(this.target instanceof Frame) && !(this.target instanceof Dialog);
    }

    boolean hasWarningWindow() {
        return this.warningWindow != null;
    }

    int getMenuBarHeight() {
        return 0;
    }

    int getWarningWindowHeight() {
        if (this.warningWindow != null) {
            return this.warningWindow.getHeight();
        }
        return 0;
    }

    void updateChildrenSizes() {
        if (this.warningWindow != null) {
            this.warningWindow.reshape(0, this.getMenuBarHeight(), this.getSize().width, this.warningWindow.getHeight());
        }
    }

    boolean isOverrideRedirect() {
        return true;
    }

    final boolean isOLWMDecorBug() {
        return XWM.getWMID() == 4 && !this.winAttr.nativeDecor;
    }

    public void dispose() {
        windows.remove(this);
        if (this.warningWindow != null) {
            this.warningWindow.destroy();
        }
        this.removeRootPropertyEventDispatcher();
        this.mustControlStackPosition = false;
        super.dispose();
    }

    boolean isResizable() {
        return this.winAttr.isResizable;
    }

    public void handleVisibilityEvent(long l2) {
        super.handleVisibilityEvent(l2);
        XVisibilityEvent xVisibilityEvent = new XVisibilityEvent(l2);
        this.winAttr.visibilityState = xVisibilityEvent.get_state();
        if (xVisibilityEvent.get_state() == 0) {
            // empty if block
        }
    }

    public void handlePropertyNotify(long l2) {
        super.handlePropertyNotify(l2);
        XPropertyEvent xPropertyEvent = new XPropertyEvent(l2);
        if (xPropertyEvent.get_atom() == XWM.XA_WM_STATE.getAtom()) {
            this.stateChanged = true;
            this.stateChanged(xPropertyEvent.get_time(), this.savedState, this.getWMState());
        }
    }

    void handleRootPropertyNotify(IXAnyEvent iXAnyEvent) {
        XPropertyEvent xPropertyEvent = new XPropertyEvent(iXAnyEvent.getPData());
        if (this.mustControlStackPosition && xPropertyEvent.get_atom() == XAtom.get("_NET_CLIENT_LIST_STACKING").getAtom() && this.isOverrideRedirect()) {
            this.toBack();
        }
    }

    public void handleMapNotifyEvent(long l2) {
        super.handleMapNotifyEvent(l2);
        if (!this.isNativelyNonFocusableWindow() && this.firstMapped) {
            this.requestInitialFocus();
            this.firstMapped = false;
        }
        this.updateAlwaysOnTop();
    }

    protected void requestInitialFocus() {
        this.xRequestFocus();
    }

    protected void stateChanged(long l2, int n2, int n3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWMState() {
        if (this.stateChanged) {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(this.window, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
            try {
                int n2 = windowPropertyGetter.execute();
                if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                    int n3 = 0;
                    return n3;
                }
                if (windowPropertyGetter.getActualType() != XWM.XA_WM_STATE.getAtom() && windowPropertyGetter.getActualFormat() != 32) {
                    int n4 = 0;
                    return n4;
                }
                this.savedState = (int)Native.getCard32(windowPropertyGetter.getData());
                this.stateChanged = false;
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
        return this.savedState;
    }

    boolean isWithdrawn() {
        return this.getWMState() == 0;
    }

    boolean hasDecorations(int n2) {
        boolean bl2;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int n3 = this.winAttr.decorations;
        boolean bl3 = bl2 = (n3 & n2) == n2;
        if ((n3 & XWindowAttributesData.AWT_DECOR_ALL) != 0) {
            return !bl2;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModalBlocked(XDialogPeer xDialogPeer, boolean bl2) {
        Object object = XWindowPeer.getAWTLock();
        synchronized (object) {
            Object object2 = this.getStateLock();
            synchronized (object2) {
                if (bl2) {
                    log.log(Level.FINE, "{0} is blocked by {1}", new Object[]{this, xDialogPeer});
                    this.modalBlocker = xDialogPeer;
                    XAtomList xAtomList = wm_protocols.getAtomListPropertyList(this);
                    log.log(Level.FINER, "Setting protocols {0}", new Object[]{xAtomList});
                    wm_protocols.setAtomListProperty((XBaseWindow)this, xAtomList);
                    XToolkit.XSync();
                } else {
                    if (xDialogPeer != this.modalBlocker) {
                        throw new IllegalStateException("Trying to unblock window blocked by another dialog");
                    }
                    this.modalBlocker = null;
                    wm_protocols.setAtomListProperty((XBaseWindow)this, this.getWMProtocols());
                }
            }
        }
    }

    static Collection getAllWindows() {
        return Collections.unmodifiableSet(windows);
    }

    static Collection getAllUnblockedWindows() {
        LinkedList<XWindowPeer> linkedList = new LinkedList<XWindowPeer>();
        for (XWindowPeer xWindowPeer : windows) {
            if (xWindowPeer.isModalBlocked()) continue;
            linkedList.add(xWindowPeer);
        }
        return linkedList;
    }

    public boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    public final boolean isModalExclude() {
        return this.modalExclude;
    }

    public boolean requestWindowFocus() {
        XDecoratedPeer xDecoratedPeer;
        focusLog.fine("Request for window focus");
        Window window = (Window)this.target;
        Window window2 = window.getOwner();
        if (window2.isActive()) {
            focusLog.fine("Parent window is active - generating focus for this window");
            this.handleWindowFocusInSync(-1L);
            return true;
        }
        focusLog.fine("Parent window is not active");
        if (window2.getPeer() instanceof XDecoratedPeer && (xDecoratedPeer = (XDecoratedPeer)window2.getPeer()).requestWindowFocus(this)) {
            focusLog.fine("Parent window accepted focus request - generating focus for this window");
            return true;
        }
        focusLog.fine("Denied - parent window is not active and didn't accept focus request");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetVisible(boolean bl2) {
        try {
            XToolkit.awtLock();
            this.visible = bl2;
            if (bl2) {
                XlibWrapper.XMapRaised(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public synchronized void addDropTarget() {
        long l2;
        if (this.dropTargetCount == 0 && (l2 = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().registerDropSite(l2);
        }
        ++this.dropTargetCount;
    }

    public synchronized void removeDropTarget() {
        long l2;
        --this.dropTargetCount;
        if (this.dropTargetCount == 0 && (l2 = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().unregisterDropSite(l2);
        }
    }

    void addRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher == null) {
            this.rootPropertyEventDispatcher = new XEventDispatcher(){

                public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                    if (iXAnyEvent.get_type() == 28) {
                        XWindowPeer.this.handleRootPropertyNotify(iXAnyEvent);
                    }
                }
            };
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 0x400000L);
            XToolkit.addEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
        }
    }

    void removeRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher != null) {
            XToolkit.removeEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
            this.rootPropertyEventDispatcher = null;
        }
    }
}

