/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.io.CharToByteConverter;
import sun.io.CompoundTextSupport;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteCOMPOUND_TEXT
extends CharToByteConverter {
    private static final Map encodingToConverterMap = Collections.synchronizedMap(new HashMap(21, 1.0f));
    private static final CharToByteConverter latin1Converter;
    private static final CharToByteConverter defaultConverter;
    private static final boolean defaultEncodingSupported;
    private CharToByteConverter converter;
    private char[] charBuf = new char[1];
    private ByteArrayOutputStream nonStandardCharsetBuffer;
    private byte[] byteBuf;
    private int numNonStandardChars;
    private int nonStandardEncodingLen;

    public CharToByteCOMPOUND_TEXT() {
        try {
            this.converter = CharToByteConverter.getConverter("ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.initConverter(this.converter);
    }

    public String getCharacterEncoding() {
        return "COMPOUND_TEXT";
    }

    public int convert(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        int n6 = n4;
        this.charOff = n2;
        this.byteOff = n4;
        if (n2 >= n3) {
            return 0;
        }
        while (this.charOff < n3) {
            CharToByteConverter charToByteConverter;
            this.charBuf[0] = cArray[this.charOff];
            if (this.charBuf[0] <= '\b' || this.charBuf[0] >= '\u000b' && this.charBuf[0] <= '\u001f' || this.charBuf[0] >= '\u0080' && this.charBuf[0] <= '\u009f') {
                this.charBuf[0] = 63;
            }
            if ((charToByteConverter = this.getConverter(this.charBuf[0])) == null) {
                if (this.subMode) {
                    this.charBuf[0] = 63;
                    charToByteConverter = latin1Converter;
                } else {
                    throw new UnknownCharacterException();
                }
            }
            if (charToByteConverter != this.converter) {
                this.byteOff = this.nonStandardCharsetBuffer != null ? (this.byteOff += this.flushNonStandardCharsetBuffer(byArray, this.byteOff, n5)) : (this.byteOff += this.converter.flush(byArray, this.byteOff, n5));
                byte[] byArray2 = CompoundTextSupport.getEscapeSequence(charToByteConverter.getCharacterEncoding());
                if (byArray2 == null) {
                    throw new InternalError("Unknown encoding: " + this.converter.getCharacterEncoding());
                }
                if (byArray2[1] == 37 && byArray2[2] == 47) {
                    this.initNonStandardCharsetBuffer(charToByteConverter, byArray2);
                } else if (this.byteOff + byArray2.length <= n5) {
                    System.arraycopy(byArray2, 0, byArray, this.byteOff, byArray2.length);
                    this.byteOff += byArray2.length;
                } else {
                    throw new ConversionBufferFullException();
                }
                this.converter = charToByteConverter;
                continue;
            }
            if (this.nonStandardCharsetBuffer == null) {
                this.byteOff += this.converter.convert(this.charBuf, 0, 1, byArray, this.byteOff, n5);
            } else {
                int n7 = this.converter.convert(this.charBuf, 0, 1, this.byteBuf, 0, this.byteBuf.length);
                this.nonStandardCharsetBuffer.write(this.byteBuf, 0, n7);
                ++this.numNonStandardChars;
            }
            ++this.charOff;
        }
        return this.byteOff - n6;
    }

    public int flush(byte[] byArray, int n2, int n3) throws ConversionBufferFullException, MalformedInputException {
        int n4;
        try {
            n4 = this.nonStandardCharsetBuffer != null ? this.flushNonStandardCharsetBuffer(byArray, n2, n3) : this.converter.flush(byArray, n2, n3);
        }
        catch (MalformedInputException malformedInputException) {
            this.reset();
            throw malformedInputException;
        }
        this.reset();
        return n4;
    }

    private void initNonStandardCharsetBuffer(CharToByteConverter charToByteConverter, byte[] byArray) {
        this.nonStandardCharsetBuffer = new ByteArrayOutputStream();
        this.byteBuf = new byte[charToByteConverter.getMaxBytesPerChar()];
        this.nonStandardCharsetBuffer.write(byArray, 0, byArray.length);
        this.nonStandardCharsetBuffer.write(0);
        this.nonStandardCharsetBuffer.write(0);
        byte[] byArray2 = CompoundTextSupport.getEncoding(charToByteConverter.getCharacterEncoding());
        if (byArray2 == null) {
            throw new InternalError("Unknown encoding: " + this.converter.getCharacterEncoding());
        }
        this.nonStandardCharsetBuffer.write(byArray2, 0, byArray2.length);
        this.nonStandardCharsetBuffer.write(2);
        this.nonStandardEncodingLen = byArray2.length + 1;
    }

    private int flushNonStandardCharsetBuffer(byte[] byArray, int n2, int n3) throws ConversionBufferFullException, MalformedInputException {
        int n4;
        int n5;
        int n6;
        int n7 = n2;
        if (this.numNonStandardChars > 0) {
            byte[] byArray2 = new byte[this.converter.getMaxBytesPerChar() * this.numNonStandardChars];
            n6 = this.converter.flush(byArray2, 0, byArray2.length);
            this.nonStandardCharsetBuffer.write(byArray2, 0, n6);
            this.numNonStandardChars = 0;
        }
        if (n2 + ((n5 = this.nonStandardCharsetBuffer.size()) - (n6 = 6 + this.nonStandardEncodingLen)) + n6 * ((n5 - n6) / 16383 + 1) > n3) {
            throw new ConversionBufferFullException();
        }
        byte[] byArray3 = this.nonStandardCharsetBuffer.toByteArray();
        do {
            byArray[n2++] = 27;
            byArray[n2++] = 37;
            byArray[n2++] = 47;
            byArray[n2++] = byArray3[3];
            n4 = Math.min(n5 - n6, 16383 - this.nonStandardEncodingLen);
            byArray[n2++] = (byte)((n4 + this.nonStandardEncodingLen) / 128 | 0x80);
            byArray[n2++] = (byte)((n4 + this.nonStandardEncodingLen) % 128 | 0x80);
            System.arraycopy(byArray3, 6, byArray, n2, this.nonStandardEncodingLen);
            System.arraycopy(byArray3, n6, byArray, n2 += this.nonStandardEncodingLen, n4);
            n2 += n4;
        } while ((n6 += n4) < n5);
        this.nonStandardCharsetBuffer = null;
        this.byteBuf = null;
        this.nonStandardEncodingLen = 0;
        return n2 - n7;
    }

    public void reset() {
        this.nonStandardEncodingLen = 0;
        this.numNonStandardChars = 0;
        this.charOff = 0;
        this.byteOff = 0;
        this.nonStandardCharsetBuffer = null;
        this.byteBuf = null;
        try {
            this.converter = CharToByteConverter.getConverter("ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.initConverter(this.converter);
    }

    public boolean canConvert(char c2) {
        return this.getConverter(c2) != null;
    }

    public int getMaxBytesPerChar() {
        return CompoundTextSupport.MAX_CONTROL_SEQUENCE_LEN + 2;
    }

    public int getBadInputLength() {
        return this.converter.getBadInputLength();
    }

    public void setSubstitutionMode(boolean bl2) {
        super.setSubstitutionMode(bl2);
        this.converter.setSubstitutionMode(bl2);
    }

    public void setSubstitutionBytes(byte[] byArray) throws IllegalArgumentException {
        super.setSubstitutionBytes(byArray);
        this.converter.setSubstitutionBytes(byArray);
    }

    private CharToByteConverter getConverter(char c2) {
        if (this.converter.canConvert(c2)) {
            return this.converter;
        }
        if (defaultEncodingSupported && defaultConverter.canConvert(c2)) {
            CharToByteConverter charToByteConverter = null;
            try {
                charToByteConverter = CharToByteConverter.getConverter(defaultConverter.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.initConverter(charToByteConverter);
            return charToByteConverter;
        }
        if (latin1Converter.canConvert(c2)) {
            CharToByteConverter charToByteConverter = null;
            try {
                charToByteConverter = CharToByteConverter.getConverter("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.initConverter(charToByteConverter);
            return charToByteConverter;
        }
        for (String string : CompoundTextSupport.getEncodings()) {
            CharToByteConverter charToByteConverter = (CharToByteConverter)encodingToConverterMap.get(string);
            if (charToByteConverter == null) {
                charToByteConverter = CompoundTextSupport.encodingToCharToByteConverter(string);
                if (charToByteConverter == null) {
                    throw new InternalError("Unsupported encoding: " + string);
                }
                encodingToConverterMap.put(string, charToByteConverter);
            }
            if (!charToByteConverter.canConvert(c2)) continue;
            CharToByteConverter charToByteConverter2 = CompoundTextSupport.encodingToCharToByteConverter(string);
            this.initConverter(charToByteConverter2);
            return charToByteConverter2;
        }
        return null;
    }

    private void initConverter(CharToByteConverter charToByteConverter) {
        charToByteConverter.setSubstitutionMode(this.subMode);
        charToByteConverter.setSubstitutionBytes(this.subBytes);
    }

    static {
        CharToByteConverter charToByteConverter = CharToByteConverter.getDefault();
        String string = charToByteConverter.getCharacterEncoding();
        if ("ISO8859_1".equals(string)) {
            latin1Converter = charToByteConverter;
            defaultConverter = charToByteConverter;
            defaultEncodingSupported = true;
        } else {
            try {
                latin1Converter = CharToByteConverter.getConverter("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ExceptionInInitializerError("ISO8859_1 unsupported");
            }
            defaultConverter = charToByteConverter;
            defaultEncodingSupported = CompoundTextSupport.getEncodings().contains(defaultConverter.getCharacterEncoding());
        }
    }
}

