/*NSRCOPYRIGHT
	Copyright (C) 1999-2003 by
	National Simulation Resource
	Department of Bioengineering,  Box 357962
	University of Washington, Seattle, WA 98195.
	Dr. J. B. Bassingthwaighte, Director
	All rights reserved.
	No portion may be copied or distributed without written 
	authorization from the director of the National 
	Simulation Resource at the University of Washington.
	Complete license terms are described in the file
	LICENSE in the JSim source distribution root directory.
END_NSRCOPYRIGHT*/

// C lang context,  including cache names
import JSim.util.*;
import JSim.mml.*;
import JSim.plan.*;

public class MyContext extends CompContext {
	public MyPlanWriter wrt;

	// constructor
	public MyContext(MyPlanWriter w) {
	    super(MyLang.lang, w.math);
	    wrt = w;
	}

	// name for Var
	public String newName(Named n) {
	    return n.name().replace(':', '_');
	} 

	// func call string
	public String funcCall(Named n, Expr.List elist) {
	    Var v = (Var) n;
	    String s = newName(v) + "(";
	    for (int i=0; i<elist.size(); i++) {
		if (i>0) s = s + ",";
		s = s + elist.expr(i).toString(this);
	    }
	    return s + ")";
	}	
}
