/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import com.sun.corba.se.internal.util.PackagePrefixChecker;
import com.sun.corba.se.internal.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.AbstractType;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Generator;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.StaticStringsHash;
import sun.rmi.rmic.iiop.StringComparator;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.UserExceptionComparator;
import sun.rmi.rmic.iiop.Util;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class StubGenerator
extends Generator {
    private static final String DEFAULT_STUB_CLASS = "javax.rmi.CORBA.Stub";
    private static final String DEFAULT_TIE_CLASS = "org.omg.CORBA_2_3.portable.ObjectImpl";
    private static final String DEFAULT_POA_TIE_CLASS = "org.omg.PortableServer.Servant";
    protected boolean reverseIDs = false;
    protected boolean localStubs = true;
    protected boolean useHash = true;
    protected String stubBaseClass = "javax.rmi.CORBA.Stub";
    protected String tieBaseClass = "org.omg.CORBA_2_3.portable.ObjectImpl";
    protected HashSet namesInUse = new HashSet();
    protected Hashtable classesInUse = new Hashtable();
    protected Hashtable imports = new Hashtable();
    protected int importCount = 0;
    protected String currentPackage = null;
    protected String currentClass = null;
    protected boolean castArray = false;
    protected Hashtable transactionalObjects = new Hashtable();
    protected boolean POATie = false;
    private static final String NO_IMPORT = new String();
    static final String SINGLE_SLASH = "\\";
    static final String DOUBLE_SLASH = "\\\\";

    protected boolean requireNewInstance() {
        return false;
    }

    protected boolean parseNonConforming(ContextStack contextStack) {
        return contextStack.getEnv().getParseNonConforming();
    }

    protected CompoundType getTopType(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        if (classDefinition.isInterface()) {
            compoundType = AbstractType.forAbstract(classDefinition, contextStack, true);
            if (compoundType == null) {
                compoundType = RemoteType.forRemote(classDefinition, contextStack, false);
            }
        } else {
            compoundType = ImplementationType.forImplementation(classDefinition, contextStack, false);
        }
        return compoundType;
    }

    public boolean parseArgs(String[] stringArray, Main main) {
        Object object = new Object();
        this.reverseIDs = false;
        this.localStubs = true;
        this.useHash = true;
        this.stubBaseClass = DEFAULT_STUB_CLASS;
        this.transactionalObjects = new Hashtable();
        boolean bl = super.parseArgs(stringArray, main);
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    String string = stringArray[n].toLowerCase();
                    if (string.equals("-iiop")) {
                        stringArray[n] = null;
                    } else if (string.equals("-xreverseids")) {
                        this.reverseIDs = true;
                        stringArray[n] = null;
                    } else if (string.equals("-nolocalstubs")) {
                        this.localStubs = false;
                        stringArray[n] = null;
                    } else if (string.equals("-xnohash")) {
                        this.useHash = false;
                        stringArray[n] = null;
                    } else if (string.equals("-xstubbase")) {
                        stringArray[n] = null;
                        if (++n < stringArray.length && stringArray[n] != null && !stringArray[n].startsWith("-")) {
                            this.stubBaseClass = stringArray[n];
                            stringArray[n] = null;
                        } else {
                            main.error("rmic.option.requires.argument", "-Xstubbase");
                            bl = false;
                        }
                    } else if (string.equals("-xtiebase")) {
                        stringArray[n] = null;
                        if (++n < stringArray.length && stringArray[n] != null && !stringArray[n].startsWith("-")) {
                            this.tieBaseClass = stringArray[n];
                            stringArray[n] = null;
                        } else {
                            main.error("rmic.option.requires.argument", "-Xtiebase");
                            bl = false;
                        }
                    } else if (string.equals("-transactional")) {
                        int n2 = n + 1;
                        while (n2 < stringArray.length) {
                            if (stringArray[n2].charAt(1) != '-') {
                                this.transactionalObjects.put(stringArray[n2], object);
                                break;
                            }
                            ++n2;
                        }
                        stringArray[n] = null;
                    } else if (string.equals("-poa")) {
                        this.POATie = true;
                        stringArray[n] = null;
                    }
                }
                ++n;
            }
        }
        this.tieBaseClass = this.POATie ? DEFAULT_POA_TIE_CLASS : DEFAULT_TIE_CLASS;
        return bl;
    }

    protected Generator.OutputType[] getOutputTypesFor(CompoundType compoundType, HashSet hashSet) {
        Object object;
        int n = 69632;
        Type[] typeArray = compoundType.collectMatching(n, hashSet);
        int n2 = typeArray.length;
        Vector<Generator.OutputType> vector = new Vector<Generator.OutputType>(n2 + 5);
        BatchEnvironment batchEnvironment = compoundType.getEnv();
        int n3 = 0;
        while (n3 < typeArray.length) {
            object = typeArray[n3];
            String string = ((Type)object).getName();
            boolean bl = true;
            if (object instanceof ImplementationType) {
                vector.addElement(new Generator.OutputType(this, Utility.tieNameForCompiler((String)string), (Type)object));
                int n4 = 0;
                InterfaceType[] interfaceTypeArray = ((CompoundType)object).getInterfaces();
                int n5 = 0;
                while (n5 < interfaceTypeArray.length) {
                    if (interfaceTypeArray[n5].isType(4096) && !interfaceTypeArray[n5].isType(8192)) {
                        ++n4;
                    }
                    ++n5;
                }
                if (n4 <= 1) {
                    bl = false;
                }
            }
            if (object instanceof AbstractType) {
                bl = false;
            }
            if (bl) {
                vector.addElement(new Generator.OutputType(this, Utility.stubNameForCompiler((String)string), (Type)object));
            }
            ++n3;
        }
        object = new Generator.OutputType[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".java";
    }

    protected void writeOutputFor(Generator.OutputType outputType, HashSet hashSet, IndentingWriter indentingWriter) throws IOException {
        String string = outputType.getName();
        CompoundType compoundType = (CompoundType)outputType.getType();
        if (string.endsWith("_Stub")) {
            this.writeStub(outputType, indentingWriter);
        } else {
            this.writeTie(outputType, indentingWriter);
        }
    }

    protected void writeStub(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        RemoteType[] remoteTypeArray = this.getDirectRemoteInterfaces(compoundType);
        indentingWriter.pln("// Stub class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        this.setStandardClassesInUse(compoundType, true);
        this.addClassesInUse(compoundType, remoteTypeArray);
        this.writePackageAndImports(indentingWriter);
        indentingWriter.p("public class " + this.currentClass);
        indentingWriter.p(" extends " + this.getName(this.stubBaseClass));
        indentingWriter.p(" implements ");
        if (remoteTypeArray.length > 0) {
            int n = 0;
            while (n < remoteTypeArray.length) {
                if (n > 0) {
                    indentingWriter.pln(",");
                }
                indentingWriter.p(this.getName(remoteTypeArray[n]));
                ++n;
            }
        }
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName("java.rmi.Remote"));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType, false);
        indentingWriter.pln();
        indentingWriter.plnI("public String[] _ids() { ");
        indentingWriter.pln("return _type_ids;");
        indentingWriter.pOln("}");
        CompoundType.Method[] methodArray = compoundType.getMethods();
        int n = methodArray.length;
        if (n > 0) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (!methodArray[n2].isConstructor()) {
                    if (bl) {
                        bl = false;
                    }
                    indentingWriter.pln();
                    this.writeStubMethod(indentingWriter, methodArray[n2], compoundType);
                }
                ++n2;
            }
        }
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    void addClassInUse(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        this.addClassInUse(string2, string, string3);
    }

    void addClassInUse(Type type) {
        if (!type.isPrimitive()) {
            Identifier identifier = type.getIdentifier();
            String string = IDLNames.replace(identifier.getName().toString(), ". ", ".");
            String string2 = type.getPackageName();
            String string3 = string2 != null ? string2 + "." + string : string;
            this.addClassInUse(string, string3, string2);
        }
    }

    void addClassInUse(Type[] typeArray) {
        int n = 0;
        while (n < typeArray.length) {
            this.addClassInUse(typeArray[n]);
            ++n;
        }
    }

    void addStubInUse(Type type) {
        if (type.getIdentifier() != sun.rmi.rmic.iiop.Constants.idCorbaObject && type.isType(2048)) {
            String string = this.getStubNameFor(type, false);
            String string2 = type.getPackageName();
            String string3 = string2 == null ? string : string2 + "." + string;
            this.addClassInUse(string, string3, string2);
        }
        if (type.isType(4096) || type.isType(524288)) {
            this.addClassInUse("javax.rmi.PortableRemoteObject");
        }
    }

    String getStubNameFor(Type type, boolean bl) {
        String string = bl ? type.getQualifiedName() : type.getName();
        String string2 = ((CompoundType)type).isCORBAObject() ? Utility.idlStubName((String)string) : Utility.stubNameForCompiler((String)string);
        return string2;
    }

    void addStubInUse(Type[] typeArray) {
        int n = 0;
        while (n < typeArray.length) {
            this.addStubInUse(typeArray[n]);
            ++n;
        }
    }

    void addClassInUse(String string, String string2, String string3) {
        String string4 = (String)this.classesInUse.get(string2);
        if (string4 == null) {
            String string5 = (String)this.imports.get(string);
            String string6 = null;
            if (string3 == null) {
                string6 = string;
            } else if (string3.equals("java.lang")) {
                string6 = string;
                if (string6.endsWith("_Stub")) {
                    string6 = Util.packagePrefix() + string2;
                }
            } else if (this.currentPackage != null && string3.equals(this.currentPackage)) {
                string6 = string;
                if (string5 != null) {
                    String string7 = (String)this.imports.remove(string);
                    this.classesInUse.put(string7, string7);
                    --this.importCount;
                }
                this.imports.put(string6, NO_IMPORT);
            } else if (string5 != null) {
                string6 = string2;
            } else if (string2.equals("org.omg.CORBA.Object")) {
                string6 = string2;
            } else if (string.indexOf(46) != -1) {
                string6 = string2;
            } else {
                string6 = string;
                this.imports.put(string, string2);
                ++this.importCount;
            }
            this.classesInUse.put(string2, string6);
        }
    }

    String getName(Type type) {
        if (type.isPrimitive()) {
            return type.getName() + type.getArrayBrackets();
        }
        Identifier identifier = type.getIdentifier();
        String string = IDLNames.replace(identifier.toString(), ". ", ".");
        return this.getName(string) + type.getArrayBrackets();
    }

    String getName(String string) {
        return (String)this.classesInUse.get(string);
    }

    String getName(Identifier identifier) {
        return this.getName(identifier.toString());
    }

    String getStubName(Type type) {
        String string = this.getStubNameFor(type, true);
        return this.getName(string);
    }

    void setStandardClassesInUse(CompoundType compoundType, boolean bl) throws IOException {
        this.currentPackage = compoundType.getPackageName();
        this.imports.clear();
        this.classesInUse.clear();
        this.namesInUse.clear();
        this.importCount = 0;
        this.castArray = false;
        this.addClassInUse(compoundType);
        this.currentClass = bl ? Utility.stubNameForCompiler((String)compoundType.getName()) : Utility.tieNameForCompiler((String)compoundType.getName());
        if (this.currentPackage == null) {
            this.addClassInUse(this.currentClass, this.currentClass, this.currentPackage);
        } else {
            this.addClassInUse(this.currentClass, this.currentPackage + "." + this.currentClass, this.currentPackage);
        }
        this.addClassInUse("javax.rmi.CORBA.Util");
        this.addClassInUse(Constants.idRemote.toString());
        this.addClassInUse(Constants.idRemoteException.toString());
        this.addClassInUse(sun.rmi.rmic.iiop.Constants.idOutputStream.toString());
        this.addClassInUse(sun.rmi.rmic.iiop.Constants.idInputStream.toString());
        this.addClassInUse(sun.rmi.rmic.iiop.Constants.idSystemException.toString());
        this.addClassInUse(sun.tools.java.Constants.idJavaIoSerializable.toString());
        this.addClassInUse(sun.rmi.rmic.iiop.Constants.idCorbaORB.toString());
        this.addClassInUse(sun.rmi.rmic.iiop.Constants.idReplyHandler.toString());
        if (bl) {
            this.addClassInUse(this.stubBaseClass);
            this.addClassInUse("java.rmi.UnexpectedException");
            this.addClassInUse(sun.rmi.rmic.iiop.Constants.idRemarshalException.toString());
            this.addClassInUse(sun.rmi.rmic.iiop.Constants.idApplicationException.toString());
            if (this.localStubs) {
                this.addClassInUse("org.omg.CORBA.portable.ServantObject");
            }
        } else {
            this.addClassInUse(compoundType);
            this.addClassInUse(this.tieBaseClass);
            this.addClassInUse(sun.rmi.rmic.iiop.Constants.idTieInterface.toString());
            this.addClassInUse(sun.rmi.rmic.iiop.Constants.idBadMethodException.toString());
            this.addClassInUse(sun.rmi.rmic.iiop.Constants.idPortableUnknownException.toString());
            this.addClassInUse(sun.tools.java.Constants.idJavaLangThrowable.toString());
        }
    }

    void addClassesInUse(CompoundType compoundType, RemoteType[] remoteTypeArray) {
        CompoundType.Method[] methodArray = compoundType.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            this.addClassInUse(methodArray[n].getReturnType());
            this.addStubInUse(methodArray[n].getReturnType());
            this.addClassInUse(methodArray[n].getArguments());
            this.addStubInUse(methodArray[n].getArguments());
            this.addClassInUse(methodArray[n].getExceptions());
            ++n;
        }
        if (remoteTypeArray != null) {
            this.addClassInUse(remoteTypeArray);
        }
    }

    void writePackageAndImports(IndentingWriter indentingWriter) throws IOException {
        if (this.currentPackage != null) {
            indentingWriter.pln("package " + Util.correctPackageName(this.currentPackage, false) + ";");
            indentingWriter.pln();
        }
        String[] stringArray = new String[this.importCount];
        int n = 0;
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == NO_IMPORT) continue;
            stringArray[n++] = string;
        }
        Arrays.sort(stringArray, new StringComparator());
        int n2 = 0;
        while (n2 < this.importCount) {
            if (Util.isOffendingPackage(stringArray[n2]) && stringArray[n2].endsWith("_Stub") && String.valueOf(stringArray[n2].charAt(stringArray[n2].lastIndexOf(".") + 1)).equals("_")) {
                indentingWriter.pln("import " + PackagePrefixChecker.packagePrefix() + stringArray[n2] + ";");
            } else {
                indentingWriter.pln("import " + stringArray[n2] + ";");
            }
            ++n2;
        }
        indentingWriter.pln();
        if (this.currentPackage != null && Util.isOffendingPackage(this.currentPackage)) {
            indentingWriter.pln("import " + this.currentPackage + ".*  ;");
        }
        indentingWriter.pln();
    }

    boolean implementsRemote(CompoundType compoundType) {
        boolean bl;
        boolean bl2 = bl = compoundType.isType(4096) && !compoundType.isType(8192);
        if (!bl) {
            InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
            int n = 0;
            while (n < interfaceTypeArray.length) {
                bl = this.implementsRemote(interfaceTypeArray[n]);
                if (bl) break;
                ++n;
            }
        }
        return bl;
    }

    void writeStubMethod(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        String string = method.getName();
        String string2 = method.getIDLName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        this.addNamesInUse(method);
        this.addNameInUse("_type_ids");
        indentingWriter.p("public " + this.getName(type) + " " + string + "(");
        int n = 0;
        while (n < typeArray.length) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(this.getName(typeArray[n]) + " " + stringArray[n]);
            ++n;
        }
        indentingWriter.p(")");
        if (valueTypeArray.length > 0) {
            indentingWriter.p(" throws ");
            int n2 = 0;
            while (n2 < valueTypeArray.length) {
                if (n2 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(this.getName(valueTypeArray[n2]));
                ++n2;
            }
        }
        indentingWriter.plnI(" {");
        if (this.localStubs) {
            this.writeLocalStubMethodBody(indentingWriter, method, compoundType);
        } else {
            this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        }
        indentingWriter.pOln("}");
    }

    void writeLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        String string = method.getName();
        String string2 = method.getIDLName();
        indentingWriter.plnI("if (!Util.isLocal(this)) {");
        this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        indentingWriter.pOlnI("} else {");
        String string3 = this.getVariableName("so");
        indentingWriter.pln("ServantObject " + string3 + " = _servant_preinvoke(\"" + string2 + "\"," + this.getName(compoundType) + ".class);");
        indentingWriter.plnI("if (" + string3 + " == null) {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string + "(");
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n]);
            ++n;
        }
        indentingWriter.pln(");");
        if (type.isType(1)) {
            indentingWriter.pln("return ;");
        }
        indentingWriter.pOln("}");
        indentingWriter.plnI("try {");
        String[] stringArray2 = this.writeCopyArguments(method, indentingWriter);
        boolean bl = StubGenerator.mustCopy(type);
        String string4 = null;
        if (!type.isType(1)) {
            if (bl) {
                string4 = this.getVariableName("result");
                indentingWriter.p(this.getName(type) + " " + string4 + " = ");
            } else {
                indentingWriter.p("return ");
            }
        }
        indentingWriter.p("((" + this.getName(compoundType) + ")" + string3 + ".servant)." + string + "(");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray2[n2]);
            ++n2;
        }
        if (bl) {
            indentingWriter.pln(");");
            indentingWriter.pln("return (" + this.getName(type) + ")Util.copyObject(" + string4 + ",_orb());");
        } else {
            indentingWriter.pln(");");
        }
        String string5 = this.getVariableName("ex");
        String string6 = this.getVariableName("exCopy");
        indentingWriter.pOlnI("} catch (Throwable " + string5 + ") {");
        indentingWriter.pln("Throwable " + string6 + " = (Throwable)Util.copyObject(" + string5 + ",_orb());");
        int n3 = 0;
        while (n3 < valueTypeArray.length) {
            if (valueTypeArray[n3].getIdentifier() != Constants.idRemoteException && valueTypeArray[n3].isType(32768)) {
                indentingWriter.plnI("if (" + string6 + " instanceof " + this.getName(valueTypeArray[n3]) + ") {");
                indentingWriter.pln("throw (" + this.getName(valueTypeArray[n3]) + ")" + string6 + ";");
                indentingWriter.pOln("}");
            }
            ++n3;
        }
        indentingWriter.pln("throw Util.wrapException(" + string6 + ");");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_servant_postinvoke(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    void writeNonLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        int n;
        String string = method.getName();
        String string2 = method.getIDLName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, true);
        String string3 = this.getVariableName("in");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("ex");
        boolean bl = false;
        int n2 = 0;
        while (n2 < valueTypeArray.length) {
            if (valueTypeArray[n2].getIdentifier() != Constants.idRemoteException && valueTypeArray[n2].isType(32768) && StubGenerator.needNewReadStreamClass(valueTypeArray[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            n = 0;
            while (n < typeArray.length) {
                if (StubGenerator.needNewReadStreamClass(typeArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            bl = StubGenerator.needNewReadStreamClass(type);
        }
        n = 0;
        int n3 = 0;
        while (n3 < typeArray.length) {
            if (StubGenerator.needNewWriteStreamClass(typeArray[n3])) {
                n = 1;
                break;
            }
            ++n3;
        }
        indentingWriter.plnI("try {");
        if (bl) {
            indentingWriter.pln(sun.rmi.rmic.iiop.Constants.idExtInputStream + " " + string3 + " = null;");
        } else {
            indentingWriter.pln(sun.rmi.rmic.iiop.Constants.idInputStream + " " + string3 + " = null;");
        }
        indentingWriter.plnI("try {");
        String string6 = "null";
        if (n != 0) {
            indentingWriter.plnI(sun.rmi.rmic.iiop.Constants.idExtOutputStream + " " + string4 + " = ");
            indentingWriter.pln("(" + sun.rmi.rmic.iiop.Constants.idExtOutputStream + ")");
            indentingWriter.pln("_request(\"" + string2 + "\", true);");
            indentingWriter.pO();
        } else {
            indentingWriter.pln("OutputStream " + string4 + " = _request(\"" + string2 + "\", true);");
        }
        if (typeArray.length > 0) {
            this.writeMarshalArguments(indentingWriter, string4, typeArray, stringArray);
            indentingWriter.pln();
        }
        string6 = string4;
        if (type.isType(1)) {
            indentingWriter.pln("_invoke(" + string6 + ");");
        } else {
            if (bl) {
                indentingWriter.plnI(string3 + " = (" + sun.rmi.rmic.iiop.Constants.idExtInputStream + ")_invoke(" + string6 + ");");
                indentingWriter.pO();
            } else {
                indentingWriter.pln(string3 + " = _invoke(" + string6 + ");");
            }
            indentingWriter.p("return ");
            this.writeUnmarshalArgument(indentingWriter, string3, type, null);
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("} catch (" + this.getName(sun.rmi.rmic.iiop.Constants.idApplicationException) + " " + string5 + ") {");
        if (bl) {
            indentingWriter.pln(string3 + " = (" + sun.rmi.rmic.iiop.Constants.idExtInputStream + ") " + string5 + ".getInputStream();");
        } else {
            indentingWriter.pln(string3 + " = " + string5 + ".getInputStream();");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < valueTypeArray.length) {
            if (valueTypeArray[n4].getIdentifier() != Constants.idRemoteException) {
                if (valueTypeArray[n4].isIDLEntityException() && !valueTypeArray[n4].isCORBAUserException()) {
                    if (!bl3 && !bl2) {
                        indentingWriter.pln("String id = " + string5 + ".getId();");
                        bl3 = true;
                    }
                    String string7 = IDLNames.replace(valueTypeArray[n4].getQualifiedIDLName(false), "::", ".");
                    string7 = string7 + "Helper";
                    indentingWriter.plnI("if (id.equals(" + string7 + ".id())) {");
                    indentingWriter.pln("throw " + string7 + ".read(" + string3 + ");");
                } else {
                    if (!bl3 && !bl2) {
                        indentingWriter.pln("String id = " + string3 + ".read_string();");
                        bl3 = true;
                        bl2 = true;
                    } else if (bl3 && !bl2) {
                        indentingWriter.pln("id = " + string3 + ".read_string();");
                        bl2 = true;
                    }
                    indentingWriter.plnI("if (id.equals(\"" + this.getExceptionRepositoryID(valueTypeArray[n4]) + "\")) {");
                    indentingWriter.pln("throw (" + this.getName(valueTypeArray[n4]) + ") " + string3 + ".read_value(" + this.getName(valueTypeArray[n4]) + ".class);");
                }
                indentingWriter.pOln("}");
            }
            ++n4;
        }
        if (!bl3 && !bl2) {
            indentingWriter.pln("String id = " + string3 + ".read_string();");
            bl3 = true;
            bl2 = true;
        } else if (bl3 && !bl2) {
            indentingWriter.pln("id = " + string3 + ".read_string();");
            bl2 = true;
        }
        indentingWriter.pln("throw new UnexpectedException(id);");
        indentingWriter.pOlnI("} catch (" + this.getName(sun.rmi.rmic.iiop.Constants.idRemarshalException) + " " + string5 + ") {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string + "(");
        int n5 = 0;
        while (n5 < typeArray.length) {
            if (n5 > 0) {
                indentingWriter.p(",");
            }
            indentingWriter.p(stringArray[n5]);
            ++n5;
        }
        indentingWriter.pln(");");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_releaseReply(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOlnI("} catch (SystemException " + string5 + ") {");
        indentingWriter.pln("throw Util.mapSystemException(" + string5 + ");");
        indentingWriter.pOln("}");
    }

    void allocateResult(IndentingWriter indentingWriter, Type type) throws IOException {
        if (!type.isType(1)) {
            indentingWriter.p(this.getName(type) + " result = ");
        }
    }

    int getTypeCode(Type type) {
        int n = type.getTypeCode();
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            n = 8192;
        }
        return n;
    }

    void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = this.getTypeCode(type);
        switch (n) {
            case 2: {
                indentingWriter.p(string + ".write_boolean(" + string2 + ");");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".write_octet(" + string2 + ");");
                break;
            }
            case 8: {
                indentingWriter.p(string + ".write_wchar(" + string2 + ");");
                break;
            }
            case 16: {
                indentingWriter.p(string + ".write_short(" + string2 + ");");
                break;
            }
            case 32: {
                indentingWriter.p(string + ".write_long(" + string2 + ");");
                break;
            }
            case 64: {
                indentingWriter.p(string + ".write_longlong(" + string2 + ");");
                break;
            }
            case 128: {
                indentingWriter.p(string + ".write_float(" + string2 + ");");
                break;
            }
            case 256: {
                indentingWriter.p(string + ".write_double(" + string2 + ");");
                break;
            }
            case 512: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                indentingWriter.p("Util.writeAny(" + string + "," + string2 + ");");
                break;
            }
            case 2048: {
                indentingWriter.p(string + ".write_Object(" + string2 + ");");
                break;
            }
            case 4096: {
                indentingWriter.p("Util.writeRemoteObject(" + string + "," + string2 + ");");
                break;
            }
            case 8192: {
                indentingWriter.p("Util.writeAbstractObject(" + string + "," + string2 + ");");
                break;
            }
            case 16384: {
                indentingWriter.p(string + ".write_value((Serializable)" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                indentingWriter.p(string + ".write_value((Serializable)" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                indentingWriter.p(string + ".write_value((Serializable)" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                this.castArray = true;
                indentingWriter.p(string + ".write_value(cast_array(" + string2 + ")," + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                indentingWriter.p("Util.writeRemoteObject(" + string + "," + string2 + ");");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    void writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = this.getTypeCode(type);
        if (string2 != null) {
            indentingWriter.p(string2 + " = ");
        }
        switch (n) {
            case 2: {
                indentingWriter.p(string + ".read_boolean();");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".read_octet();");
                break;
            }
            case 8: {
                indentingWriter.p(string + ".read_wchar();");
                break;
            }
            case 16: {
                indentingWriter.p(string + ".read_short();");
                break;
            }
            case 32: {
                indentingWriter.p(string + ".read_long();");
                break;
            }
            case 64: {
                indentingWriter.p(string + ".read_longlong();");
                break;
            }
            case 128: {
                indentingWriter.p(string + ".read_float();");
                break;
            }
            case 256: {
                indentingWriter.p(string + ".read_double();");
                break;
            }
            case 512: {
                indentingWriter.p("(String) " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                if (type.getIdentifier() != sun.tools.java.Constants.idJavaLangObject) {
                    indentingWriter.p("(" + this.getName(type) + ") ");
                }
                indentingWriter.p("Util.readAny(" + string + ");");
                break;
            }
            case 2048: {
                if (type.getIdentifier() == sun.rmi.rmic.iiop.Constants.idCorbaObject) {
                    indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object();");
                    break;
                }
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object(" + this.getStubName(type) + ".class);");
                break;
            }
            case 4096: {
                indentingWriter.p("(" + this.getName(type) + ") " + "PortableRemoteObject.narrow(" + string + ".read_Object(), " + this.getName(type) + ".class);");
                break;
            }
            case 8192: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_abstract_interface();");
                break;
            }
            case 16384: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                indentingWriter.p("(" + this.getName(type) + ") " + "PortableRemoteObject.narrow(" + string + ".read_Object(), " + this.getName(type) + ".class);");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    String[] getAllRemoteRepIDs(CompoundType compoundType) {
        int n;
        String[] stringArray;
        Type[] typeArray = this.collectAllRemoteInterfaces(compoundType);
        int n2 = typeArray.length;
        boolean bl = compoundType instanceof ImplementationType;
        Type[] typeArray2 = compoundType.getInterfaces();
        int n3 = this.countRemote(typeArray2, false);
        int n4 = 0;
        if (bl && n3 > 1) {
            stringArray = new String[n2 + 1];
            stringArray[0] = this.getRepositoryID(compoundType);
            n4 = 1;
        } else {
            stringArray = new String[n2];
            if (n2 > 1) {
                String string = null;
                if (bl) {
                    n = 0;
                    while (n < typeArray2.length) {
                        if (typeArray2[n].isType(4096)) {
                            string = typeArray2[n].getRepositoryID();
                            break;
                        }
                        ++n;
                    }
                } else {
                    string = compoundType.getRepositoryID();
                }
                n = 0;
                while (n < n2) {
                    if (typeArray[n].getRepositoryID() == string) {
                        if (n <= 0) break;
                        Type type = typeArray[0];
                        typeArray[0] = typeArray[n];
                        typeArray[n] = type;
                        break;
                    }
                    ++n;
                }
            }
        }
        int n5 = 0;
        while (n5 < typeArray.length) {
            stringArray[n4++] = this.getRepositoryID(typeArray[n5]);
            ++n5;
        }
        if (this.reverseIDs) {
            n = 0;
            int n6 = stringArray.length - 1;
            while (n < n6) {
                String string = stringArray[n];
                stringArray[n++] = stringArray[n6];
                stringArray[n6--] = string;
            }
        }
        return stringArray;
    }

    Type[] collectAllRemoteInterfaces(CompoundType compoundType) {
        Vector vector = new Vector();
        this.addRemoteInterfaces(vector, compoundType);
        Object[] objectArray = new Type[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void addRemoteInterfaces(Vector vector, CompoundType compoundType) {
        if (compoundType != null) {
            if (compoundType.isInterface() && !vector.contains(compoundType)) {
                vector.addElement(compoundType);
            }
            InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
            int n = 0;
            while (n < interfaceTypeArray.length) {
                if (interfaceTypeArray[n].isType(4096)) {
                    this.addRemoteInterfaces(vector, interfaceTypeArray[n]);
                }
                ++n;
            }
            this.addRemoteInterfaces(vector, compoundType.getSuperclass());
        }
    }

    RemoteType[] getDirectRemoteInterfaces(CompoundType compoundType) {
        Type[] typeArray = compoundType.getInterfaces();
        Type[] typeArray2 = compoundType instanceof ImplementationType ? typeArray : new InterfaceType[]{(InterfaceType)compoundType};
        int n = this.countRemote(typeArray2, false);
        if (n == 0) {
            throw new CompilerError("iiop.StubGenerator: No remote interfaces!");
        }
        RemoteType[] remoteTypeArray = new RemoteType[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < typeArray2.length) {
            if (typeArray2[n3].isType(4096)) {
                remoteTypeArray[n2++] = (RemoteType)typeArray2[n3];
            }
            ++n3;
        }
        return remoteTypeArray;
    }

    int countRemote(Type[] typeArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < typeArray.length) {
            if (typeArray[n2].isType(4096) && (bl || !typeArray[n2].isType(8192))) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    void writeCastArray(IndentingWriter indentingWriter) throws IOException {
        if (this.castArray) {
            indentingWriter.pln();
            indentingWriter.pln("// This method is required as a work-around for");
            indentingWriter.pln("// a bug in the JDK 1.1.6 verifier.");
            indentingWriter.pln();
            indentingWriter.plnI("private " + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + " cast_array(Object obj) {");
            indentingWriter.pln("return (" + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + ")obj;");
            indentingWriter.pOln("}");
        }
    }

    void writeIds(IndentingWriter indentingWriter, CompoundType compoundType, boolean bl) throws IOException {
        boolean bl2;
        indentingWriter.plnI("private static final String[] _type_ids = {");
        String[] stringArray = this.getAllRemoteRepIDs(compoundType);
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    indentingWriter.pln(", ");
                }
                indentingWriter.p("\"" + stringArray[n] + "\"");
                ++n;
            }
        } else {
            indentingWriter.pln("\"\"");
        }
        String string = compoundType.getQualifiedName();
        boolean bl3 = bl2 = bl && this.transactionalObjects.containsKey(string);
        if (bl2) {
            indentingWriter.pln(", ");
            indentingWriter.pln("\"IDL:omg.org/CosTransactions/TransactionalObject:1.0\"");
        } else if (stringArray.length > 0) {
            indentingWriter.pln();
        }
        indentingWriter.pOln("};");
    }

    protected void writeTie(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        RemoteType[] remoteTypeArray = null;
        indentingWriter.pln("// Tie class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        this.setStandardClassesInUse(compoundType, false);
        this.addClassesInUse(compoundType, remoteTypeArray);
        this.writePackageAndImports(indentingWriter);
        indentingWriter.p("public class " + this.currentClass + " extends " + this.getName(this.tieBaseClass) + " implements Tie");
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName("java.rmi.Remote"));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        indentingWriter.pln("private " + this.getName(compoundType) + " target = null;");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType, true);
        indentingWriter.pln();
        indentingWriter.plnI("public void setTarget(Remote target) {");
        indentingWriter.pln("this.target = (" + this.getName(compoundType) + ") target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public Remote getTarget() {");
        indentingWriter.pln("return target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        this.write_tie_thisObject_method(indentingWriter, sun.rmi.rmic.iiop.Constants.idCorbaObject);
        indentingWriter.pln();
        this.write_tie_deactivate_method(indentingWriter);
        indentingWriter.pln();
        indentingWriter.plnI("public ORB orb() {");
        indentingWriter.pln("return _orb();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        this.write_tie_orb_method(indentingWriter);
        indentingWriter.pln();
        this.write_tie__ids_method(indentingWriter);
        CompoundType.Method[] methodArray = compoundType.getMethods();
        this.addNamesInUse(methodArray);
        this.addNameInUse("target");
        this.addNameInUse("_type_ids");
        indentingWriter.pln();
        String string = this.getVariableName("in");
        String string2 = this.getVariableName("_in");
        String string3 = this.getVariableName("ex");
        String string4 = this.getVariableName("method");
        String string5 = this.getVariableName("reply");
        indentingWriter.plnI("public OutputStream  _invoke(String " + string4 + ", InputStream " + string2 + ", " + "ResponseHandler " + string5 + ") throws SystemException {");
        if (methodArray.length > 0) {
            indentingWriter.plnI("try {");
            indentingWriter.plnI(sun.rmi.rmic.iiop.Constants.idExtInputStream + " " + string + " = ");
            indentingWriter.pln("(" + sun.rmi.rmic.iiop.Constants.idExtInputStream + ") " + string2 + ";");
            indentingWriter.pO();
            StaticStringsHash staticStringsHash = this.getStringsHash(methodArray);
            if (staticStringsHash != null) {
                indentingWriter.plnI("switch (" + string4 + "." + staticStringsHash.method + ") {");
                int n = 0;
                while (n < staticStringsHash.buckets.length) {
                    indentingWriter.plnI("case " + staticStringsHash.keys[n] + ": ");
                    int n2 = 0;
                    while (n2 < staticStringsHash.buckets[n].length) {
                        CompoundType.Method method = methodArray[staticStringsHash.buckets[n][n2]];
                        if (n2 > 0) {
                            indentingWriter.pO("} else ");
                        }
                        indentingWriter.plnI("if (" + string4 + ".equals(\"" + method.getIDLName() + "\")) {");
                        this.writeTieMethod(indentingWriter, compoundType, method);
                        ++n2;
                    }
                    indentingWriter.pOln("}");
                    indentingWriter.pO();
                    ++n;
                }
            } else {
                int n = 0;
                while (n < methodArray.length) {
                    CompoundType.Method method = methodArray[n];
                    if (n > 0) {
                        indentingWriter.pO("} else ");
                    }
                    indentingWriter.plnI("if (" + string4 + ".equals(\"" + method.getIDLName() + "\")) {");
                    this.writeTieMethod(indentingWriter, compoundType, method);
                    ++n;
                }
            }
            if (staticStringsHash != null) {
                indentingWriter.pI();
            }
            if (staticStringsHash != null) {
                indentingWriter.pO();
            }
            indentingWriter.pOln("}");
            indentingWriter.pln("throw new " + this.getName(sun.rmi.rmic.iiop.Constants.idBadMethodException) + "();");
            indentingWriter.pOlnI("} catch (" + this.getName(sun.rmi.rmic.iiop.Constants.idSystemException) + " " + string3 + ") {");
            indentingWriter.pln("throw " + string3 + ";");
            indentingWriter.pOlnI("} catch (" + this.getName(sun.tools.java.Constants.idJavaLangThrowable) + " " + string3 + ") {");
            indentingWriter.pln("throw new " + this.getName(sun.rmi.rmic.iiop.Constants.idPortableUnknownException) + "(" + string3 + ");");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("throw new " + this.getName(sun.rmi.rmic.iiop.Constants.idBadMethodException) + "();");
        }
        indentingWriter.pOln("}");
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    public void catchWrongPolicy(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("");
    }

    public void catchServantNotActive(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("");
    }

    public void catchObjectNotActive(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("");
    }

    public void write_tie_thisObject_method(IndentingWriter indentingWriter, Identifier identifier) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public " + identifier + " thisObject() {");
            indentingWriter.pln("return _this_object();");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public " + identifier + " thisObject() {");
            indentingWriter.pln("return this;");
            indentingWriter.pOln("}");
        }
    }

    public void write_tie_deactivate_method(IndentingWriter indentingWriter) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public void deactivate() {");
            indentingWriter.pln("try{");
            indentingWriter.pln("_poa().deactivate_object(_poa().servant_to_id(this));");
            indentingWriter.pln("}catch (org.omg.PortableServer.POAPackage.WrongPolicy exception){");
            this.catchWrongPolicy(indentingWriter);
            indentingWriter.pln("}catch (org.omg.PortableServer.POAPackage.ObjectNotActive exception){");
            this.catchObjectNotActive(indentingWriter);
            indentingWriter.pln("}catch (org.omg.PortableServer.POAPackage.ServantNotActive exception){");
            this.catchServantNotActive(indentingWriter);
            indentingWriter.pln("}");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public void deactivate() {");
            indentingWriter.pln("_orb().disconnect(this);");
            indentingWriter.pln("_set_delegate(null);");
            indentingWriter.pln("target = null;");
            indentingWriter.pOln("}");
        }
    }

    public void write_tie_orb_method(IndentingWriter indentingWriter) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public void orb(ORB orb) {");
            indentingWriter.pln("try {");
            indentingWriter.pln("    ((org.omg.CORBA_2_3.ORB)orb).set_delegate(this);");
            indentingWriter.pln("}");
            indentingWriter.pln("catch(ClassCastException e) {");
            indentingWriter.pln("    throw new org.omg.CORBA.BAD_PARAM");
            indentingWriter.pln("        (\"POA Servant requires an instance of org.omg.CORBA_2_3.ORB\");");
            indentingWriter.pln("}");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public void orb(ORB orb) {");
            indentingWriter.pln("orb.connect(this);");
            indentingWriter.pOln("}");
        }
    }

    public void write_tie__ids_method(IndentingWriter indentingWriter) throws IOException {
        if (this.POATie) {
            indentingWriter.plnI("public String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] objectId){");
            indentingWriter.pln("return _type_ids;");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.plnI("public String[] _ids() { ");
            indentingWriter.pln("return _type_ids;");
            indentingWriter.pOln("}");
        }
    }

    StaticStringsHash getStringsHash(CompoundType.Method[] methodArray) {
        if (this.useHash && methodArray.length > 1) {
            String[] stringArray = new String[methodArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = methodArray[n].getIDLName();
                ++n;
            }
            return new StaticStringsHash(stringArray);
        }
        return null;
    }

    static boolean needNewReadStreamClass(Type type) {
        if (type.isType(8192)) {
            return true;
        }
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            return true;
        }
        return StubGenerator.needNewWriteStreamClass(type);
    }

    static boolean needNewWriteStreamClass(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                return false;
            }
            case 512: {
                return true;
            }
            case 1024: {
                return false;
            }
            case 2048: {
                return false;
            }
            case 4096: {
                return false;
            }
            case 8192: {
                return false;
            }
            case 16384: {
                return true;
            }
            case 32768: {
                return true;
            }
            case 65536: {
                return true;
            }
            case 131072: {
                return true;
            }
            case 262144: {
                return true;
            }
            case 524288: {
                return false;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    String[] writeCopyArguments(CompoundType.Method method, IndentingWriter indentingWriter) throws IOException {
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        boolean bl = false;
        boolean[] blArray = new boolean[typeArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < typeArray.length) {
            if (StubGenerator.mustCopy(typeArray[n4])) {
                blArray[n4] = true;
                ++n2;
                n3 = n4;
                if (typeArray[n4].getTypeCode() != 4096 && typeArray[n4].getTypeCode() != 65536) {
                    bl = true;
                }
            } else {
                blArray[n4] = false;
            }
            ++n4;
        }
        if (n2 > 0) {
            if (bl) {
                int n5 = 0;
                while (n5 < typeArray.length) {
                    if (typeArray[n5].getTypeCode() == 512) {
                        blArray[n5] = true;
                        ++n2;
                    }
                    ++n5;
                }
            }
            if (n2 > 1) {
                String string = this.getVariableName("copies");
                indentingWriter.p("Object[] " + string + " = Util.copyObjects(new Object[]{");
                boolean bl2 = true;
                int n6 = 0;
                while (n6 < typeArray.length) {
                    if (blArray[n6]) {
                        if (!bl2) {
                            indentingWriter.p(",");
                        }
                        bl2 = false;
                        indentingWriter.p(stringArray[n6]);
                    }
                    ++n6;
                }
                indentingWriter.pln("},_orb());");
                int n7 = 0;
                int n8 = 0;
                while (n8 < typeArray.length) {
                    if (blArray[n8]) {
                        stringArray2[n8] = this.getVariableName(stringArray2[n8] + "Copy");
                        indentingWriter.pln(this.getName(typeArray[n8]) + " " + stringArray2[n8] + " = (" + this.getName(typeArray[n8]) + ") " + string + "[" + n7++ + "];");
                    }
                    ++n8;
                }
            } else {
                stringArray2[n3] = this.getVariableName(stringArray2[n3] + "Copy");
                indentingWriter.pln(this.getName(typeArray[n3]) + " " + stringArray2[n3] + " = (" + this.getName(typeArray[n3]) + ") Util.copyObject(" + stringArray[n3] + ",_orb());");
            }
        }
        return stringArray2;
    }

    String getRepositoryID(Type type) {
        return IDLNames.replace(type.getRepositoryID(), SINGLE_SLASH, DOUBLE_SLASH);
    }

    String getExceptionRepositoryID(Type type) {
        ClassType classType = (ClassType)type;
        return IDLNames.getIDLRepositoryID(classType.getQualifiedIDLExceptionName(false));
    }

    String getVariableName(String string) {
        while (this.namesInUse.contains(string)) {
            string = "$" + string;
        }
        return string;
    }

    void addNamesInUse(CompoundType.Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            this.addNamesInUse(methodArray[n]);
            ++n;
        }
    }

    void addNamesInUse(CompoundType.Method method) {
        String[] stringArray = method.getArgumentNames();
        int n = 0;
        while (n < stringArray.length) {
            this.addNameInUse(stringArray[n]);
            ++n;
        }
    }

    void addNameInUse(String string) {
        this.namesInUse.add(string);
    }

    static boolean mustCopy(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                return false;
            }
            case 1024: {
                return true;
            }
            case 2048: {
                return false;
            }
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: {
                return true;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    ValueType[] getStubExceptions(CompoundType.Method method, boolean bl) {
        ValueType[] valueTypeArray = method.getFilteredStubExceptions(method.getExceptions());
        if (bl) {
            Arrays.sort(valueTypeArray, new UserExceptionComparator());
        }
        return valueTypeArray;
    }

    ValueType[] getTieExceptions(CompoundType.Method method) {
        return method.getUniqueCatchList(method.getImplExceptions());
    }

    void writeTieMethod(IndentingWriter indentingWriter, CompoundType compoundType, CompoundType.Method method) throws IOException {
        boolean bl;
        String string = method.getName();
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getTieExceptions(method);
        String string2 = this.getVariableName("in");
        String string3 = this.getVariableName("ex");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("reply");
        int n = 0;
        while (n < typeArray.length) {
            indentingWriter.p(this.getName(typeArray[n]) + " " + stringArray[n] + " = ");
            this.writeUnmarshalArgument(indentingWriter, string2, typeArray[n], null);
            indentingWriter.pln();
            ++n;
        }
        boolean bl2 = valueTypeArray != null;
        boolean bl3 = bl = !type.isType(1);
        if (bl2 && bl) {
            indentingWriter.pln(this.getName(type) + " result;");
        }
        if (bl2) {
            indentingWriter.plnI("try {");
        }
        if (bl) {
            if (bl2) {
                indentingWriter.p("result = ");
            } else {
                indentingWriter.p(this.getName(type) + " result = ");
            }
        }
        indentingWriter.p("target." + string + "(");
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n2]);
            ++n2;
        }
        indentingWriter.pln(");");
        if (bl2) {
            int n3 = 0;
            while (n3 < valueTypeArray.length) {
                indentingWriter.pOlnI("} catch (" + this.getName(valueTypeArray[n3]) + " " + string3 + ") {");
                if (valueTypeArray[n3].isIDLEntityException() && !valueTypeArray[n3].isCORBAUserException()) {
                    String string6 = IDLNames.replace(valueTypeArray[n3].getQualifiedIDLName(false), "::", ".");
                    string6 = string6 + "Helper";
                    indentingWriter.pln(sun.rmi.rmic.iiop.Constants.idOutputStream + " " + string4 + " = " + string5 + ".createExceptionReply();");
                    indentingWriter.pln(string6 + ".write(" + string4 + "," + string3 + ");");
                } else {
                    indentingWriter.pln("String id = \"" + this.getExceptionRepositoryID(valueTypeArray[n3]) + "\";");
                    indentingWriter.plnI(sun.rmi.rmic.iiop.Constants.idExtOutputStream + " " + string4 + " = ");
                    indentingWriter.pln("(" + sun.rmi.rmic.iiop.Constants.idExtOutputStream + ") " + string5 + ".createExceptionReply();");
                    indentingWriter.pOln(string4 + ".write_string(id);");
                    indentingWriter.pln(string4 + ".write_value(" + string3 + "," + this.getName(valueTypeArray[n3]) + ".class);");
                }
                indentingWriter.pln("return " + string4 + ";");
                ++n3;
            }
            indentingWriter.pOln("}");
        }
        if (StubGenerator.needNewWriteStreamClass(type)) {
            indentingWriter.plnI(sun.rmi.rmic.iiop.Constants.idExtOutputStream + " " + string4 + " = ");
            indentingWriter.pln("(" + sun.rmi.rmic.iiop.Constants.idExtOutputStream + ") " + string5 + ".createReply();");
            indentingWriter.pO();
        } else {
            indentingWriter.pln("OutputStream " + string4 + " = " + string5 + ".createReply();");
        }
        if (bl) {
            this.writeMarshalArgument(indentingWriter, string4, type, "result");
            indentingWriter.pln();
        }
        indentingWriter.pln("return " + string4 + ";");
    }

    void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        int n = 0;
        while (n < typeArray.length) {
            this.writeMarshalArgument(indentingWriter, string, typeArray[n], stringArray[n]);
            if (n != typeArray.length - 1) {
                indentingWriter.pln();
            }
            ++n;
        }
    }
}

