/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.native2ascii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.io.CharToByteConverter;
import sun.io.Converters;
import sun.tools.native2ascii.A2NFilter;
import sun.tools.native2ascii.N2AFilter;

public class Main {
    String inputFileName = null;
    String outputFileName = null;
    File tempFile = null;
    boolean reverse = false;
    static String encodingString = null;
    static String defaultEncoding = null;
    static CharToByteConverter ctb = null;
    static CharsetEncoder encoder = null;
    private static ResourceBundle rsrc;

    private void rename(File file, String string) throws Exception {
        File file2;
        if (file != null && string != null && ((file2 = new File(string)).exists() && !file2.canWrite() || !file.renameTo(file2))) {
            throw new Exception(this.formatMsg("err.cannot.write", string));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean convert(String[] stringArray) {
        Vector<String> vector = new Vector<String>(2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-encoding")) {
                if (n + 1 >= stringArray.length) {
                    this.error(this.getMsg("err.bad.arg"));
                    this.usage();
                    return false;
                }
                encodingString = stringArray[++n];
            } else if (stringArray[n].equals("-reverse")) {
                this.reverse = true;
            } else {
                if (vector.size() > 1) {
                    this.usage();
                    return false;
                }
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        if (encodingString == null) {
            defaultEncoding = Converters.getDefaultEncodingName();
        }
        char[] cArray = System.getProperty("line.separator").toCharArray();
        try {
            Main.initializeConverter();
            if (vector.size() == 1) {
                this.inputFileName = (String)vector.elementAt(0);
            }
            if (vector.size() == 2) {
                this.inputFileName = (String)vector.elementAt(0);
                this.outputFileName = (String)vector.elementAt(1);
            }
            if (this.reverse) {
                try {
                    BufferedReader bufferedReader = this.getA2NInput(this.inputFileName);
                    Writer writer = this.getA2NOutput(this.outputFileName);
                    while (true) {
                        String string;
                        if ((string = bufferedReader.readLine()) == null) {
                            bufferedReader.close();
                            writer.close();
                            this.rename(this.tempFile, this.outputFileName);
                            return true;
                        }
                        writer.write(string.toCharArray());
                        writer.write(cArray);
                        if (this.outputFileName != null) continue;
                        writer.flush();
                    }
                }
                catch (IOException iOException) {
                    this.error(iOException.toString());
                    return false;
                }
            }
            BufferedReader bufferedReader = this.getN2AInput(this.inputFileName);
            BufferedWriter bufferedWriter = this.getN2AOutput(this.outputFileName);
            while (true) {
                String string;
                if ((string = bufferedReader.readLine()) == null) {
                    bufferedWriter.close();
                    this.rename(this.tempFile, this.outputFileName);
                    return true;
                }
                bufferedWriter.write(string.toCharArray());
                bufferedWriter.write(cArray);
                if (this.outputFileName != null) continue;
                bufferedWriter.flush();
            }
        }
        catch (Exception exception) {
            this.error(exception.toString());
            return false;
        }
    }

    private void error(String string) {
        System.out.println(string);
    }

    private void usage() {
        System.out.println(this.getMsg("usage"));
    }

    private BufferedReader getN2AInput(String string) throws Exception {
        Object object;
        InputStream inputStream;
        if (string == null) {
            inputStream = System.in;
        } else {
            object = new File(string);
            if (!((File)object).canRead()) {
                throw new Exception(this.formatMsg("err.cannot.read", ((File)object).getName()));
            }
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                throw new Exception(this.formatMsg("err.cannot.read", ((File)object).getName()));
            }
        }
        object = encodingString != null ? new BufferedReader(new InputStreamReader(inputStream, encodingString)) : new BufferedReader(new InputStreamReader(inputStream));
        return object;
    }

    private BufferedWriter getN2AOutput(String string) throws Exception {
        OutputStreamWriter outputStreamWriter;
        if (string == null) {
            outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, "US-ASCII");
        } else {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(System.getProperty("user.dir"));
            }
            this.tempFile = File.createTempFile("_N2A", ".TMP", file2);
            this.tempFile.deleteOnExit();
            try {
                outputStreamWriter = new FileWriter(this.tempFile);
            }
            catch (IOException iOException) {
                throw new Exception(this.formatMsg("err.cannot.write", this.tempFile.getName()));
            }
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new N2AFilter(outputStreamWriter));
        return bufferedWriter;
    }

    private BufferedReader getA2NInput(String string) throws Exception {
        InputStreamReader inputStreamReader;
        if (string == null) {
            inputStreamReader = new InputStreamReader(System.in, "US-ASCII");
        } else {
            File file = new File(string);
            if (!file.canRead()) {
                throw new Exception(this.formatMsg("err.cannot.read", file.getName()));
            }
            try {
                inputStreamReader = new FileReader(string);
            }
            catch (Exception exception) {
                throw new Exception(this.formatMsg("err.cannot.read", file.getName()));
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new A2NFilter(inputStreamReader));
        return bufferedReader;
    }

    private Writer getA2NOutput(String string) throws Exception {
        OutputStreamWriter outputStreamWriter = null;
        OutputStream outputStream = null;
        if (string == null) {
            outputStream = System.out;
        } else {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(System.getProperty("user.dir"));
            }
            this.tempFile = File.createTempFile("_N2A", ".TMP", file2);
            this.tempFile.deleteOnExit();
            try {
                outputStream = new FileOutputStream(this.tempFile);
            }
            catch (IOException iOException) {
                throw new Exception(this.formatMsg("err.cannot.write", this.tempFile.getName()));
            }
        }
        outputStreamWriter = encodingString != null ? new OutputStreamWriter(outputStream, encodingString) : new OutputStreamWriter(outputStream);
        return outputStreamWriter;
    }

    private static Charset lookupCharset(String string) {
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Error(unsupportedCharsetException);
            }
        }
        return null;
    }

    public static boolean canConvert(char c) {
        if (encoder != null) {
            return encoder.canEncode(c);
        }
        return ctb.canConvert(c);
    }

    private static void initializeConverter() throws UnsupportedEncodingException {
        Charset charset = null;
        try {
            charset = encodingString == null ? Main.lookupCharset(defaultEncoding) : Main.lookupCharset(encodingString);
            encoder = charset != null ? charset.newEncoder() : null;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        if (charset == null) {
            ctb = encodingString != null ? CharToByteConverter.getConverter((String)encodingString) : CharToByteConverter.getConverter((String)defaultEncoding);
        }
    }

    private String getMsg(String string) {
        try {
            return rsrc.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Error in  message file format.");
        }
    }

    private String formatMsg(String string, String string2) {
        String string3 = this.getMsg(string);
        Object[] objectArray = new String[]{string2};
        return MessageFormat.format(string3, objectArray);
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        System.exit(main.convert(stringArray) ? 0 : 1);
    }

    static {
        try {
            rsrc = ResourceBundle.getBundle("sun.tools.native2ascii.resources.MsgNative2ascii");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Missing message file.");
        }
    }
}

