/*
 * Decompiled with CFR 0.152.
 */
import JSim.mml.MathSys;
import JSim.mml.Var;
import JSim.plan.Calc;
import JSim.plan.DomainCalc;
import JSim.plan.ExprCalc;
import JSim.plan.FuncCalc;
import JSim.plan.FzeroProc;
import JSim.plan.IfCalc;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.ODEProc;
import JSim.plan.PDEProc;
import JSim.plan.PlanIF;
import JSim.plan.PlanWriter;
import JSim.plan.Proc;
import JSim.plan.ProcCalc;
import JSim.plan.RelationCalc;
import JSim.plan.SetCalc;
import JSim.plan.TopProc;
import JSim.util.Context;
import JSim.util.Xcept;

public class MyPlanWriter
extends PlanWriter {
    protected MathSys math;
    private MyContext ctxt;

    public MyPlanWriter(PlanIF p) {
        super(p, MyLang.lang);
        this.math = this.plan.math();
        this.ctxt = new MyContext(this);
    }

    public void write() throws Xcept {
        int i;
        this.indent = 0;
        for (i = 0; i < this.math.nVar(); ++i) {
            Var v = this.math.var(i);
            this.println("double " + v.toString((Context)this.ctxt) + ";");
        }
        this.write(this.plan.mainProc());
        for (i = 0; i < this.plan.procs().size(); ++i) {
            Proc p = this.plan.procs().proc(i);
            if (p instanceof TopProc) {
                this.write((TopProc)p);
            } else if (p instanceof ODEProc) {
                this.write((ODEProc)p);
            } else {
                this.println("// unsupported class " + p.getClass());
            }
            this.println("");
        }
    }

    public void write(TopProc p) throws Xcept {
        this.println("void mainline() {");
        ++this.indent;
        this.writeCalc((Calc)p.mcalc);
        --this.indent;
        this.println("}");
    }

    public void write(FzeroProc p) throws Xcept {
        this.println("// write(FzeroProc) not implemented");
    }

    public void write(ODEProc p) throws Xcept {
        this.println("void function_" + p.hashCode() + "() {");
        ++this.indent;
        this.write(p.calc);
        --this.indent;
        this.println("}");
    }

    public void write(PDEProc p) throws Xcept {
        this.println("// write(PDEProc) not implemented");
    }

    public void write(ExprCalc calc) throws Xcept {
        this.println(calc.v.toString((Context)this.ctxt) + "=" + calc.expr.toString((Context)this.ctxt) + ";");
    }

    public void write(DomainCalc calc) throws Xcept {
        this.println("// write(DomainCalc) not implemented");
    }

    public void write(FuncCalc calc) throws Xcept {
        this.println("// write(FuncCalc) not implemented");
    }

    public void write(LoopCalc calc) throws Xcept {
        String x = calc.x.toString((Context)this.ctxt);
        this.println("for (" + x + "=min; " + x + "<=max; " + x + "+=delta) {");
        ++this.indent;
        this.write(calc.loop);
        --this.indent;
        this.println("}");
    }

    public void write(IfCalc calc) throws Xcept {
        this.println("// write(IfCalc) not implemented");
    }

    public void write(SetCalc calc) throws Xcept {
        this.println("// write(SetCalc) not implemented");
    }

    public void write(MultiCalc calc) throws Xcept {
        for (int i = 0; i < calc.calc.size(); ++i) {
            Calc c = (Calc)calc.calc.get(i);
            this.writeCalc(c);
        }
    }

    public void write(ProcCalc calc) throws Xcept {
        this.println("CALL_SOLVER(function_" + calc.proc.hashCode() + ");");
    }

    public void write(RelationCalc calc) throws Xcept {
        this.println("// write(RelationCalc) not implemented");
    }
}

