/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.BComp;
import JSim.bcl.btex.Chem;
import JSim.bcl.btex.Time;
import JSim.mml.Comp;
import JSim.mml.Model;
import JSim.mml.Sys;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;
import java.io.PrintStream;

public class BSys
extends Sys {
    Time t;
    Chem.List chem = new Chem.List(4);
    Expr.List tlist = null;

    public BSys(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
    }

    public Expr.List tlist() throws Xcept {
        if (this.tlist == null) {
            this.tlist = new Expr.List(1);
            this.tlist.add((Object)this.t);
        }
        return this.tlist;
    }

    public void assignUnits() throws Xcept {
        Model model = this.getModel();
        if (model.unitControl == 1) {
            throw new Xcept((DiagInfo)this, "BTex system does not support <unit conversion off>");
        }
        if (model.unitControl == 2) {
            Comp c;
            int i;
            Unit tunit = model.parseUnit("second");
            if (this.t.unit() == null || !Unit.compatible((Unit)this.t.unit(), (Unit)tunit)) {
                throw new Xcept((DiagInfo)this.t, "Time component unit must be compatible with seconds");
            }
            for (i = 0; i < this.chem.size(); ++i) {
                c = this.chem.comp(i);
                ((BComp)c).assignUnits();
            }
            for (i = 0; i < this.child.size(); ++i) {
                c = this.child.comp(i);
                if (!BComp.class.isInstance((Object)c)) continue;
                ((BComp)c).assignUnits();
            }
        }
    }

    public void writeFlat(PrintStream out, Context ctxt) throws Xcept {
        Comp c;
        int i;
        this.expandChildDerivs();
        for (i = 0; i < this.child.size(); ++i) {
            c = (Comp)((Object)this.child.get(i));
            if (c.isVar()) continue;
            if (!BComp.class.isInstance((Object)c)) {
                throw new Xcept((DiagInfo)c, "Illegal BTEX component");
            }
            ((BComp)c).solve1();
        }
        for (i = 0; i < this.child.size(); ++i) {
            c = (Comp)((Object)this.child.get(i));
            if (c.isVar()) continue;
            ((BComp)c).solve2();
        }
        out.println("math " + this.name() + " {");
        super.writeFlat(out, ctxt);
        out.println("}");
    }
}

