/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.ChemEqn;
import JSim.bcl.mfax.MFSys;
import JSim.bcl.mfax.Reaction;
import JSim.bcl.mfax.ReactionFast;
import JSim.bcl.mfax.Region;
import JSim.mml.Eqn;
import JSim.mml.RealNVar;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.util.ConstExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IfExpr;
import JSim.util.LogicalExpr;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.ArrayList;

class FastGroup
implements DiagInfo {
    MFSys sys;
    Region region;
    Reaction.List reac;
    Chem.List chem;
    boolean[] clamp;
    Var.List concF;
    Var[] concZ;
    Var[] concDTX;
    Var concDir;
    boolean ENABLE_DIRECT = true;

    public FastGroup(Region reg, ReactionFast r) throws Xcept {
        this.region = reg;
        this.sys = this.region.sys;
        this.region.fastGroups.add(this);
        this.region.fastChem.addUniq(r.eqn.chem);
        this.reac = new Reaction.List(4);
        this.chem = new Chem.List(4);
        this.add(r);
    }

    public void add(ReactionFast r) throws Xcept {
        this.reac.add((Object)r);
        this.chem.addUniq(r.eqn.chem);
    }

    public void solve2() throws Xcept {
        Util.verbose((String)("== Solving FastGroup " + (Object)((Object)this.chem)));
        this.concF = new Var.List(this.reac.size());
        this.concZ = new Var[this.reac.size()];
        for (int i = 0; i < this.reac.size(); ++i) {
            ReactionFast r = (ReactionFast)this.reac.reac(i);
            RealNVar F = new RealNVar(r, "concF", this.sys.tlist());
            F.setAccess(2);
            Unit u = this.chem.chem(0).unit().div(r.timeUnit());
            F.setUnit(u);
            this.concF.add((Object)F);
            if (r.eqn.rtot() == 1.0 && r.eqn.rchem.size() == 1 || r.eqn.ltot() == 1.0 && r.eqn.lchem.size() == 1) continue;
            this.concZ[i] = new RealNVar(this.region, r.name() + "concZ", this.sys.tlist());
            this.concZ[i].setAccess(2);
            ConstExpr ztest = Expr.truex;
            for (int j = 0; j < r.eqn.chem.size(); ++j) {
                Chem c = r.eqn.chem.chem(j);
                ztest = new LogicalExpr(51, (Expr)ztest, this.region.conc(c).eq((Expr)Expr.zero));
            }
            IfExpr zrhs = new IfExpr((Expr)ztest, (Expr)Expr.cons((double)1.0E-30), (Expr)Expr.zero);
            this.region.setVar(this.concZ[i], (Expr)zrhs, true);
        }
        this.concDTX = new Var[this.chem.size()];
        this.clamp = new boolean[this.chem.size()];
        int deCount = 0;
        int icCount = 0;
        int clampCount = 0;
        for (int i = 0; i < this.chem.size(); ++i) {
            Var e;
            boolean concDE;
            Chem c = this.chem.chem(i);
            RealNVar v = this.region.conc(c);
            Var vt = v.deriv(this.sys.t);
            boolean vclamp = this.region.varSet(SubDom.entire(), v);
            boolean vtclamp = this.region.varSet(SubDom.entire(), vt);
            boolean vicclamp = this.region.varSet(this.sys.t.lhbc(), v);
            boolean bl = this.clamp[i] = vclamp || vtclamp;
            if (vclamp) {
                concDE = false;
            } else if (vtclamp || vicclamp) {
                concDE = true;
            } else if (this.concDir == null) {
                concDE = !this.ENABLE_DIRECT;
                this.concDir = v;
            } else {
                concDE = true;
            }
            if (vclamp || vtclamp) {
                ++clampCount;
            }
            if (vicclamp) {
                ++icCount;
            }
            if (concDE) {
                ++deCount;
            }
            Util.verbose((String)("Status flags " + (Object)((Object)v) + " " + vclamp + " " + vtclamp + " " + vicclamp + " " + concDE + " " + icCount + " " + deCount));
            Var var = e = this.clamp[i] ? vt : this.region.slowDelta(c);
            if (!e.sameAs((Expr)Expr.zero)) {
                RealNVar vtx = new RealNVar(this.region, c.name() + "concDTX", this.sys.tlist());
                vtx.setAccess(2);
                Unit u = c.unit().div(c.timeUnit());
                vtx.setUnit(u);
                this.concDTX[i] = vtx;
                this.region.setVar(vtx, (Expr)e, true);
            }
            if (concDE) {
                if (v != this.concDir) {
                    this.region.setVar(this.sys.t.lhbc(), v, (Expr)Expr.zero, false);
                }
                e = this.concDTExpr(c);
                this.region.setVar(v.deriv(this.sys.t), (Expr)e, false);
            }
            if (v != this.concDir) continue;
            ConstExpr sd = concDE ? this.sys.t.lhbExpr() : Expr.truex;
            Expr vx = this.concDirEqn(c);
            Eqn.create(this.sys, (Expr)sd, vx, null);
        }
        int df = this.chem.size() - this.reac.size();
        boolean err = df <= 0;
        err = err || (df -= clampCount) < 0;
        String dfmsg = "Reaction group overspecified: #reactions=" + this.reac.size() + "  #forced conc=" + clampCount;
        if (err) {
            throw new Xcept((DiagInfo)this, dfmsg);
        }
        Util.verbose((String)dfmsg);
        int ct = deCount;
        if (!this.ENABLE_DIRECT) {
            --ct;
        }
        if (icCount > 0 && icCount != ct) {
            throw new Xcept((DiagInfo)this, "Must have 0 or " + ct + " ICs, " + icCount + " found");
        }
        for (int i = 0; i < this.reac.size(); ++i) {
            ReactionFast r = (ReactionFast)this.reac.reac(i);
            Expr lhs = r.k.mult(this.linX(r.eqn, true));
            Expr rhs = this.linX(r.eqn, false);
            if (this.concZ[i] != null) {
                rhs = rhs.add(this.concZ[i].mult((Expr)this.concF.var(i)));
            }
            Eqn eqn = new Eqn(this.sys, (Expr)Expr.truex, lhs, 41, rhs);
        }
    }

    public Expr concDirEqn(Chem c) throws Xcept {
        RealNVar v = this.region.conc(c);
        ReactionFast r = null;
        for (int i = 0; i < this.reac.size(); ++i) {
            if (this.reac.reac((int)i).eqn.factor(c) == 0.0) continue;
            r = (ReactionFast)this.reac.reac(i);
            break;
        }
        if (r == null) {
            throw new Xcept((DiagInfo)this, "JSIM internal error - fast reac for chem not found");
        }
        double nc = r.eqn.factor(c);
        Expr lhs = r.k.pow(1.0 / nc);
        ConstExpr rhs = Expr.one;
        for (int i = 0; i < r.eqn.chem.size(); ++i) {
            Chem c1 = r.eqn.chem.chem(i);
            RealNVar v1 = this.region.conc(c1);
            double n = r.eqn.factor(c1);
            rhs = rhs.mult(v1.pow(n / nc));
        }
        return lhs.eq((Expr)rhs).simplify();
    }

    public Expr linX(ChemEqn eqn, boolean left) throws Xcept {
        Chem.List xchem = left ? eqn.lchem : eqn.rchem;
        double[] coef = left ? eqn.lcoef : eqn.rcoef;
        ConstExpr etot = Expr.zero;
        for (int i = 0; i < xchem.size(); ++i) {
            Chem c = xchem.chem(i);
            double ni = coef[i];
            Expr e = Expr.cons((double)ni).mult(this.region.conc(c).pow(ni - 1.0));
            e = e.mult(this.concDTExpr(c));
            ConstExpr ep = Expr.one;
            for (int j = 0; j < xchem.size(); ++j) {
                if (j == i) continue;
                Chem cj = xchem.chem(j);
                double nj = coef[j];
                ep = ep.mult(this.region.conc(c).pow(nj));
            }
            e = e.mult((Expr)ep);
            etot = etot.add(e);
        }
        return etot.simplify();
    }

    public Expr concDTExpr(Chem c) throws Xcept {
        int inx = this.chem.indexOf((Object)c);
        Var e = this.concDTX[inx];
        if (e == null) {
            e = Expr.zero;
        }
        if (this.clamp[inx]) {
            return e;
        }
        for (int i = 0; i < this.reac.size(); ++i) {
            double n = this.reac.reac((int)i).eqn.factor(c);
            e = e.add(Expr.cons((double)n).mult((Expr)this.concF.var(i)));
        }
        return e.simplify();
    }

    public String diagInfo() {
        return "Fast reaction group " + (Object)((Object)this.chem) + " compartment " + (Object)((Object)this.region);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<FastGroup> {
        public List(int n) {
            super(n);
        }

        public FastGroup group(int i) {
            return (FastGroup)this.get(i);
        }
    }
}

