/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.FlowComp;
import JSim.bcl.mfax.FlowSource;
import JSim.bcl.mfax.Inject;
import JSim.bcl.mfax.MFComp;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Xcept;

public abstract class Flow
extends MFComp {
    FlowComp incomp;
    FlowComp outcomp;
    RealNVar flow;
    Inject.List inject;
    Expr srcFin;

    public Flow(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.flow = new RealNVar(this, "flow", this.sys.tlist());
        this.inject = new Inject.List(1);
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            this.addChem(this.sys.chem.chem(i));
        }
    }

    protected void addChem(Chem c) throws Xcept {
        this.addConc(c);
    }

    protected void attach(boolean isin, FlowComp fc) throws Xcept {
        if (isin) {
            this.incomp = fc;
        } else {
            this.outcomp = fc;
        }
        fc.attach(!isin, this);
    }

    protected void attach(Inject i) {
        this.inject.add((Object)i);
    }

    protected void setInflow(Expr fx) throws Xcept {
        if (((Object)((Object)this)).getClass() == FlowSource.class) {
            this.srcFin = fx;
        } else {
            this.setVar(this.flow, fx, true);
        }
    }

    protected void solve2() throws Xcept {
        super.solve2();
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            Chem c = this.sys.chem.chem(i);
            Object e = Expr.zero;
            if (this.incomp != null) {
                e = this.incomp.conc(c);
                if (this.srcFin != null) {
                    e = e.mult(this.srcFin.div((Expr)this.flow));
                }
            }
            for (int j = 0; j < this.inject.size(); ++j) {
                Inject inj = (Inject)this.inject.comp(j);
                if (inj.chem != c) continue;
                e = e.add(inj.flux.div((Expr)this.flow));
            }
            this.setVar(this.conc(c), (Expr)e, true);
        }
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        this.assignConcUnits();
    }

    public static class List
    extends Comp.List {
        public List(int n) {
            super(n);
        }
    }
}

