/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.Flow;
import JSim.bcl.mfax.FlowComp;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.ConstExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class FlowJunc
extends FlowComp {
    Expr totflow;

    public FlowJunc(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.checkNParm(e, 0);
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            this.addChem(this.sys.chem.chem(i));
        }
    }

    protected void addChem(Chem c) throws Xcept {
        this.addConc(c);
    }

    protected void attach(boolean isin, Flow f) throws Xcept {
        super.attach(isin, f);
        if (!isin) {
            new RealNVar(this, f.name() + "wgt", this.sys.tlist());
        }
    }

    protected RealNVar wgt(Flow f) throws Xcept {
        Comp c = this.getChild(f.name() + "wgt");
        if (c == null) {
            throw new Xcept((DiagInfo)this, "missing weight");
        }
        return (RealNVar)c;
    }

    protected void solve1() throws Xcept {
        Flow f;
        int i;
        super.solve1();
        if (this.inflows.size() == 0 && this.outflows.size() == 0) {
            return;
        }
        if (this.inflows.size() == 0) {
            throw new Xcept((DiagInfo)this, "no inflow");
        }
        if (this.outflows.size() == 0) {
            throw new Xcept((DiagInfo)this, "no outflow");
        }
        this.totflow = Expr.zero;
        for (int i2 = 0; i2 < this.inflows.size(); ++i2) {
            Flow f2 = (Flow)this.inflows.comp(i2);
            this.totflow = this.totflow.add((Expr)f2.flow);
        }
        ConstExpr totwgt = Expr.zero;
        for (i = 0; i < this.outflows.size(); ++i) {
            f = (Flow)this.outflows.comp(i);
            totwgt = totwgt.add((Expr)this.wgt(f));
            if (this.outflows.size() != 1) continue;
            this.wgt(f).setAccess(2);
        }
        for (i = 0; i < this.outflows.size(); ++i) {
            f = (Flow)this.outflows.comp(i);
            Expr e = this.totflow.mult(this.wgt(f).div((Expr)totwgt));
            f.setInflow(e);
        }
    }

    protected void solve2() throws Xcept {
        int i;
        super.solve2();
        if (this.inflows.size() == 0) {
            return;
        }
        for (i = 0; i < this.sys.chem.size(); ++i) {
            Chem c = this.sys.chem.chem(i);
            ConstExpr totamt = Expr.zero;
            for (int j = 0; j < this.inflows.size(); ++j) {
                Flow f = (Flow)this.inflows.comp(j);
                totamt = totamt.add(f.flow.mult((Expr)f.conc(c)));
            }
            this.setVar(this.conc(c), totamt.div(this.totflow), true);
        }
        for (i = 0; i < this.outflows.size(); ++i) {
            Flow f = (Flow)this.outflows.comp(i);
            this.setVar(this.wgt(f), (Expr)Expr.one, false);
        }
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        for (int i = 0; i < this.outflows.size(); ++i) {
            Flow f = (Flow)this.outflows.comp(i);
            this.setVarUnit(this.wgt(f), Unit.scalar());
        }
        this.assignConcUnits();
    }
}

