/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.ReactionSlow;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class ReactionMassr
extends ReactionSlow {
    RealNVar kf;
    RealNVar kb;

    public ReactionMassr(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.kf = new RealNVar(this, "kf", this.sys.tlist());
        this.kb = new RealNVar(this, "kb", this.sys.tlist());
    }

    public Expr concDelta(Chem ch) throws Xcept {
        double tot = this.eqn.factor(ch);
        if (tot == 0.0) {
            return Expr.zero;
        }
        RealNVar lx = this.kf;
        for (int i = 0; i < this.eqn.lchem.size(); ++i) {
            Chem c = this.eqn.lchem.chem(i);
            lx = lx.mult(this.region.conc(c).pow(this.eqn.lfactor(c)));
        }
        RealNVar rx = this.kb;
        for (int i = 0; i < this.eqn.rchem.size(); ++i) {
            Chem c = this.eqn.rchem.chem(i);
            rx = rx.mult(this.region.conc(c).pow(this.eqn.rfactor(c)));
        }
        return tot < 0.0 ? rx.sub((Expr)lx).mult((Expr)Expr.cons((double)(-tot))) : lx.sub((Expr)rx).mult((Expr)Expr.cons((double)tot));
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        Chem c = this.eqn.rchem.chem(0);
        double n = this.eqn.rtot() - 1.0;
        Unit kbunit = Unit.scalar();
        if (n != 0.0) {
            kbunit = kbunit.div(c.unit().power(n));
        }
        kbunit = kbunit.div(this.timeUnit());
        this.setVarUnit(this.kb, kbunit);
        n = this.eqn.ltot() - 1.0;
        c = this.eqn.lchem.chem(0);
        Unit kfunit = Unit.scalar();
        if (n != 0.0) {
            kfunit = kfunit.div(c.unit().power(n));
        }
        kfunit = kfunit.div(this.timeUnit());
        this.setVarUnit(this.kf, kfunit);
    }
}

