/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.ReactionFlux;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class ReactionUUI
extends ReactionFlux {
    RealNVar Vm;
    RealNVar Km;

    public ReactionUUI(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        if (this.eqn.rchem.size() != 1 || this.eqn.lchem.size() != 1) {
            throw new Xcept((DiagInfo)this, "ReactionUUI requires single substate & product");
        }
        this.Vm = new RealNVar(this, "Vm", this.sys.tlist());
        this.Km = new RealNVar(this, "Km", this.sys.tlist());
        RealNVar S = this.region.conc(this.eqn.lchem.chem(0));
        Expr fx = this.Vm.mult((Expr)S).div(this.Km.add((Expr)S));
        this.setVar(this.flux, fx, true);
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        Chem c = this.eqn.lchem.chem(0);
        Unit vmunit = c.unit().div(this.timeUnit());
        this.setVarUnit(this.Vm, vmunit);
        this.setVarUnit(this.Km, c.unit());
    }
}

