/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.RealConst;
import JSim.util.Unit;
import JSim.util.Xcept;

public class CMLApply
extends NamedList {
    public CMLApply() throws Xcept {
        super(64);
        new ConstOp(this, "pi", Math.PI);
        new IExprOp(this, "eq", 41);
        new IExprOp(this, "neq", 42);
        new IExprOp(this, "gt", 45);
        new IExprOp(this, "lt", 43);
        new IExprOp(this, "geq", 46);
        new IExprOp(this, "leq", 44);
        new NestedBOp(this, "plus", 31);
        new NestedBOp(this, "times", 33);
        new IExprOp(this, "divide", 34);
        new IExprOp(this, "power", 35);
        new IExprOp(this, "rem", 37);
        new IExprOp(this, "abs", 18);
        new IExprOp(this, "exp", 8);
        new IExprOp(this, "ln", 3);
        new IExprOp(this, "log", 4);
        new IExprOp(this, "floor", 20);
        new IExprOp(this, "ceiling", 19);
        new IExprOp(this, "and", 51);
        new IExprOp(this, "or", 52);
        new IExprOp(this, "not", 27);
        new IExprOp(this, "sin", 5);
        new IExprOp(this, "cos", 6);
        new IExprOp(this, "tan", 7);
        new IExprOp(this, "arcsin", 10);
        new IExprOp(this, "arccos", 11);
        new IExprOp(this, "sinh", 12);
        new IExprOp(this, "cosh", 13);
        new IExprOp(this, "tanh", 14);
        new IExprOp(this, "arcsinh", 15);
        new IExprOp(this, "arccosh", 16);
        new IExprOp(this, "arctanh", 17);
        new IExprOp(this, "root", 9);
        new IExprOp(this, "minus", 32){

            public Expr makeExpr(Expr.List args) throws Xcept {
                if (args.size() == 1) {
                    return Expr.negone.mult(args.expr(0));
                }
                return super.makeExpr(args);
            }
        };
        new IExprOp(this, "diff", 38){

            public Expr makeExpr(Expr.List args) throws Xcept {
                CMLVar v1;
                int ct = args.size();
                Expr.List nargs = new Expr.List(ct);
                for (int i = 0; i < ct; ++i) {
                    nargs.add((Object)args.expr(ct - 1 - i));
                }
                CMLVar v0 = nargs.expr(0) instanceof CMLVar ? (CMLVar)nargs.expr(0) : null;
                CMLVar cMLVar = v1 = nargs.expr(1) instanceof CMLVar ? (CMLVar)nargs.expr(1) : null;
                if (v0 != null) {
                    v0.hasDeriv = true;
                }
                if (v1 != null) {
                    v1.isDomain = true;
                    if (v0 != null) {
                        v0.domains.addUniq((Expr)v1);
                    }
                }
                return super.makeExpr(nargs);
            }
        };
    }

    public Op op(String n) {
        return (Op)this.getByName(n);
    }

    public class NestedBOp
    extends IExprOp {
        public NestedBOp(CMLApply apply, String n, int c) throws Xcept {
            super(apply, n, c);
        }

        public Expr makeExpr(Expr.List args) throws Xcept {
            this.checkNArgs(this.opct, args, false);
            Expr expr = args.expr(0);
            for (int i = 1; i < args.size(); ++i) {
                Expr.List bargs = new Expr.List(2);
                bargs.add((Object)expr);
                bargs.add((Object)args.expr(i));
                expr = IExpr.create((int)this.opcode, (Expr.List)bargs);
            }
            return expr;
        }
    }

    public static class DimlessOp
    extends IExprOp {
        public DimlessOp(CMLApply apply, String n, int c) throws Xcept {
            super(apply, n, c);
            if (this.opct != 1) {
                throw new Xcept("DimlessOp requires opct=1: " + n);
            }
        }

        public Expr makeExpr(Expr.List args) throws Xcept {
            this.checkNArgs(this.opct, args, true);
            Unit uarg = null;
            Expr carg0 = args.expr(0).unitCorrect();
            uarg = carg0.unit();
            if (!Unit.compatible((Unit)uarg, (Unit)Unit.scalar())) {
                args = new Expr.List(1);
                args.add((Object)carg0.div((Expr)new RealConst(1.0, uarg)));
            }
            IExpr ret = IExpr.create((int)this.opcode, (Expr.List)args);
            if (uarg != null) {
                ret = ret.mult((Expr)new RealConst(1.0, uarg));
            }
            return ret;
        }
    }

    public static class IExprOp
    extends Op {
        public int opcode;
        public int opct;

        public IExprOp(CMLApply apply, String n, int c) throws Xcept {
            super(apply, n);
            this.opcode = c;
            this.opct = IExpr.opct((int)this.opcode);
        }

        public Expr makeExpr(Expr.List args) throws Xcept {
            this.checkNArgs(this.opct, args, true);
            return IExpr.create((int)this.opcode, (Expr.List)args);
        }
    }

    public static class ConstOp
    extends Op {
        Expr constExpr;

        public ConstOp(CMLApply apply, String n, double v) throws Xcept {
            super(apply, n);
            this.constExpr = Expr.cons((double)v);
        }

        public Expr makeExpr(Expr.List args) throws Xcept {
            this.checkNArgs(0, args, true);
            return this.constExpr;
        }
    }

    public static class Op
    implements Named {
        public String name;

        public Op(CMLApply apply, String n) {
            this.name = n;
            apply.add(this);
        }

        public String name() {
            return this.name;
        }

        public String diagInfo() {
            return "<apply> operator <" + this.name + ">";
        }

        public Expr makeExpr(Expr.List args) throws Xcept {
            throw new Xcept((DiagInfo)this, "Not yet supported");
        }

        public void checkNArgs(int ct, Expr.List args, boolean exact) throws Xcept {
            boolean pass;
            boolean bl = exact ? ct == args.size() : (pass = ct <= args.size());
            if (pass) {
                return;
            }
            throw new Xcept((DiagInfo)this, "Operator " + this.name + " requires " + (exact ? "exactly " : "at least ") + ct + " args, " + args.size() + " found.");
        }
    }
}

