/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLDoc;
import JSim.cellml.CMLEqn;
import JSim.cellml.CMLMath;
import JSim.cellml.CMLReac;
import JSim.cellml.CMLVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMLComp
implements Named {
    protected CMLDoc doc;
    private String name;
    protected CMLVar.NList vars;
    protected CMLEqn.List eqns;
    protected CMLReac.List reacs;

    protected CMLComp(CMLDoc d, Element elem) throws Xcept {
        int i;
        this.doc = d;
        this.name = elem.getAttribute("name");
        Util.verbose((String)("processing component " + this.name));
        this.vars = new CMLVar.NList();
        this.eqns = new CMLEqn.List();
        this.reacs = new CMLReac.List();
        NodeList nodes = elem.getElementsByTagName("variable");
        for (i = 0; i < nodes.getLength(); ++i) {
            CMLVar v = new CMLVar(this, (Element)nodes.item(i));
            this.vars.add((Named)v);
        }
        nodes = elem.getElementsByTagName("math");
        for (i = 0; i < nodes.getLength(); ++i) {
            CMLMath m = new CMLMath(this, (Element)nodes.item(i));
            for (int j = 0; j < m.exprs.size(); ++j) {
                CMLEqn e = new CMLEqn(this, m.exprs.expr(j));
                this.eqns.add(e);
            }
        }
        nodes = elem.getElementsByTagName("reaction");
        for (i = 0; i < nodes.getLength(); ++i) {
            CMLReac r = new CMLReac(this, (Element)nodes.item(i));
            this.reacs.add(r);
        }
    }

    protected boolean expandLHSDomains() throws Xcept {
        boolean addany = this.eqns.expandLHSDomains();
        for (int i = 0; i < this.reacs.size(); ++i) {
            addany = addany || this.reacs.reac(i).expandLHSDomains();
        }
        return addany;
    }

    protected void writeMML(PrintWriter out) throws Xcept {
        int i;
        out.println("");
        out.println("\t// <component name=\"" + this.name + "\">");
        for (i = 0; i < this.eqns.size(); ++i) {
            this.eqns.eqn(i).writeMML(out);
        }
        for (i = 0; i < this.reacs.size(); ++i) {
            this.reacs.reac(i).writeMML(out);
        }
    }

    public boolean hasLHSEqn(CMLVar v) {
        if (this.eqns.hasLHSVar(v)) {
            return true;
        }
        for (int i = 0; i < this.reacs.size(); ++i) {
            CMLReac reac = this.reacs.reac(i);
            for (int j = 0; j < reac.roles.size(); ++j) {
                if (!reac.roles.role((int)j).eqns.hasLHSVar(v)) continue;
                return true;
            }
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public String diagInfo() {
        return "CellML component " + this.name;
    }

    public String spaceName() {
        return this.name;
    }

    public CMLVar var(String n) {
        return this.vars.var(n);
    }

    public static class NList
    extends NamedList {
        public NList() {
            super(16);
        }

        public CMLComp comp(int i) {
            return (CMLComp)this.get(i);
        }

        public CMLComp comp(String n) {
            return (CMLComp)this.getByName(n);
        }
    }
}

