/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLComp;
import JSim.cellml.CMLDoc;
import JSim.cellml.CMLVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMLConnect {
    private CMLDoc doc;
    protected CMLComp comp1;
    protected CMLComp comp2;
    protected Expr.List vars1;
    protected Expr.List vars2;

    protected CMLConnect(CMLDoc d, Element elem) throws Xcept {
        this.doc = d;
        Util.verbose((String)"processing connection");
        NodeList nodes = elem.getElementsByTagName("map_components");
        if (nodes.getLength() != 1) {
            throw new Xcept("<connect> requires unique <map_components> element.");
        }
        Element mapComp = (Element)nodes.item(0);
        this.comp1 = this.getComp(mapComp, "component_1");
        this.comp2 = this.getComp(mapComp, "component_2");
        Util.verbose((String)("  " + this.comp1.name() + " " + this.comp2.name()));
        this.vars1 = new Expr.List(8);
        this.vars2 = new Expr.List(8);
        nodes = elem.getElementsByTagName("map_variables");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element mapv = (Element)nodes.item(i);
            CMLVar v1 = this.getVar(mapv, "variable_1", this.comp1);
            CMLVar v2 = this.getVar(mapv, "variable_2", this.comp2);
            this.vars1.add((Object)v1);
            this.vars2.add((Object)v2);
            v1.connectVars.add(v2);
            v2.connectVars.add(v1);
        }
    }

    private CMLComp getComp(Element mapc, String attr) throws Xcept {
        String name = mapc.getAttribute(attr);
        if (Util.isBlank((String)name)) {
            throw new Xcept("<map_components> tag missing \"" + attr + "\" attribute.");
        }
        CMLComp c = this.doc.comps.comp(name);
        if (c == null) {
            throw new Xcept("Unknown component \"" + name + "\" in <connection>.");
        }
        return c;
    }

    private CMLVar getVar(Element mapv, String attr, CMLComp comp) throws Xcept {
        String name = mapv.getAttribute(attr);
        if (Util.isBlank((String)name)) {
            throw new Xcept((DiagInfo)comp, "<map_variables> tag missing \"" + attr + "\" attribute.");
        }
        CMLVar v = comp.vars.var(name);
        if (v == null) {
            throw new Xcept((DiagInfo)comp, "Unknown variable \"" + name + "\" in <connection>.");
        }
        return v;
    }

    protected void writeMML(PrintWriter out) throws Xcept {
        for (int i = 0; i < this.vars1.size(); ++i) {
            CMLVar v1 = (CMLVar)this.vars1.expr(i);
            CMLVar v2 = (CMLVar)this.vars2.expr(i);
            out.println("\t" + v1.mmlName() + " = " + v2.mmlName() + ";");
        }
    }

    public String toString() {
        return "CellML connection " + this.comp1.name() + " " + this.comp2.name();
    }

    public String diagInfo() {
        return this.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLConnect> {
        public CMLConnect connect(int i) {
            return (CMLConnect)this.get(i);
        }
    }
}

